/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.solver.fastSolver.flowInsensitive;

import heros.FlowFunction;
import heros.solver.Pair;
import heros.solver.PathEdge;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import soot.SootMethod;
import soot.Unit;
import soot.jimple.infoflow.collect.MyConcurrentHashMap;
import soot.jimple.infoflow.data.Abstraction;
import soot.jimple.infoflow.problems.AbstractInfoflowProblem;
import soot.jimple.infoflow.solver.IFollowReturnsPastSeedsHandler;
import soot.jimple.infoflow.solver.IInfoflowSolver;
import soot.jimple.infoflow.solver.SolverPeerGroup;
import soot.jimple.infoflow.solver.executors.InterruptableExecutor;
import soot.jimple.infoflow.solver.fastSolver.FastSolverLinkedNode;
import soot.jimple.infoflow.solver.fastSolver.flowInsensitive.FlowInsensitiveSolver;
import soot.jimple.infoflow.solver.functions.SolverCallFlowFunction;
import soot.jimple.infoflow.solver.functions.SolverCallToReturnFlowFunction;
import soot.jimple.infoflow.solver.functions.SolverNormalFlowFunction;
import soot.jimple.infoflow.solver.functions.SolverReturnFlowFunction;
import soot.jimple.toolkits.ide.icfg.BiDiInterproceduralCFG;

public class InfoflowSolver
extends FlowInsensitiveSolver<Unit, Abstraction, BiDiInterproceduralCFG<Unit, SootMethod>>
implements IInfoflowSolver {
    private IFollowReturnsPastSeedsHandler followReturnsPastSeedsHandler = null;
    private final AbstractInfoflowProblem problem;

    public InfoflowSolver(AbstractInfoflowProblem problem, InterruptableExecutor executor) {
        super(problem);
        this.problem = problem;
        this.executor = executor;
        problem.setSolver(this);
    }

    @Override
    protected InterruptableExecutor getExecutor() {
        return this.executor;
    }

    @Override
    public boolean processEdge(PathEdge<Unit, Abstraction> edge) {
        this.propagate((FastSolverLinkedNode)edge.factAtSource(), (SootMethod)this.icfg.getMethodOf(edge.getTarget()), (FastSolverLinkedNode)edge.factAtTarget(), null, false);
        return true;
    }

    @Override
    public void injectContext(IInfoflowSolver otherSolver, SootMethod callee, Abstraction d3, Unit callSite, Abstraction d2, Abstraction d1) {
        if (!this.addIncoming(callee, d3, callSite, d1, d2)) {
            return;
        }
        Collection<Unit> returnSiteNs = this.icfg.getReturnSitesOfCallAt(callSite);
        this.applyEndSummaryOnCall(d1, callSite, d2, returnSiteNs, callee, d3);
    }

    @Override
    protected Set<Abstraction> computeReturnFlowFunction(FlowFunction<Abstraction> retFunction, Abstraction d1, Abstraction d2, Unit callSite, Collection<Abstraction> callerSideDs) {
        if (retFunction instanceof SolverReturnFlowFunction) {
            return ((SolverReturnFlowFunction)retFunction).computeTargets(d2, d1, callerSideDs);
        }
        return retFunction.computeTargets(d2);
    }

    @Override
    protected Set<Abstraction> computeNormalFlowFunction(FlowFunction<Abstraction> flowFunction, Abstraction d1, Abstraction d2) {
        if (flowFunction instanceof SolverNormalFlowFunction) {
            return ((SolverNormalFlowFunction)flowFunction).computeTargets(d1, d2);
        }
        return flowFunction.computeTargets(d2);
    }

    @Override
    protected Set<Abstraction> computeCallToReturnFlowFunction(FlowFunction<Abstraction> flowFunction, Abstraction d1, Abstraction d2) {
        if (flowFunction instanceof SolverCallToReturnFlowFunction) {
            return ((SolverCallToReturnFlowFunction)flowFunction).computeTargets(d1, d2);
        }
        return flowFunction.computeTargets(d2);
    }

    @Override
    protected Set<Abstraction> computeCallFlowFunction(FlowFunction<Abstraction> flowFunction, Abstraction d1, Abstraction d2) {
        if (flowFunction instanceof SolverCallFlowFunction) {
            return ((SolverCallFlowFunction)flowFunction).computeTargets(d1, d2);
        }
        return flowFunction.computeTargets(d2);
    }

    @Override
    public void cleanup() {
        this.jumpFunctions = new MyConcurrentHashMap();
        this.incoming.clear();
        this.endSummary.clear();
    }

    @Override
    public Set<Pair<Unit, Abstraction>> endSummary(SootMethod m3, Abstraction d3) {
        return super.endSummary(m3, d3);
    }

    @Override
    protected void processExit(Abstraction d1, Unit n, Abstraction d2) {
        SootMethod methodThatNeedsSummary;
        Map<Unit, Map<Abstraction, Abstraction>> inc;
        super.processExit(d1, n, d2);
        if (this.followReturnsPastSeeds && this.followReturnsPastSeedsHandler != null && ((inc = this.incoming(d1, methodThatNeedsSummary = (SootMethod)this.icfg.getMethodOf(n))) == null || inc.isEmpty())) {
            this.followReturnsPastSeedsHandler.handleFollowReturnsPastSeeds(d1, n, d2);
        }
    }

    @Override
    public void setFollowReturnsPastSeedsHandler(IFollowReturnsPastSeedsHandler handler) {
        this.followReturnsPastSeedsHandler = handler;
    }

    @Override
    public long getPropagationCount() {
        return this.propagationCount;
    }

    @Override
    public void setSolverId(boolean solverId) {
        super.setSolverId(solverId);
    }

    @Override
    public AbstractInfoflowProblem getTabulationProblem() {
        return this.problem;
    }

    @Override
    public void setPeerGroup(SolverPeerGroup solverPeerGroup) {
    }

    @Override
    public void terminate() {
    }
}

