/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.solver.gcSolver;

import heros.solver.PathEdge;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import soot.SootMethod;
import soot.jimple.infoflow.collect.ConcurrentCountingMap;
import soot.jimple.infoflow.collect.ConcurrentHashSet;
import soot.jimple.infoflow.solver.gcSolver.AbstractGarbageCollector;
import soot.jimple.infoflow.solver.gcSolver.GarbageCollectionTrigger;
import soot.jimple.infoflow.solver.gcSolver.GarbageCollectorPeerGroup;
import soot.jimple.infoflow.solver.gcSolver.IGCReferenceProvider;
import soot.jimple.infoflow.solver.gcSolver.IGarbageCollectorPeer;
import soot.jimple.infoflow.util.ExtendedAtomicInteger;
import soot.jimple.toolkits.ide.icfg.BiDiInterproceduralCFG;
import soot.util.ConcurrentHashMultiMap;

public abstract class AbstractReferenceCountingGarbageCollector<N, D>
extends AbstractGarbageCollector<N, D>
implements IGarbageCollectorPeer {
    private ConcurrentCountingMap<SootMethod> jumpFnCounter = new ConcurrentCountingMap();
    private final Set<SootMethod> gcScheduleSet = new ConcurrentHashSet<SootMethod>();
    private final AtomicInteger gcedMethods = new AtomicInteger();
    private final AtomicInteger gcedEdges = new AtomicInteger();
    private final ExtendedAtomicInteger edgeCounterForThreshold = new ExtendedAtomicInteger();
    private GarbageCollectionTrigger trigger = GarbageCollectionTrigger.Immediate;
    private GarbageCollectorPeerGroup peerGroup = null;
    private boolean checkChangeCounter = false;
    protected boolean validateEdges = false;
    protected Set<PathEdge<N, D>> oldEdges = new HashSet<PathEdge<N, D>>();
    protected int methodThreshold = 0;
    protected int edgeThreshold = 0;

    public AbstractReferenceCountingGarbageCollector(BiDiInterproceduralCFG<N, SootMethod> icfg, ConcurrentHashMultiMap<SootMethod, PathEdge<N, D>> jumpFunctions, IGCReferenceProvider<D, N> referenceProvider) {
        super(icfg, jumpFunctions, referenceProvider);
    }

    public AbstractReferenceCountingGarbageCollector(BiDiInterproceduralCFG<N, SootMethod> icfg, ConcurrentHashMultiMap<SootMethod, PathEdge<N, D>> jumpFunctions) {
        super(icfg, jumpFunctions);
    }

    @Override
    public void notifyEdgeSchedule(PathEdge<N, D> edge) {
        SootMethod sm = (SootMethod)this.icfg.getMethodOf(edge.getTarget());
        this.jumpFnCounter.increment(sm);
        this.gcScheduleSet.add(sm);
        if (this.trigger == GarbageCollectionTrigger.EdgeThreshold) {
            this.edgeCounterForThreshold.incrementAndGet();
        }
        if (this.validateEdges && this.oldEdges.contains(edge)) {
            System.out.println("Edge re-scheduled");
        }
    }

    @Override
    public void notifyTaskProcessed(PathEdge<N, D> edge) {
        this.jumpFnCounter.decrement((SootMethod)this.icfg.getMethodOf(edge.getTarget()));
    }

    private boolean hasActiveDependencies(SootMethod method, ConcurrentCountingMap<SootMethod> referenceCounter) {
        int changeCounter = -1;
        do {
            changeCounter = referenceCounter.getChangeCounter();
            if (referenceCounter.get(method) > 0) {
                return true;
            }
            Set<SootMethod> references = this.referenceProvider.getMethodReferences(method, null);
            for (SootMethod ref : references) {
                if (referenceCounter.get(ref) <= 0) continue;
                return true;
            }
        } while (this.checkChangeCounter && changeCounter != referenceCounter.getChangeCounter());
        return false;
    }

    @Override
    public boolean hasActiveDependencies(SootMethod method) {
        return this.hasActiveDependencies(method, this.jumpFnCounter);
    }

    protected void gcImmediate() {
        if (this.gcScheduleSet != null && !this.gcScheduleSet.isEmpty()) {
            boolean gc = this.trigger == GarbageCollectionTrigger.Immediate;
            gc |= this.trigger == GarbageCollectionTrigger.MethodThreshold && this.gcScheduleSet.size() > this.methodThreshold;
            if (gc |= this.trigger == GarbageCollectionTrigger.EdgeThreshold && this.edgeCounterForThreshold.get() > this.edgeThreshold) {
                int tempMethods = 0;
                this.onBeforeRemoveEdges();
                for (SootMethod sm : this.gcScheduleSet) {
                    if (this.peerGroup == null ? this.hasActiveDependencies(sm) : this.peerGroup.hasActiveDependencies(sm)) continue;
                    Set oldFunctions = this.jumpFunctions.get(sm);
                    if (oldFunctions != null) {
                        int gcedSize = oldFunctions.size();
                        this.gcedEdges.addAndGet(gcedSize);
                        if (this.trigger == GarbageCollectionTrigger.EdgeThreshold) {
                            this.edgeCounterForThreshold.subtract(gcedSize);
                        }
                    }
                    this.gcScheduleSet.remove(sm);
                    if (!this.jumpFunctions.remove(sm)) continue;
                    this.gcedMethods.incrementAndGet();
                    ++tempMethods;
                    if (!this.validateEdges) continue;
                    this.oldEdges.addAll(oldFunctions);
                }
                this.onAfterRemoveEdges(tempMethods);
            }
        }
    }

    protected void onBeforeRemoveEdges() {
    }

    protected void onAfterRemoveEdges(int gcedMethods) {
    }

    @Override
    public int getGcedMethods() {
        return this.gcedMethods.get();
    }

    @Override
    public int getGcedEdges() {
        return this.gcedEdges.get();
    }

    public void setMethodThreshold(int threshold) {
        this.methodThreshold = threshold;
    }

    public void setEdgeThreshold(int threshold) {
        this.edgeThreshold = threshold;
    }

    public void setTrigger(GarbageCollectionTrigger trigger) {
        this.trigger = trigger;
    }

    public void setPeerGroup(GarbageCollectorPeerGroup peerGroup) {
        this.peerGroup = peerGroup;
        peerGroup.addGarbageCollector(this);
    }

    public void setCheckChangeCounter(boolean checkChangeCounter) {
        this.checkChangeCounter = checkChangeCounter;
    }
}

