/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.solver.gcSolver;

import heros.solver.PathEdge;
import soot.SootMethod;
import soot.jimple.infoflow.solver.gcSolver.AbstractReferenceCountingGarbageCollector;
import soot.jimple.infoflow.solver.gcSolver.IGCReferenceProvider;
import soot.jimple.toolkits.ide.icfg.BiDiInterproceduralCFG;
import soot.util.ConcurrentHashMultiMap;

public class ThreadedGarbageCollector<N, D>
extends AbstractReferenceCountingGarbageCollector<N, D> {
    private int sleepTimeSeconds = 10;
    private GCThread gcThread;

    public ThreadedGarbageCollector(BiDiInterproceduralCFG<N, SootMethod> icfg, ConcurrentHashMultiMap<SootMethod, PathEdge<N, D>> jumpFunctions, IGCReferenceProvider<D, N> referenceProvider) {
        super(icfg, jumpFunctions, referenceProvider);
    }

    public ThreadedGarbageCollector(BiDiInterproceduralCFG<N, SootMethod> icfg, ConcurrentHashMultiMap<SootMethod, PathEdge<N, D>> jumpFunctions) {
        super(icfg, jumpFunctions);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.gcThread = new GCThread();
        this.gcThread.start();
    }

    @Override
    public void gc() {
    }

    @Override
    public void notifySolverTerminated() {
        this.gcThread.finish();
    }

    public void setSleepTimeSeconds(int sleepTimeSeconds) {
        this.sleepTimeSeconds = sleepTimeSeconds;
    }

    private class GCThread
    extends Thread {
        private boolean finished = false;

        public GCThread() {
            this.setName("IFDS Garbage Collector");
        }

        @Override
        public void run() {
            while (!this.finished) {
                ThreadedGarbageCollector.this.gcImmediate();
                if (ThreadedGarbageCollector.this.sleepTimeSeconds <= 0) continue;
                try {
                    Thread.sleep(ThreadedGarbageCollector.this.sleepTimeSeconds * 1000);
                }
                catch (InterruptedException e) {
                    break;
                }
            }
        }

        public void finish() {
            this.finished = true;
            this.interrupt();
        }
    }
}

