/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.taintWrappers;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import soot.SootMethod;
import soot.jimple.Stmt;
import soot.jimple.infoflow.InfoflowManager;
import soot.jimple.infoflow.data.Abstraction;
import soot.jimple.infoflow.taintWrappers.IReversibleTaintWrapper;
import soot.jimple.infoflow.taintWrappers.ITaintPropagationWrapper;

public class TaintWrapperList
implements IReversibleTaintWrapper {
    private List<ITaintPropagationWrapper> wrappers = new ArrayList<ITaintPropagationWrapper>();
    private AtomicInteger hits = new AtomicInteger();
    private AtomicInteger misses = new AtomicInteger();

    public TaintWrapperList(ITaintPropagationWrapper ... wrappers) {
        for (ITaintPropagationWrapper w : wrappers) {
            if (w == null) continue;
            this.addWrapper(w);
        }
    }

    @Override
    public void initialize(InfoflowManager manager) {
        for (ITaintPropagationWrapper w : this.wrappers) {
            w.initialize(manager);
        }
    }

    public void addWrapper(ITaintPropagationWrapper wrapper) {
        this.wrappers.add(wrapper);
    }

    @Override
    public Set<Abstraction> getTaintsForMethod(Stmt stmt, Abstraction d1, Abstraction taintedPath) {
        for (ITaintPropagationWrapper w : this.wrappers) {
            Set<Abstraction> curAbsSet = w.getTaintsForMethod(stmt, d1, taintedPath);
            if (curAbsSet == null || curAbsSet.isEmpty()) continue;
            this.hits.incrementAndGet();
            return curAbsSet;
        }
        this.misses.incrementAndGet();
        return null;
    }

    @Override
    public boolean isExclusive(Stmt stmt, Abstraction taintedPath) {
        for (ITaintPropagationWrapper w : this.wrappers) {
            if (!w.isExclusive(stmt, taintedPath)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean supportsCallee(SootMethod method) {
        for (ITaintPropagationWrapper w : this.wrappers) {
            if (!w.supportsCallee(method)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean supportsCallee(Stmt callSite) {
        for (ITaintPropagationWrapper w : this.wrappers) {
            if (!w.supportsCallee(callSite)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getWrapperHits() {
        return this.hits.get();
    }

    @Override
    public int getWrapperMisses() {
        return this.misses.get();
    }

    @Override
    public Set<Abstraction> getAliasesForMethod(Stmt stmt, Abstraction d1, Abstraction taintedPath) {
        for (ITaintPropagationWrapper w : this.wrappers) {
            Set<Abstraction> curAbsSet = w.getAliasesForMethod(stmt, d1, taintedPath);
            if (curAbsSet == null || curAbsSet.isEmpty()) continue;
            return curAbsSet;
        }
        return null;
    }

    @Override
    public Set<Abstraction> getInverseTaintsForMethod(Stmt stmt, Abstraction d1, Abstraction taintedPath) {
        for (ITaintPropagationWrapper w : this.wrappers) {
            Set<Abstraction> curAbsSet;
            if (!(w instanceof IReversibleTaintWrapper) || (curAbsSet = ((IReversibleTaintWrapper)w).getInverseTaintsForMethod(stmt, d1, taintedPath)) == null || curAbsSet.isEmpty()) continue;
            return curAbsSet;
        }
        return null;
    }
}

