/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArgParser {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static String METHODKEYWORD = "-entrypoints";
    public static String SOURCEKEYWORD = "-sources";
    public static String SINKKEYWORD = "-sinks";
    public static String PATHKEYWORD = "-path";

    public List<List<String>> parseClassArguments(String[] args) {
        List<String> argList = Arrays.asList(args);
        List<Object> sourceList = new ArrayList();
        List<Object> sinkList = new ArrayList();
        List<Object> pathList = new ArrayList();
        if (!argList.contains(METHODKEYWORD)) {
            this.logger.error("parameter '" + METHODKEYWORD + "' is missing or has not enough arguments!");
            return null;
        }
        List<String> ePointList = this.getListToAttribute(argList, METHODKEYWORD);
        if (argList.contains(SOURCEKEYWORD)) {
            sourceList = this.getListToAttribute(argList, SOURCEKEYWORD);
        }
        if (argList.contains(SINKKEYWORD)) {
            sinkList = this.getListToAttribute(argList, SINKKEYWORD);
        }
        if (argList.contains(PATHKEYWORD)) {
            pathList = this.getListToAttribute(argList, PATHKEYWORD);
        }
        ArrayList<List<String>> resultlist = new ArrayList<List<String>>();
        resultlist.add(ePointList);
        resultlist.add(sourceList);
        resultlist.add(sinkList);
        resultlist.add(pathList);
        return resultlist;
    }

    private List<String> getListToAttribute(List<String> argList, String attr) {
        ArrayList<String> result = new ArrayList<String>();
        if (argList.indexOf(attr) + 1 < argList.size() && !argList.get(argList.indexOf(attr) + 1).startsWith("-")) {
            int position = argList.indexOf(attr);
            while (position + 1 < argList.size() && !argList.get(position + 1).startsWith("-")) {
                result.add(argList.get(position + 1));
                ++position;
            }
        }
        return result;
    }
}

