/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.util;

import soot.ArrayType;
import soot.BooleanType;
import soot.ByteType;
import soot.CharType;
import soot.DoubleType;
import soot.FastHierarchy;
import soot.FloatType;
import soot.IntType;
import soot.LongType;
import soot.PrimType;
import soot.RefType;
import soot.Scene;
import soot.ShortType;
import soot.SootClass;
import soot.Type;
import soot.jimple.infoflow.InfoflowManager;
import soot.jimple.infoflow.data.AccessPath;

public class TypeUtils {
    private final InfoflowManager manager;

    public TypeUtils(InfoflowManager manager) {
        this.manager = manager;
    }

    public static boolean isStringType(Type tp) {
        if (!(tp instanceof RefType)) {
            return false;
        }
        RefType refType = (RefType)tp;
        return refType.getClassName().equals("java.lang.String");
    }

    public static boolean isObjectLikeType(Type tp) {
        if (!(tp instanceof RefType)) {
            return false;
        }
        RefType rt = (RefType)tp;
        String className = rt.getSootClass().getName();
        return className.equals("java.lang.Object") || className.equals("java.io.Serializable") || className.equals("java.lang.Cloneable");
    }

    public boolean checkCast(Type destType, Type sourceType) {
        if (!this.manager.getConfig().getEnableTypeChecking()) {
            return true;
        }
        if (sourceType == null) {
            return true;
        }
        if (sourceType == destType) {
            return true;
        }
        FastHierarchy hierarchy = this.manager.getHierarchy();
        if (hierarchy != null && (hierarchy.canStoreType(destType, sourceType) || this.manager.getHierarchy().canStoreType(sourceType, destType))) {
            return true;
        }
        return destType instanceof PrimType && sourceType instanceof PrimType;
    }

    public boolean checkCast(AccessPath accessPath, Type type) {
        if (!this.manager.getConfig().getEnableTypeChecking()) {
            return true;
        }
        int fieldStartIdx = 0;
        if (accessPath.isStaticFieldRef()) {
            if (!this.checkCast(type, accessPath.getFirstFieldType())) {
                return false;
            }
            if (TypeUtils.isPrimitiveArray(type) && accessPath.getFieldCount() > 1) {
                return false;
            }
            fieldStartIdx = 1;
        } else {
            if (!this.checkCast(type, accessPath.getBaseType())) {
                return false;
            }
            if (TypeUtils.isPrimitiveArray(type) && !accessPath.isLocal()) {
                return false;
            }
        }
        return !accessPath.isFieldRef() || accessPath.getFieldCount() <= fieldStartIdx || this.checkCast(type, (Type)accessPath.getFields()[fieldStartIdx].getDeclaringClass().getType());
    }

    public static boolean isPrimitiveArray(Type type) {
        ArrayType at;
        return type instanceof ArrayType && (at = (ArrayType)type).getArrayElementType() instanceof PrimType;
    }

    public boolean hasCompatibleTypesForCall(AccessPath apBase, SootClass dest) {
        if (!this.manager.getConfig().getEnableTypeChecking()) {
            return true;
        }
        if (apBase.getBaseType() instanceof PrimType) {
            return false;
        }
        if (apBase.getBaseType() instanceof ArrayType) {
            return dest.getName().equals("java.lang.Object");
        }
        return this.checkCast(apBase, (Type)dest.getType());
    }

    public static Type getMorePreciseType(Type tp1, Type tp2) {
        FastHierarchy fastHierarchy = Scene.v().getOrMakeFastHierarchy();
        if (tp1 == null) {
            return tp2;
        }
        if (tp2 == null) {
            return tp1;
        }
        if (tp1 == tp2) {
            return tp1;
        }
        if (TypeUtils.isObjectLikeType(tp1)) {
            return tp2;
        }
        if (TypeUtils.isObjectLikeType(tp2)) {
            return tp1;
        }
        if (tp1 instanceof PrimType && tp2 instanceof PrimType) {
            return tp1;
        }
        if (fastHierarchy.canStoreType(tp2, tp1)) {
            return tp2;
        }
        if (fastHierarchy.canStoreType(tp1, tp2)) {
            return tp1;
        }
        if (tp1 instanceof ArrayType && tp2 instanceof ArrayType) {
            ArrayType at1 = (ArrayType)tp1;
            ArrayType at2 = (ArrayType)tp2;
            if (at1.numDimensions != at2.numDimensions) {
                return null;
            }
            Type preciseType = TypeUtils.getMorePreciseType(at1.getElementType(), at2.getElementType());
            if (preciseType == null) {
                return null;
            }
            return ArrayType.v(preciseType, at1.numDimensions);
        }
        if (tp1 instanceof ArrayType) {
            ArrayType at = (ArrayType)tp1;
            return TypeUtils.getMorePreciseType(at.getElementType(), tp2);
        }
        if (tp2 instanceof ArrayType) {
            ArrayType at = (ArrayType)tp2;
            return TypeUtils.getMorePreciseType(tp1, at.getElementType());
        }
        return null;
    }

    public static String getMorePreciseType(String tp1, String tp2) {
        Type newType = TypeUtils.getMorePreciseType(TypeUtils.getTypeFromString(tp1), TypeUtils.getTypeFromString(tp2));
        return newType == null ? null : "" + newType;
    }

    public static Type getTypeFromString(String type) {
        Type t;
        if (type == null || type.isEmpty()) {
            return null;
        }
        int numDimensions = 0;
        while (type.endsWith("[]")) {
            ++numDimensions;
            type = type.substring(0, type.length() - 2);
        }
        if (type.equals("int")) {
            t = IntType.v();
        } else if (type.equals("long")) {
            t = LongType.v();
        } else if (type.equals("float")) {
            t = FloatType.v();
        } else if (type.equals("double")) {
            t = DoubleType.v();
        } else if (type.equals("boolean")) {
            t = BooleanType.v();
        } else if (type.equals("char")) {
            t = CharType.v();
        } else if (type.equals("short")) {
            t = ShortType.v();
        } else if (type.equals("byte")) {
            t = ByteType.v();
        } else if (Scene.v().containsClass(type)) {
            t = RefType.v(type);
        } else {
            return null;
        }
        if (numDimensions == 0) {
            return t;
        }
        return ArrayType.v(t, numDimensions);
    }

    public static Type buildArrayOrAddDimension(Type type, Type arrayType) {
        if (!(type instanceof ArrayType)) {
            return arrayType;
        }
        if (type instanceof ArrayType) {
            ArrayType array = (ArrayType)type;
            if (array.numDimensions >= 3) {
                return null;
            }
            return array.makeArrayType();
        }
        return ArrayType.v(type, 1);
    }
}

