/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.spark.solver;

import java.util.ArrayList;
import java.util.HashSet;
import soot.jimple.spark.pag.Node;
import soot.jimple.spark.pag.PAG;
import soot.jimple.spark.pag.VarNode;

public class TopoSorter {
    protected boolean ignoreTypes;
    protected PAG pag;
    protected int nextFinishNumber = 1;
    protected HashSet<VarNode> visited;

    public void sort() {
        for (VarNode v : this.pag.getVarNodeNumberer()) {
            this.dfsVisit(v);
        }
        this.visited = null;
    }

    public TopoSorter(PAG pag, boolean ignoreTypes) {
        this.pag = pag;
        this.ignoreTypes = ignoreTypes;
        this.visited = new HashSet();
    }

    protected void dfsVisit(VarNode n) {
        if (this.visited.contains(n)) {
            return;
        }
        ArrayList<VarNode> stack = new ArrayList<VarNode>();
        ArrayList<VarNode> all = new ArrayList<VarNode>();
        stack.add(n);
        while (!stack.isEmpty()) {
            Node[] succs;
            VarNode s2 = (VarNode)stack.remove(stack.size() - 1);
            if (!this.visited.add(s2)) continue;
            all.add(s2);
            for (Node element : succs = this.pag.simpleLookup(s2)) {
                if (!this.ignoreTypes && !this.pag.getTypeManager().castNeverFails(n.getType(), element.getType())) continue;
                stack.add((VarNode)element);
            }
        }
        for (int i = all.size() - 1; i >= 0; --i) {
            ((VarNode)all.get(i)).setFinishingNumber(this.nextFinishNumber++);
        }
    }
}

