/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.annotation.arraycheck;

import java.util.ArrayList;
import soot.toolkits.graph.HashMutableDirectedGraph;

public class ExtendedHashMutableDirectedGraph<N>
extends HashMutableDirectedGraph<N> {
    @Override
    public void addEdge(N from, N to) {
        if (!super.containsNode(from)) {
            super.addNode(from);
        }
        if (!super.containsNode(to)) {
            super.addNode(to);
        }
        super.addEdge(from, to);
    }

    public void addMutualEdge(N from, N to) {
        if (!super.containsNode(from)) {
            super.addNode(from);
        }
        if (!super.containsNode(to)) {
            super.addNode(to);
        }
        super.addEdge(from, to);
        super.addEdge(to, from);
    }

    public void skipNode(N node) {
        if (!super.containsNode(node)) {
            return;
        }
        ArrayList<N> origPreds = new ArrayList<N>(this.getPredsOf(node));
        ArrayList<N> origSuccs = new ArrayList<N>(this.getSuccsOf(node));
        for (N p : origPreds) {
            for (N s2 : origSuccs) {
                if (p == s2) continue;
                super.addEdge(p, s2);
            }
        }
        for (N element : origPreds) {
            super.removeEdge(element, node);
        }
        for (N element : origSuccs) {
            super.removeEdge(node, element);
        }
        super.removeNode(node);
    }

    public <T extends N> void mergeWith(ExtendedHashMutableDirectedGraph<T> other) {
        for (Object node : other.getNodes()) {
            for (Object succ : other.getSuccsOf(node)) {
                this.addEdge(node, succ);
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Graph:\n");
        for (Object node : super.getNodes()) {
            for (Object succ : super.getSuccsOf(node)) {
                sb.append(node).append("\t --- \t").append(succ).append('\n');
            }
        }
        return sb.toString();
    }
}

