/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.annotation.nullcheck;

import java.util.Map;
import soot.Body;
import soot.BodyTransformer;
import soot.Immediate;
import soot.Unit;
import soot.UnitPatchingChain;
import soot.Value;
import soot.jimple.BinopExpr;
import soot.jimple.EqExpr;
import soot.jimple.IfStmt;
import soot.jimple.Jimple;
import soot.jimple.NeExpr;
import soot.jimple.NullConstant;
import soot.jimple.Stmt;
import soot.jimple.toolkits.annotation.nullcheck.NullnessAnalysis;
import soot.toolkits.graph.ExceptionalUnitGraphFactory;
import soot.toolkits.graph.UnitGraph;

public class NullCheckEliminator
extends BodyTransformer {
    private AnalysisFactory analysisFactory;

    public NullCheckEliminator() {
        this(new AnalysisFactory());
    }

    public NullCheckEliminator(AnalysisFactory f) {
        this.analysisFactory = f;
    }

    @Override
    public void internalTransform(Body body, String phaseName, Map<String, String> options) {
        boolean changed;
        do {
            changed = false;
            NullnessAnalysis analysis = this.analysisFactory.newAnalysis(ExceptionalUnitGraphFactory.createExceptionalUnitGraph(body));
            UnitPatchingChain units = body.getUnits();
            Unit u = (Unit)units.getFirst();
            while (u != null) {
                block10: {
                    BinopExpr e;
                    Immediate i;
                    IfStmt is;
                    Value c;
                    if (u instanceof IfStmt && ((c = (is = (IfStmt)u).getCondition()) instanceof EqExpr || c instanceof NeExpr) && (i = (e = (BinopExpr)c).getOp2() instanceof NullConstant ? (Immediate)e.getOp1() : (e.getOp1() instanceof NullConstant ? (Immediate)e.getOp2() : null)) != null) {
                        Stmt newstmt;
                        int elim = 0;
                        if (analysis.isAlwaysNonNullBefore(u, i)) {
                            int n = elim = c instanceof EqExpr ? -1 : 1;
                        }
                        if (analysis.isAlwaysNullBefore(u, i)) {
                            elim = c instanceof EqExpr ? 1 : -1;
                        }
                        switch (elim) {
                            case -1: {
                                newstmt = Jimple.v().newNopStmt();
                                break;
                            }
                            case 1: {
                                newstmt = Jimple.v().newGotoStmt(is.getTarget());
                                break;
                            }
                            default: {
                                break block10;
                            }
                        }
                        assert (newstmt != null);
                        units.swapWith(u, newstmt);
                        u = newstmt;
                        changed = true;
                    }
                }
                u = units.getSuccOf(u);
            }
        } while (changed);
    }

    public static class AnalysisFactory {
        public NullnessAnalysis newAnalysis(UnitGraph g2) {
            return new NullnessAnalysis(g2);
        }
    }
}

