/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.annotation.nullcheck;

import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Body;
import soot.BodyTransformer;
import soot.G;
import soot.PhaseOptions;
import soot.Scene;
import soot.Singletons;
import soot.SootMethod;
import soot.UnitPatchingChain;
import soot.Value;
import soot.ValueBox;
import soot.jimple.InstanceFieldRef;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.IntConstant;
import soot.jimple.Jimple;
import soot.jimple.LengthExpr;
import soot.jimple.MonitorStmt;
import soot.jimple.Stmt;
import soot.jimple.ThrowStmt;
import soot.jimple.toolkits.annotation.nullcheck.BranchedRefVarsAnalysis;
import soot.jimple.toolkits.annotation.tags.NullCheckTag;
import soot.options.Options;
import soot.toolkits.graph.ExceptionalUnitGraphFactory;
import soot.toolkits.scalar.FlowSet;

public class NullPointerChecker
extends BodyTransformer {
    private static final Logger logger = LoggerFactory.getLogger(NullPointerChecker.class);

    public NullPointerChecker(Singletons.Global g2) {
    }

    public static NullPointerChecker v() {
        return G.v().soot_jimple_toolkits_annotation_nullcheck_NullPointerChecker();
    }

    @Override
    protected void internalTransform(Body body, String phaseName, Map<String, String> options) {
        boolean isProfiling = PhaseOptions.getBoolean(options, "profiling");
        boolean enableOther = !PhaseOptions.getBoolean(options, "onlyarrayref");
        Date start = new Date();
        if (Options.v().verbose()) {
            logger.debug("[npc] Null pointer check for " + body.getMethod().getName() + " started on " + start);
        }
        BranchedRefVarsAnalysis analysis = new BranchedRefVarsAnalysis(ExceptionalUnitGraphFactory.createExceptionalUnitGraph(body));
        SootMethod increase = isProfiling ? Scene.v().loadClassAndSupport("MultiCounter").getMethod("void increase(int)") : null;
        UnitPatchingChain units = body.getUnits();
        Iterator stmtIt = units.snapshotIterator();
        while (stmtIt.hasNext()) {
            boolean needCheck;
            Stmt s2 = (Stmt)stmtIt.next();
            Value obj = null;
            if (s2.containsArrayRef()) {
                obj = s2.getArrayRef().getBase();
            } else if (enableOther) {
                if (s2 instanceof ThrowStmt) {
                    obj = ((ThrowStmt)s2).getOp();
                } else if (s2 instanceof MonitorStmt) {
                    obj = ((MonitorStmt)s2).getOp();
                } else {
                    Value v;
                    for (ValueBox vBox : s2.getDefBoxes()) {
                        v = vBox.getValue();
                        if (v instanceof InstanceFieldRef) {
                            obj = ((InstanceFieldRef)v).getBase();
                            break;
                        }
                        if (v instanceof InstanceInvokeExpr) {
                            obj = ((InstanceInvokeExpr)v).getBase();
                            break;
                        }
                        if (!(v instanceof LengthExpr)) continue;
                        obj = ((LengthExpr)v).getOp();
                        break;
                    }
                    for (ValueBox vBox : s2.getUseBoxes()) {
                        v = vBox.getValue();
                        if (v instanceof InstanceFieldRef) {
                            obj = ((InstanceFieldRef)v).getBase();
                            break;
                        }
                        if (v instanceof InstanceInvokeExpr) {
                            obj = ((InstanceInvokeExpr)v).getBase();
                            break;
                        }
                        if (!(v instanceof LengthExpr)) continue;
                        obj = ((LengthExpr)v).getOp();
                        break;
                    }
                }
            }
            if (obj == null) continue;
            boolean bl = needCheck = analysis.anyRefInfo(obj, (FlowSet)analysis.getFlowBefore(s2)) != 2;
            if (isProfiling) {
                int count = needCheck ? 5 : 6;
                Jimple jimp = Jimple.v();
                units.insertBefore(jimp.newInvokeStmt(jimp.newStaticInvokeExpr(increase.makeRef(), (Value)IntConstant.v(count))), s2);
            }
            s2.addTag(new NullCheckTag(needCheck));
        }
        if (Options.v().verbose()) {
            Date finish = new Date();
            long runtime = finish.getTime() - start.getTime();
            long mins = runtime / 60000L;
            long secs = runtime % 60000L / 1000L;
            logger.debug("[npc] Null pointer checker finished. It took " + mins + " mins and " + secs + " secs.");
        }
    }
}

