/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.annotation.purity;

import java.util.Date;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Local;
import soot.RefLikeType;
import soot.SootMethod;
import soot.Type;
import soot.jimple.AssignStmt;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.StaticInvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.toolkits.annotation.purity.AbstractInterproceduralAnalysis;
import soot.jimple.toolkits.annotation.purity.PurityGraph;
import soot.jimple.toolkits.annotation.purity.PurityGraphBox;
import soot.jimple.toolkits.annotation.purity.PurityIntraproceduralAnalysis;
import soot.jimple.toolkits.annotation.purity.SootMethodFilter;
import soot.jimple.toolkits.callgraph.CallGraph;
import soot.options.PurityOptions;
import soot.tagkit.GenericAttribute;
import soot.tagkit.StringTag;
import soot.toolkits.graph.ExceptionalUnitGraph;
import soot.toolkits.graph.ExceptionalUnitGraphFactory;
import soot.util.dot.DotGraph;

public class PurityInterproceduralAnalysis
extends AbstractInterproceduralAnalysis<PurityGraphBox> {
    private static final Logger logger = LoggerFactory.getLogger(PurityInterproceduralAnalysis.class);
    private static final String[][] pureMethods = new String[][]{{"java.lang.", "valueOf"}, {"java.", "equals"}, {"javax.", "equals"}, {"sun.", "equals"}, {"java.", "compare"}, {"javax.", "compare"}, {"sun.", "compare"}, {"java.", "getClass"}, {"javax.", "getClass"}, {"sun.", "getClass"}, {"java.", "hashCode"}, {"javax.", "hashCode"}, {"sun.", "hashCode"}, {"java.", "toString"}, {"javax.", "toString"}, {"sun.", "toString"}, {"java.", "valueOf"}, {"javax.", "valueOf"}, {"sun.", "valueOf"}, {"java.", "compareTo"}, {"javax.", "compareTo"}, {"sun.", "compareTo"}, {"java.lang.System", "identityHashCode"}, {"java.", "<clinit>"}, {"javax.", "<clinit>"}, {"sun.", "<clinit>"}, {"java.lang.Math", "abs"}, {"java.lang.Math", "acos"}, {"java.lang.Math", "asin"}, {"java.lang.Math", "atan"}, {"java.lang.Math", "atan2"}, {"java.lang.Math", "ceil"}, {"java.lang.Math", "cos"}, {"java.lang.Math", "exp"}, {"java.lang.Math", "floor"}, {"java.lang.Math", "IEEEremainder"}, {"java.lang.Math", "log"}, {"java.lang.Math", "max"}, {"java.lang.Math", "min"}, {"java.lang.Math", "pow"}, {"java.lang.Math", "rint"}, {"java.lang.Math", "round"}, {"java.lang.Math", "sin"}, {"java.lang.Math", "sqrt"}, {"java.lang.Math", "tan"}, {"java.lang.Throwable", "<init>"}, {"java.lang.StringIndexOutOfBoundsException", "<init>"}};
    private static final String[][] impureMethods = new String[][]{{"java.io.", "<init>"}, {"java.io.", "close"}, {"java.io.", "read"}, {"java.io.", "write"}, {"java.io.", "flush"}, {"java.io.", "flushBuffer"}, {"java.io.", "print"}, {"java.io.", "println"}, {"java.lang.Runtime", "exit"}};
    private static final String[][] alterMethods = new String[][]{{"java.lang.System", "arraycopy"}, {"java.lang.FloatingDecimal", "dtoa"}, {"java.lang.FloatingDecimal", "developLongDigits"}, {"java.lang.FloatingDecimal", "big5pow"}, {"java.lang.FloatingDecimal", "getChars"}, {"java.lang.FloatingDecimal", "roundup"}};

    PurityInterproceduralAnalysis(CallGraph cg, Iterator<SootMethod> heads, PurityOptions opts) {
        super(cg, new Filter(), heads, opts.dump_cg());
        Iterator<SootMethod> it;
        if (opts.dump_cg()) {
            logger.debug("[AM] Dumping empty .dot call-graph");
            this.drawAsOneDot("EmptyCallGraph");
        }
        Date start = new Date();
        logger.debug("[AM] Analysis began");
        this.doAnalysis(opts.verbose());
        logger.debug("[AM] Analysis finished");
        Date finish = new Date();
        long runtime = finish.getTime() - start.getTime();
        logger.debug("[AM] run time: " + (double)runtime / 1000.0 + " s");
        if (opts.dump_cg()) {
            logger.debug("[AM] Dumping annotated .dot call-graph");
            this.drawAsOneDot("CallGraph");
        }
        if (opts.dump_summaries()) {
            logger.debug("[AM] Dumping .dot summaries of analysed methods");
            this.drawAsManyDot("Summary_", false);
        }
        if (opts.dump_intra()) {
            logger.debug("[AM] Dumping .dot full intra-procedural method analyses");
            it = this.getAnalysedMethods();
            while (it.hasNext()) {
                SootMethod method = it.next();
                if (opts.verbose()) {
                    logger.debug("  |- " + method);
                }
                ExceptionalUnitGraph graph = ExceptionalUnitGraphFactory.createExceptionalUnitGraph(method.retrieveActiveBody());
                PurityIntraproceduralAnalysis r = new PurityIntraproceduralAnalysis(graph, this);
                r.drawAsOneDot("Intra_", method.toString());
                r.copyResult(new PurityGraphBox());
            }
        }
        logger.debug("[AM] Annotate methods. ");
        it = this.getAnalysedMethods();
        while (it.hasNext()) {
            SootMethod m3 = it.next();
            PurityGraphBox b = (PurityGraphBox)this.getSummaryFor(m3);
            boolean isPure = m3.toString().contains("<init>") ? b.g.isPureConstructor() : b.g.isPure();
            m3.addTag(new StringTag("purity: " + (isPure ? "pure" : "impure")));
            if (isPure && opts.annotate()) {
                m3.addTag(new GenericAttribute("Pure", new byte[0]));
            }
            if (opts.print()) {
                logger.debug("  |- method " + m3.toString() + " is " + (isPure ? "pure" : "impure"));
            }
            if (!m3.isStatic()) {
                String s2;
                switch (b.g.thisStatus()) {
                    case 0: {
                        s2 = "read/write";
                        break;
                    }
                    case 1: {
                        s2 = "read-only";
                        break;
                    }
                    case 2: {
                        s2 = "Safe";
                        break;
                    }
                    default: {
                        s2 = "unknown";
                    }
                }
                m3.addTag(new StringTag("this: " + s2));
                if (opts.print()) {
                    logger.debug("  |   |- this is " + s2);
                }
            }
            int i = 0;
            for (Type t : m3.getParameterTypes()) {
                if (t instanceof RefLikeType) {
                    String s3;
                    switch (b.g.paramStatus(i)) {
                        case 0: {
                            s3 = "read/write";
                            break;
                        }
                        case 1: {
                            s3 = "read-only";
                            break;
                        }
                        case 2: {
                            s3 = "safe";
                            break;
                        }
                        default: {
                            s3 = "unknown";
                        }
                    }
                    m3.addTag(new StringTag("param" + i + ": " + s3));
                    if (opts.print()) {
                        logger.debug("  |   |- param " + i + " is " + s3);
                    }
                }
                ++i;
            }
        }
    }

    @Override
    protected PurityGraphBox newInitialSummary() {
        return new PurityGraphBox();
    }

    @Override
    protected void merge(PurityGraphBox in1, PurityGraphBox in2, PurityGraphBox out) {
        if (out != in1) {
            out.g = new PurityGraph(in1.g);
        }
        out.g.union(in2.g);
    }

    @Override
    protected void copy(PurityGraphBox source, PurityGraphBox dest) {
        dest.g = new PurityGraph(source.g);
    }

    @Override
    protected void analyseMethod(SootMethod method, PurityGraphBox dst) {
        new PurityIntraproceduralAnalysis(ExceptionalUnitGraphFactory.createExceptionalUnitGraph(method.retrieveActiveBody()), this).copyResult(dst);
    }

    @Override
    protected PurityGraphBox summaryOfUnanalysedMethod(SootMethod method) {
        PurityGraphBox b = new PurityGraphBox();
        String c = method.getDeclaringClass().toString();
        String m3 = method.getName();
        b.g = PurityGraph.conservativeGraph(method, true);
        for (String[] element : pureMethods) {
            if (!m3.equals(element[1]) || !c.startsWith(element[0])) continue;
            b.g = PurityGraph.freshGraph(method);
        }
        for (String[] element : alterMethods) {
            if (!m3.equals(element[1]) || !c.startsWith(element[0])) continue;
            b.g = PurityGraph.conservativeGraph(method, false);
        }
        return b;
    }

    @Override
    protected void applySummary(PurityGraphBox src, Stmt stmt, PurityGraphBox summary, PurityGraphBox dst) {
        Local v;
        Local ret = null;
        if (stmt instanceof AssignStmt && (v = (Local)((AssignStmt)stmt).getLeftOp()).getType() instanceof RefLikeType) {
            ret = v;
        }
        Local obj = null;
        InvokeExpr e = stmt.getInvokeExpr();
        if (!(e instanceof StaticInvokeExpr)) {
            obj = (Local)((InstanceInvokeExpr)e).getBase();
        }
        PurityGraph g2 = new PurityGraph(src.g);
        g2.methodCall(summary.g, obj, e.getArgs(), ret);
        dst.g = g2;
    }

    @Override
    protected void fillDotGraph(String prefix, PurityGraphBox o, DotGraph out) {
        o.g.fillDotGraph(prefix, out);
    }

    private static class Filter
    implements SootMethodFilter {
        private Filter() {
        }

        @Override
        public boolean want(SootMethod method) {
            String c = method.getDeclaringClass().toString();
            String m3 = method.getName();
            for (String[] element : pureMethods) {
                if (!m3.equals(element[1]) || !c.startsWith(element[0])) continue;
                return false;
            }
            for (String[] element : impureMethods) {
                if (!m3.equals(element[1]) || !c.startsWith(element[0])) continue;
                return false;
            }
            for (String[] element : alterMethods) {
                if (!m3.equals(element[1]) || !c.startsWith(element[0])) continue;
                return false;
            }
            return true;
        }
    }
}

