/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.callgraph;

import java.util.Iterator;
import soot.Scene;
import soot.SootMethod;
import soot.Unit;
import soot.jimple.toolkits.callgraph.CallGraph;
import soot.jimple.toolkits.callgraph.Edge;
import soot.toolkits.graph.UnitGraph;
import soot.toolkits.scalar.ArraySparseSet;
import soot.toolkits.scalar.FlowSet;
import soot.toolkits.scalar.ForwardFlowAnalysis;

public class ClinitElimAnalysis
extends ForwardFlowAnalysis<Unit, FlowSet<SootMethod>> {
    private final CallGraph cg = Scene.v().getCallGraph();
    private final UnitGraph g;

    public ClinitElimAnalysis(UnitGraph g2) {
        super(g2);
        this.g = g2;
        this.doAnalysis();
    }

    @Override
    public void merge(FlowSet<SootMethod> in1, FlowSet<SootMethod> in2, FlowSet<SootMethod> out) {
        in1.intersection(in2, out);
    }

    @Override
    public void copy(FlowSet<SootMethod> src, FlowSet<SootMethod> dest) {
        src.copy(dest);
    }

    @Override
    protected void copyFreshToExisting(FlowSet<SootMethod> in, FlowSet<SootMethod> dest) {
        in.copyFreshToExisting(dest);
    }

    @Override
    protected void flowThrough(FlowSet<SootMethod> inVal, Unit stmt, FlowSet<SootMethod> outVal) {
        inVal.copy(outVal);
        Iterator<Edge> edges = this.cg.edgesOutOf(stmt);
        while (edges.hasNext()) {
            Edge e = edges.next();
            if (!e.isClinit()) continue;
            outVal.add(e.tgt());
        }
    }

    @Override
    protected FlowSet<SootMethod> entryInitialFlow() {
        return new ArraySparseSet<SootMethod>();
    }

    @Override
    protected FlowSet<SootMethod> newInitialFlow() {
        ArraySparseSet<SootMethod> set = new ArraySparseSet<SootMethod>();
        Iterator<Edge> mIt = this.cg.edgesOutOf(this.g.getBody().getMethod());
        while (mIt.hasNext()) {
            Edge edge = mIt.next();
            if (!edge.isClinit()) continue;
            set.add(edge.tgt());
        }
        return set;
    }
}

