/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.ide.icfg;

import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import heros.DontSynchronize;
import heros.SynchronizedBy;
import heros.ThreadSafe;
import heros.solver.IDESolver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.MethodOrMethodContext;
import soot.Scene;
import soot.SootMethod;
import soot.Unit;
import soot.jimple.Stmt;
import soot.jimple.toolkits.callgraph.CallGraph;
import soot.jimple.toolkits.callgraph.Edge;
import soot.jimple.toolkits.callgraph.EdgePredicate;
import soot.jimple.toolkits.callgraph.Filter;
import soot.jimple.toolkits.ide.icfg.AbstractJimpleBasedICFG;
import soot.util.queue.QueueReader;

@ThreadSafe
public class JimpleBasedInterproceduralCFG
extends AbstractJimpleBasedICFG {
    protected static final Logger logger = LoggerFactory.getLogger(IDESolver.class);
    protected boolean includeReflectiveCalls = false;
    protected boolean includePhantomCallees = false;
    protected boolean fallbackToImmediateCallees = false;
    @DontSynchronize(value="readonly")
    protected final CallGraph cg;
    protected CacheLoader<Unit, Collection<SootMethod>> loaderUnitToCallees = new CacheLoader<Unit, Collection<SootMethod>>(){

        @Override
        public Collection<SootMethod> load(Unit u) throws Exception {
            Stmt s2;
            ArrayList<SootMethod> res = null;
            Iterator<Edge> edgeIter = new EdgeFilter().wrap(JimpleBasedInterproceduralCFG.this.cg.edgesOutOf(u));
            while (edgeIter.hasNext()) {
                Edge edge = edgeIter.next();
                SootMethod m3 = edge.getTgt().method();
                if (JimpleBasedInterproceduralCFG.this.includePhantomCallees || m3.hasActiveBody()) {
                    if (res == null) {
                        res = new ArrayList<SootMethod>();
                    }
                    res.add(m3);
                    continue;
                }
                if (!IDESolver.DEBUG) continue;
                logger.error(String.format("Method %s is referenced but has no body!", m3.getSignature(), new Exception()));
            }
            if (res != null) {
                res.trimToSize();
                return res;
            }
            if (JimpleBasedInterproceduralCFG.this.fallbackToImmediateCallees && u instanceof Stmt && (s2 = (Stmt)u).containsInvokeExpr()) {
                SootMethod immediate = s2.getInvokeExpr().getMethod();
                if (JimpleBasedInterproceduralCFG.this.includePhantomCallees || immediate.hasActiveBody()) {
                    return Collections.singleton(immediate);
                }
            }
            return Collections.emptySet();
        }
    };
    @SynchronizedBy(value="by use of synchronized LoadingCache class")
    protected final LoadingCache<Unit, Collection<SootMethod>> unitToCallees = IDESolver.DEFAULT_CACHE_BUILDER.build(this.loaderUnitToCallees);
    protected CacheLoader<SootMethod, Collection<Unit>> loaderMethodToCallers = new CacheLoader<SootMethod, Collection<Unit>>(){

        @Override
        public Collection<Unit> load(SootMethod m3) throws Exception {
            ArrayList<Unit> res = new ArrayList<Unit>();
            Iterator<Edge> edgeIter = new EdgeFilter().wrap(JimpleBasedInterproceduralCFG.this.cg.edgesInto(m3));
            while (edgeIter.hasNext()) {
                Edge edge = edgeIter.next();
                res.add(edge.srcUnit());
            }
            res.trimToSize();
            return res;
        }
    };
    @SynchronizedBy(value="by use of synchronized LoadingCache class")
    protected final LoadingCache<SootMethod, Collection<Unit>> methodToCallers = IDESolver.DEFAULT_CACHE_BUILDER.build(this.loaderMethodToCallers);

    public JimpleBasedInterproceduralCFG() {
        this(true);
    }

    public JimpleBasedInterproceduralCFG(boolean enableExceptions) {
        this(enableExceptions, false);
    }

    public JimpleBasedInterproceduralCFG(boolean enableExceptions, boolean includeReflectiveCalls) {
        super(enableExceptions);
        this.includeReflectiveCalls = includeReflectiveCalls;
        this.cg = Scene.v().getCallGraph();
        this.initializeUnitToOwner();
    }

    protected void initializeUnitToOwner() {
        QueueReader<MethodOrMethodContext> iter = Scene.v().getReachableMethods().listener();
        while (iter.hasNext()) {
            SootMethod m3 = ((MethodOrMethodContext)iter.next()).method();
            this.initializeUnitToOwner(m3);
        }
    }

    @Override
    public Collection<SootMethod> getCalleesOfCallAt(Unit u) {
        return this.unitToCallees.getUnchecked(u);
    }

    @Override
    public Collection<Unit> getCallersOf(SootMethod m3) {
        return this.methodToCallers.getUnchecked(m3);
    }

    public void setIncludePhantomCallees(boolean includePhantomCallees) {
        this.includePhantomCallees = includePhantomCallees;
    }

    public void setFallbackToImmediateCallees(boolean fallbackToImmediateCallees) {
        this.fallbackToImmediateCallees = fallbackToImmediateCallees;
    }

    public class EdgeFilter
    extends Filter {
        protected EdgeFilter() {
            super(new EdgePredicate(){

                @Override
                public boolean want(Edge e) {
                    return e.kind().isExplicit() || e.kind().isFake() || e.kind().isClinit() || JimpleBasedInterproceduralCFG.this.includeReflectiveCalls && e.kind().isReflection();
                }
            });
        }
    }
}

