/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.infoflow;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import soot.Body;
import soot.Scene;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.jimple.FieldRef;
import soot.jimple.InstanceFieldRef;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.StaticFieldRef;
import soot.jimple.StaticInvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.toolkits.callgraph.ReachableMethods;
import soot.toolkits.scalar.Pair;
import soot.util.Chain;

public class UseFinder {
    ReachableMethods rm;
    Map<SootClass, List> classToExtFieldAccesses = new HashMap<SootClass, List>();
    Map<SootClass, ArrayList> classToIntFieldAccesses = new HashMap<SootClass, ArrayList>();
    Map<SootClass, List> classToExtCalls = new HashMap<SootClass, List>();
    Map<SootClass, ArrayList> classToIntCalls = new HashMap<SootClass, ArrayList>();

    public UseFinder() {
        this.rm = Scene.v().getReachableMethods();
        this.doAnalysis();
    }

    public UseFinder(ReachableMethods rm) {
        this.rm = rm;
        this.doAnalysis();
    }

    public List getExtFieldAccesses(SootClass sc) {
        if (this.classToExtFieldAccesses.containsKey(sc)) {
            return this.classToExtFieldAccesses.get(sc);
        }
        throw new RuntimeException("UseFinder does not search non-application classes: " + sc);
    }

    public List getIntFieldAccesses(SootClass sc) {
        if (this.classToIntFieldAccesses.containsKey(sc)) {
            return this.classToIntFieldAccesses.get(sc);
        }
        throw new RuntimeException("UseFinder does not search non-application classes: " + sc);
    }

    public List getExtCalls(SootClass sc) {
        if (this.classToExtCalls.containsKey(sc)) {
            return this.classToExtCalls.get(sc);
        }
        throw new RuntimeException("UseFinder does not search non-application classes: " + sc);
    }

    public List getIntCalls(SootClass sc) {
        if (this.classToIntCalls.containsKey(sc)) {
            return this.classToIntCalls.get(sc);
        }
        throw new RuntimeException("UseFinder does not search non-application classes: " + sc);
    }

    public List<SootMethod> getExtMethods(SootClass sc) {
        if (this.classToExtCalls.containsKey(sc)) {
            List extCalls = this.classToExtCalls.get(sc);
            ArrayList<SootMethod> extMethods = new ArrayList<SootMethod>();
            for (Pair call : extCalls) {
                SootMethod calledMethod = ((Stmt)call.getO2()).getInvokeExpr().getMethod();
                if (extMethods.contains(calledMethod)) continue;
                extMethods.add(calledMethod);
            }
            return extMethods;
        }
        throw new RuntimeException("UseFinder does not search non-application classes: " + sc);
    }

    public List<SootField> getExtFields(SootClass sc) {
        if (this.classToExtFieldAccesses.containsKey(sc)) {
            List extAccesses = this.classToExtFieldAccesses.get(sc);
            ArrayList<SootField> extFields = new ArrayList<SootField>();
            for (Pair access : extAccesses) {
                SootField accessedField = ((Stmt)access.getO2()).getFieldRef().getField();
                if (extFields.contains(accessedField)) continue;
                extFields.add(accessedField);
            }
            return extFields;
        }
        throw new RuntimeException("UseFinder does not search non-application classes: " + sc);
    }

    private void doAnalysis() {
        Chain<SootClass> appClasses = Scene.v().getApplicationClasses();
        for (SootClass appClass : appClasses) {
            this.classToIntFieldAccesses.put(appClass, new ArrayList());
            this.classToExtFieldAccesses.put(appClass, new ArrayList());
            this.classToIntCalls.put(appClass, new ArrayList());
            this.classToExtCalls.put(appClass, new ArrayList());
        }
        for (SootClass appClass : appClasses) {
            for (SootMethod method : appClass.getMethods()) {
                if (!method.isConcrete() || !this.rm.contains(method)) continue;
                Body b = method.retrieveActiveBody();
                for (Stmt s2 : b.getUnits()) {
                    List<Pair<SootMethod, Stmt>> otherClassList;
                    if (s2.containsFieldRef()) {
                        FieldRef fr = s2.getFieldRef();
                        if (fr.getFieldRef().resolve().getDeclaringClass() == appClass) {
                            if (fr instanceof StaticFieldRef) {
                                this.classToIntFieldAccesses.get(appClass).add(new Pair<SootMethod, Stmt>(method, s2));
                            } else if (fr instanceof InstanceFieldRef) {
                                InstanceFieldRef ifr = (InstanceFieldRef)fr;
                                if (!method.isStatic() && ifr.getBase().equivTo(b.getThisLocal())) {
                                    this.classToIntFieldAccesses.get(appClass).add(new Pair<SootMethod, Stmt>(method, s2));
                                } else {
                                    this.classToExtFieldAccesses.get(appClass).add(new Pair<SootMethod, Stmt>(method, s2));
                                }
                            }
                        } else {
                            otherClassList = this.classToExtFieldAccesses.get(fr.getFieldRef().resolve().getDeclaringClass());
                            if (otherClassList == null) {
                                otherClassList = new ArrayList<Pair<SootMethod, Stmt>>();
                                this.classToExtFieldAccesses.put(fr.getFieldRef().resolve().getDeclaringClass(), otherClassList);
                            }
                            otherClassList.add(new Pair<SootMethod, Stmt>(method, s2));
                        }
                    }
                    if (!s2.containsInvokeExpr()) continue;
                    InvokeExpr ie = s2.getInvokeExpr();
                    if (ie.getMethodRef().resolve().getDeclaringClass() == appClass) {
                        if (ie instanceof StaticInvokeExpr) {
                            this.classToIntCalls.get(appClass).add(new Pair<SootMethod, Stmt>(method, s2));
                            continue;
                        }
                        if (!(ie instanceof InstanceInvokeExpr)) continue;
                        InstanceInvokeExpr iie = (InstanceInvokeExpr)ie;
                        if (!method.isStatic() && iie.getBase().equivTo(b.getThisLocal())) {
                            this.classToIntCalls.get(appClass).add(new Pair<SootMethod, Stmt>(method, s2));
                            continue;
                        }
                        this.classToExtCalls.get(appClass).add(new Pair<SootMethod, Stmt>(method, s2));
                        continue;
                    }
                    otherClassList = this.classToExtCalls.get(ie.getMethodRef().resolve().getDeclaringClass());
                    if (otherClassList == null) {
                        otherClassList = new ArrayList();
                        this.classToExtCalls.put(ie.getMethodRef().resolve().getDeclaringClass(), otherClassList);
                    }
                    otherClassList.add(new Pair<SootMethod, Stmt>(method, s2));
                }
            }
        }
    }
}

