/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.invoke;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.G;
import soot.Pack;
import soot.PackManager;
import soot.PhaseOptions;
import soot.Scene;
import soot.SceneTransformer;
import soot.Singletons;
import soot.SootClass;
import soot.SootMethod;
import soot.Unit;
import soot.jimple.Stmt;
import soot.jimple.toolkits.callgraph.CallGraph;
import soot.jimple.toolkits.callgraph.ExplicitEdgesPred;
import soot.jimple.toolkits.callgraph.Filter;
import soot.jimple.toolkits.callgraph.Targets;
import soot.jimple.toolkits.callgraph.TopologicalOrderer;
import soot.jimple.toolkits.invoke.InlinerSafetyManager;
import soot.jimple.toolkits.invoke.SiteInliner;
import soot.options.Options;
import soot.tagkit.Host;

public class StaticInliner
extends SceneTransformer {
    private static final Logger logger = LoggerFactory.getLogger(StaticInliner.class);
    private final HashMap<SootMethod, Integer> methodToOriginalSize = new HashMap();

    public StaticInliner(Singletons.Global g2) {
    }

    public static StaticInliner v() {
        return G.v().soot_jimple_toolkits_invoke_StaticInliner();
    }

    @Override
    protected void internalTransform(String phaseName, Map<String, String> options) {
        Filter explicitInvokesFilter = new Filter(new ExplicitEdgesPred());
        if (Options.v().verbose()) {
            logger.debug("[" + phaseName + "] Inlining methods...");
        }
        this.computeAverageMethodSizeAndSaveOriginalSizes();
        String modifierOptions = PhaseOptions.getString(options, "allowed-modifier-changes");
        ArrayList<Host[]> sitesToInline = new ArrayList<Host[]>();
        CallGraph cg = Scene.v().getCallGraph();
        TopologicalOrderer orderer = new TopologicalOrderer(cg);
        orderer.go();
        List<SootMethod> order = orderer.order();
        ListIterator<SootMethod> it = order.listIterator(order.size());
        while (it.hasPrevious()) {
            SootMethod container2 = it.previous();
            if (!container2.isConcrete() || !this.methodToOriginalSize.containsKey(container2) || !explicitInvokesFilter.wrap(cg.edgesOutOf(container2)).hasNext()) continue;
            for (Unit u : new ArrayList<Unit>(container2.retrieveActiveBody().getUnits())) {
                Targets targets;
                Stmt s2 = (Stmt)u;
                if (!s2.containsInvokeExpr() || !(targets = new Targets(explicitInvokesFilter.wrap(cg.edgesOutOf(s2)))).hasNext()) continue;
                SootMethod target = (SootMethod)targets.next();
                if (targets.hasNext() || !target.isConcrete() || !target.getDeclaringClass().isApplicationClass() || !InlinerSafetyManager.ensureInlinability(target, s2, container2, modifierOptions)) continue;
                sitesToInline.add(new Host[]{target, s2, container2});
            }
        }
        float expansionFactor = PhaseOptions.getFloat(options, "expansion-factor");
        int maxContainerSize = PhaseOptions.getInt(options, "max-container-size");
        int maxInlineeSize = PhaseOptions.getInt(options, "max-inlinee-size");
        Pack jbPack = PhaseOptions.getBoolean(options, "rerun-jb") ? PackManager.v().getPack("jb") : null;
        for (Host[] site : sitesToInline) {
            Stmt invokeStmt;
            int inlinedSize;
            SootMethod inlinee = (SootMethod)site[0];
            int inlineeSize = inlinee.retrieveActiveBody().getUnits().size();
            SootMethod container3 = (SootMethod)site[2];
            int containerSize = container3.retrieveActiveBody().getUnits().size();
            if (inlineeSize > maxInlineeSize || (inlinedSize = inlineeSize + containerSize) > maxContainerSize || (float)inlinedSize > expansionFactor * (float)this.methodToOriginalSize.get(container3).intValue() || !InlinerSafetyManager.ensureInlinability(inlinee, invokeStmt = (Stmt)site[1], container3, modifierOptions)) continue;
            SiteInliner.inlineSite(inlinee, invokeStmt, container3, options);
            if (jbPack == null) continue;
            jbPack.apply(container3.getActiveBody());
        }
    }

    private void computeAverageMethodSizeAndSaveOriginalSizes() {
        for (SootClass c : Scene.v().getApplicationClasses()) {
            Iterator<SootMethod> methodsIt = c.methodIterator();
            while (methodsIt.hasNext()) {
                SootMethod m3 = methodsIt.next();
                if (!m3.isConcrete()) continue;
                int size = m3.retrieveActiveBody().getUnits().size();
                this.methodToOriginalSize.put(m3, size);
            }
        }
    }
}

