/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.pointer;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import soot.Body;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.jimple.Constant;
import soot.jimple.DefinitionStmt;
import soot.toolkits.graph.UnitGraph;
import soot.toolkits.scalar.ForwardFlowAnalysis;

public class LocalMayAliasAnalysis
extends ForwardFlowAnalysis<Unit, Set<Set<Value>>> {
    private final Body body;

    public LocalMayAliasAnalysis(UnitGraph graph) {
        super(graph);
        this.body = graph.getBody();
        this.doAnalysis();
    }

    @Override
    protected void flowThrough(Set<Set<Value>> source, Unit unit, Set<Set<Value>> target) {
        target.addAll(source);
        if (unit instanceof DefinitionStmt) {
            DefinitionStmt def = (DefinitionStmt)unit;
            Value left = def.getLeftOp();
            Value right = def.getRightOp();
            if (right instanceof Constant) {
                Set<Value> leftSet = null;
                for (Set<Value> s2 : source) {
                    if (!s2.contains(left)) continue;
                    leftSet = s2;
                    break;
                }
                if (leftSet == null) {
                    throw new RuntimeException("internal error");
                }
                target.remove(leftSet);
                HashSet<Value> setWithoutLeft = new HashSet<Value>(leftSet);
                setWithoutLeft.remove(left);
                target.add(setWithoutLeft);
                target.add(Collections.singleton(left));
            } else {
                Set<Value> leftSet = null;
                Set<Value> rightSet = null;
                for (Set<Value> s3 : source) {
                    if (!s3.contains(left)) continue;
                    leftSet = s3;
                    break;
                }
                for (Set<Value> s3 : source) {
                    if (!s3.contains(right)) continue;
                    rightSet = s3;
                    break;
                }
                if (leftSet == null || rightSet == null) {
                    throw new RuntimeException("internal error");
                }
                target.remove(leftSet);
                target.remove(rightSet);
                HashSet<Value> union = new HashSet<Value>(leftSet);
                union.addAll(rightSet);
                target.add(union);
            }
        }
    }

    @Override
    protected void copy(Set<Set<Value>> source, Set<Set<Value>> target) {
        target.clear();
        target.addAll(source);
    }

    @Override
    protected Set<Set<Value>> entryInitialFlow() {
        HashSet<Set<Value>> res = new HashSet<Set<Value>>();
        for (ValueBox vb : this.body.getUseAndDefBoxes()) {
            res.add(Collections.singleton(vb.getValue()));
        }
        return res;
    }

    @Override
    protected void merge(Set<Set<Value>> source1, Set<Set<Value>> source2, Set<Set<Value>> target) {
        target.clear();
        target.addAll(source1);
        target.addAll(source2);
    }

    @Override
    protected Set<Set<Value>> newInitialFlow() {
        return new HashSet<Set<Value>>();
    }

    public boolean mayAlias(Value v1, Value v2, Unit u) {
        for (Set set : (Set)this.getFlowBefore(u)) {
            if (!set.contains(v1) || !set.contains(v2)) continue;
            return true;
        }
        return false;
    }

    public Set<Value> mayAliases(Value v, Unit u) {
        HashSet<Value> res = new HashSet<Value>();
        for (Set set : (Set)this.getFlowBefore(u)) {
            if (!set.contains(v)) continue;
            res.addAll(set);
        }
        return res;
    }

    public Set<Value> mayAliasesAtExit(Value v) {
        HashSet<Value> res = new HashSet<Value>();
        for (Unit u : this.graph.getTails()) {
            for (Set set : (Set)this.getFlowAfter(u)) {
                if (!set.contains(v)) continue;
                res.addAll(set);
            }
        }
        return res;
    }
}

