/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.pointer;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import soot.Local;
import soot.RefLikeType;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.jimple.Stmt;
import soot.jimple.toolkits.pointer.LocalMustAliasAnalysis;
import soot.toolkits.graph.StronglyConnectedComponentsFast;
import soot.toolkits.graph.UnitGraph;

public class StrongLocalMustAliasAnalysis
extends LocalMustAliasAnalysis {
    protected final Set<Integer> invalidInstanceKeys = new HashSet<Integer>();

    public StrongLocalMustAliasAnalysis(UnitGraph g2) {
        super(g2);
        StronglyConnectedComponentsFast<Unit> sccAnalysis = new StronglyConnectedComponentsFast<Unit>(g2);
        for (List<Unit> scc : sccAnalysis.getTrueComponents()) {
            for (Unit unit : scc) {
                for (ValueBox vb : unit.getDefBoxes()) {
                    Local defLocal;
                    Value defValue = vb.getValue();
                    if (!(defValue instanceof Local) || !((defLocal = (Local)defValue).getType() instanceof RefLikeType)) continue;
                    this.invalidInstanceKeys.add((Integer)((HashMap)this.getFlowBefore(unit)).get(defLocal));
                    this.invalidInstanceKeys.add((Integer)((HashMap)this.getFlowAfter(unit)).get(defLocal));
                }
            }
        }
    }

    @Override
    public boolean mustAlias(Local l1, Stmt s1, Local l2, Stmt s2) {
        Integer l1n = (Integer)((HashMap)this.getFlowBefore(s1)).get(l1);
        Integer l2n = (Integer)((HashMap)this.getFlowBefore(s2)).get(l2);
        return l1n != null && l2n != null && !this.invalidInstanceKeys.contains(l1n) && !this.invalidInstanceKeys.contains(l2n) && l1n.equals(l2n);
    }

    @Override
    public String instanceKeyString(Local l, Stmt s2) {
        return this.invalidInstanceKeys.contains(((HashMap)this.getFlowBefore(s2)).get(l)) ? "UNKNOWN" : super.instanceKeyString(l, s2);
    }
}

