/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.reflection;

import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Body;
import soot.G;
import soot.Local;
import soot.Scene;
import soot.SceneTransformer;
import soot.Singletons;
import soot.SootClass;
import soot.SootMethod;
import soot.UnitPatchingChain;
import soot.Value;
import soot.jimple.InvokeExpr;
import soot.jimple.Jimple;
import soot.jimple.Stmt;
import soot.jimple.StringConstant;
import soot.util.Chain;

public class ConstantInvokeMethodBaseTransformer
extends SceneTransformer {
    private static final Logger logger = LoggerFactory.getLogger(ConstantInvokeMethodBaseTransformer.class);
    private static final String INVOKE_SIG = "<java.lang.reflect.Method: java.lang.Object invoke(java.lang.Object,java.lang.Object[])>";

    public ConstantInvokeMethodBaseTransformer(Singletons.Global g2) {
    }

    public static ConstantInvokeMethodBaseTransformer v() {
        return G.v().soot_jimple_toolkits_reflection_ConstantInvokeMethodBaseTransformer();
    }

    @Override
    protected void internalTransform(String phaseName, Map<String, String> options) {
        boolean verbose = options.containsKey("verbose");
        Jimple jimp = Jimple.v();
        for (SootClass sootClass : Scene.v().getApplicationClasses()) {
            if (sootClass.resolvingLevel() < 3) continue;
            for (SootMethod sootMethod : sootClass.getMethods()) {
                Body body = sootMethod.retrieveActiveBody();
                Chain<Local> locals = body.getLocals();
                UnitPatchingChain units = body.getUnits();
                Iterator iterator = units.snapshotIterator();
                while (iterator.hasNext()) {
                    Value arg0;
                    InvokeExpr invokeExpr;
                    Stmt s2 = (Stmt)iterator.next();
                    if (!s2.containsInvokeExpr() || !INVOKE_SIG.equals((invokeExpr = s2.getInvokeExpr()).getMethod().getSignature()) || !((arg0 = invokeExpr.getArg(0)) instanceof StringConstant)) continue;
                    Local newLocal = jimp.newLocal("sc" + locals.size(), arg0.getType());
                    locals.add(newLocal);
                    units.insertBefore(jimp.newAssignStmt(newLocal, (StringConstant)arg0), s2);
                    invokeExpr.setArg(0, newLocal);
                    if (!verbose) continue;
                    logger.debug("Replaced constant base object of Method.invoke() by local in: " + sootMethod.toString());
                }
            }
        }
    }
}

