/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.scalar;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.EquivalentValue;
import soot.Unit;
import soot.ValueBox;
import soot.jimple.DefinitionStmt;
import soot.jimple.Stmt;
import soot.toolkits.graph.UnitGraph;
import soot.toolkits.scalar.ArraySparseSet;
import soot.toolkits.scalar.BackwardFlowAnalysis;
import soot.toolkits.scalar.FlowSet;

public class CommonPrecedingEqualValueAnalysis
extends BackwardFlowAnalysis<Unit, FlowSet<Object>> {
    private static final Logger logger = LoggerFactory.getLogger(CommonPrecedingEqualValueAnalysis.class);
    protected Map<? extends Unit, List<Object>> unitToAliasSet = null;
    protected Stmt s = null;

    public CommonPrecedingEqualValueAnalysis(UnitGraph g2) {
        super(g2);
    }

    public List<Object> getCommonAncestorValuesOf(Map<? extends Unit, List<Object>> unitToAliasSet, Stmt s2) {
        this.unitToAliasSet = unitToAliasSet;
        this.s = s2;
        this.doAnalysis();
        FlowSet fs = (FlowSet)this.getFlowAfter(s2);
        ArrayList<Object> ancestorList = new ArrayList<Object>(fs.size());
        for (Object o : fs) {
            ancestorList.add(o);
        }
        return ancestorList;
    }

    @Override
    protected void merge(FlowSet<Object> in1, FlowSet<Object> in2, FlowSet<Object> out) {
        in1.intersection(in2, out);
    }

    @Override
    protected void flowThrough(FlowSet<Object> in, Unit unit, FlowSet<Object> out) {
        block4: {
            ArrayList<EquivalentValue> newDefs;
            block3: {
                in.copy(out);
                newDefs = new ArrayList<EquivalentValue>();
                for (ValueBox vb : unit.getDefBoxes()) {
                    newDefs.add(new EquivalentValue(vb.getValue()));
                }
                List<Object> aliases = this.unitToAliasSet.get(unit);
                if (aliases == null) break block3;
                out.clear();
                for (Object next : aliases) {
                    out.add(next);
                }
                break block4;
            }
            if (!(unit instanceof DefinitionStmt)) break block4;
            for (EquivalentValue ev : newDefs) {
                out.remove(ev);
            }
        }
    }

    @Override
    protected void copy(FlowSet<Object> source, FlowSet<Object> dest) {
        source.copy(dest);
    }

    @Override
    protected FlowSet<Object> entryInitialFlow() {
        return new ArraySparseSet<Object>();
    }

    @Override
    protected FlowSet<Object> newInitialFlow() {
        return new ArraySparseSet<Object>();
    }
}

