/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.scalar;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.EquivalentValue;
import soot.Local;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.jimple.DefinitionStmt;
import soot.jimple.Stmt;
import soot.jimple.toolkits.scalar.EqualLocalsAnalysis;
import soot.toolkits.graph.UnitGraph;
import soot.toolkits.scalar.ArraySparseSet;
import soot.toolkits.scalar.FlowSet;
import soot.toolkits.scalar.ForwardFlowAnalysis;

@Deprecated
public class EqualUsesAnalysis
extends ForwardFlowAnalysis<Unit, FlowSet<Object>> {
    private static final Logger logger = LoggerFactory.getLogger(EqualUsesAnalysis.class);
    protected final EqualLocalsAnalysis el;
    protected Map<Stmt, Local> stmtToLocal = null;
    protected Set<Stmt> useStmts = null;
    protected Collection<Local> useLocals = null;
    protected List<Stmt> boundaryStmts = null;
    protected List<Stmt> redefStmts = null;
    protected Map<Stmt, List<Object>> firstUseToAliasSet = null;

    public EqualUsesAnalysis(UnitGraph g2) {
        super(g2);
        this.el = new EqualLocalsAnalysis(g2);
    }

    public boolean areEqualUses(Stmt firstStmt, Local firstLocal, Stmt secondStmt, Local secondLocal) {
        return this.areEqualUses(firstStmt, firstLocal, secondStmt, secondLocal, new ArrayList<Stmt>());
    }

    public boolean areEqualUses(Stmt firstStmt, Local firstLocal, Stmt secondStmt, Local secondLocal, List<Stmt> boundaryStmts) {
        HashMap<Stmt, Local> stmtToLocal = new HashMap<Stmt, Local>();
        stmtToLocal.put(firstStmt, firstLocal);
        stmtToLocal.put(secondStmt, secondLocal);
        return this.areEqualUses(stmtToLocal, boundaryStmts);
    }

    public boolean areEqualUses(Map<Stmt, Local> stmtToLocal) {
        return this.areEqualUses(stmtToLocal, new ArrayList<Stmt>());
    }

    public boolean areEqualUses(Map<Stmt, Local> stmtToLocal, List<Stmt> boundaryStmts) {
        this.stmtToLocal = stmtToLocal;
        this.useStmts = stmtToLocal.keySet();
        this.useLocals = stmtToLocal.values();
        this.boundaryStmts = boundaryStmts;
        this.redefStmts = new ArrayList<Stmt>();
        this.firstUseToAliasSet = new HashMap<Stmt, List<Object>>();
        this.doAnalysis();
        for (Stmt u : this.useStmts) {
            FlowSet fs = (FlowSet)this.getFlowBefore(u);
            for (Stmt next : this.redefStmts) {
                if (!fs.contains(next)) continue;
                return false;
            }
            List aliases = null;
            for (Object o : fs) {
                if (!(o instanceof List)) continue;
                aliases = (List)o;
            }
            if (aliases == null || aliases.contains(new EquivalentValue(stmtToLocal.get(u)))) continue;
            return false;
        }
        return true;
    }

    public Map<Stmt, List<Object>> getFirstUseToAliasSet() {
        return this.firstUseToAliasSet;
    }

    @Override
    protected void merge(FlowSet<Object> inSet1, FlowSet<Object> inSet2, FlowSet<Object> outSet) {
        inSet1.union(inSet2, outSet);
        List aliases1 = null;
        List aliases2 = null;
        for (Object o : outSet) {
            if (!(o instanceof List)) continue;
            if (aliases1 == null) {
                aliases1 = (List)o;
                continue;
            }
            aliases2 = (List)o;
        }
        if (aliases1 != null && aliases2 != null) {
            outSet.remove(aliases2);
            Iterator aliasIt = aliases1.iterator();
            while (aliasIt.hasNext()) {
                Object o;
                o = aliasIt.next();
                if (aliases2.contains(o)) continue;
                aliasIt.remove();
            }
        }
    }

    @Override
    protected void flowThrough(FlowSet<Object> in, Unit unit, FlowSet<Object> out) {
        block14: {
            Stmt stmt = (Stmt)unit;
            in.copy(out);
            ArrayList<Value> newDefs = new ArrayList<Value>();
            for (ValueBox vb : stmt.getDefBoxes()) {
                newDefs.add(vb.getValue());
            }
            for (Local useLocal : this.useLocals) {
                if (!newDefs.contains(useLocal)) continue;
                for (Object o : out) {
                    Stmt s2;
                    if (!(o instanceof Stmt) || this.stmtToLocal.get(s2 = (Stmt)o) != useLocal) continue;
                    this.redefStmts.add(stmt);
                }
            }
            if (this.redefStmts.contains(stmt)) {
                out.add(stmt);
            }
            if (this.boundaryStmts.contains(stmt)) {
                out.clear();
            }
            if (this.useStmts.contains(stmt)) {
                if (out.size() == 0) {
                    Local l = this.stmtToLocal.get(stmt);
                    List<Object> aliasList = this.el.getCopiesOfAt(l, stmt);
                    if (aliasList.isEmpty()) {
                        aliasList.add(l);
                    }
                    this.firstUseToAliasSet.put(stmt, new ArrayList<Object>(aliasList));
                    out.add(aliasList);
                }
                out.add(stmt);
            }
            if (!(stmt instanceof DefinitionStmt)) break block14;
            List aliases = null;
            for (Object o : out) {
                if (!(o instanceof List)) continue;
                aliases = (List)o;
            }
            if (aliases != null) {
                if (aliases.contains(new EquivalentValue(((DefinitionStmt)stmt).getRightOp()))) {
                    for (Value v : newDefs) {
                        aliases.add(new EquivalentValue(v));
                    }
                } else {
                    for (Value v : newDefs) {
                        aliases.remove(new EquivalentValue(v));
                    }
                }
            }
        }
    }

    @Override
    protected void copy(FlowSet<Object> source, FlowSet<Object> dest) {
        source.copy(dest);
    }

    @Override
    protected FlowSet<Object> entryInitialFlow() {
        return new ArraySparseSet<Object>();
    }

    @Override
    protected FlowSet<Object> newInitialFlow() {
        return new ArraySparseSet<Object>();
    }
}

