/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.scalar;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import soot.SideEffectTester;
import soot.SootMethod;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.jimple.AssignStmt;
import soot.jimple.Expr;
import soot.jimple.FieldRef;
import soot.jimple.InvokeExpr;
import soot.jimple.NewArrayExpr;
import soot.jimple.NewExpr;
import soot.jimple.NewMultiArrayExpr;
import soot.jimple.toolkits.scalar.ToppedSet;
import soot.toolkits.graph.DirectedGraph;
import soot.toolkits.scalar.ArraySparseSet;
import soot.toolkits.scalar.FlowSet;
import soot.toolkits.scalar.ForwardFlowAnalysis;

public class FastAvailableExpressionsAnalysis
extends ForwardFlowAnalysis<Unit, FlowSet<Value>> {
    protected final FlowSet<Value> emptySet = new ToppedSet<Value>(new ArraySparseSet());
    protected final SideEffectTester st;
    protected final Map<Value, Unit> rhsToContainingStmt;
    protected final Map<Unit, FlowSet<Value>> unitToGenerateSet;

    public FastAvailableExpressionsAnalysis(DirectedGraph<Unit> dg, SootMethod m3, SideEffectTester st) {
        super(dg);
        this.st = st;
        this.rhsToContainingStmt = new HashMap<Value, Unit>();
        this.unitToGenerateSet = new HashMap<Unit, FlowSet<Value>>(dg.size() * 2 + 1, 0.7f);
        for (Unit s2 : dg) {
            Value gen;
            FlowSet<Value> genSet = this.emptySet.clone();
            if (s2 instanceof AssignStmt && ((gen = ((AssignStmt)s2).getRightOp()) instanceof Expr || gen instanceof FieldRef)) {
                this.rhsToContainingStmt.put(gen, s2);
                if (!(gen instanceof NewExpr || gen instanceof NewArrayExpr || gen instanceof NewMultiArrayExpr || gen instanceof InvokeExpr)) {
                    genSet.add(gen, genSet);
                }
            }
            this.unitToGenerateSet.put(s2, genSet);
        }
        this.doAnalysis();
    }

    @Override
    protected FlowSet<Value> newInitialFlow() {
        FlowSet<Value> newSet = this.emptySet.clone();
        ((ToppedSet)newSet).setTop(true);
        return newSet;
    }

    @Override
    protected FlowSet<Value> entryInitialFlow() {
        return this.emptySet.clone();
    }

    @Override
    protected void flowThrough(FlowSet<Value> in, Unit u, FlowSet<Value> out) {
        in.copy(out);
        if (((ToppedSet)in).isTop()) {
            return;
        }
        out.union(this.unitToGenerateSet.get(u), out);
        if (((ToppedSet)out).isTop()) {
            throw new RuntimeException("trying to kill on topped set!");
        }
        for (Value avail : new ArrayList<Value>(out.toList())) {
            if (avail instanceof FieldRef) {
                if (!this.st.unitCanWriteTo(u, avail)) continue;
                out.remove(avail, out);
                continue;
            }
            for (ValueBox vb : avail.getUseBoxes()) {
                Value use = vb.getValue();
                if (!this.st.unitCanWriteTo(u, use)) continue;
                out.remove(avail, out);
            }
        }
    }

    @Override
    protected void merge(FlowSet<Value> inSet1, FlowSet<Value> inSet2, FlowSet<Value> outSet) {
        inSet1.intersection(inSet2, outSet);
    }

    @Override
    protected void copy(FlowSet<Value> sourceSet, FlowSet<Value> destSet) {
        sourceSet.copy(destSet);
    }
}

