/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.scalar;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import soot.Body;
import soot.BodyTransformer;
import soot.BooleanType;
import soot.ByteType;
import soot.CharType;
import soot.DoubleType;
import soot.ErroneousType;
import soot.FloatType;
import soot.G;
import soot.IntType;
import soot.Local;
import soot.LongType;
import soot.NullType;
import soot.PhaseOptions;
import soot.ShortType;
import soot.Singletons;
import soot.StmtAddressType;
import soot.Type;
import soot.UnknownType;
import soot.Value;
import soot.ValueBox;
import soot.util.Chain;

public class LocalNameStandardizer
extends BodyTransformer {
    public LocalNameStandardizer(Singletons.Global g2) {
    }

    public static LocalNameStandardizer v() {
        return G.v().soot_jimple_toolkits_scalar_LocalNameStandardizer();
    }

    private static int digits(int n) {
        int len = String.valueOf(n).length();
        return n < 0 ? len - 1 : len;
    }

    private static String genName(String prefix, String type, int n, int digits) {
        return String.format("%s%s%0" + digits + "d", prefix, type, n);
    }

    @Override
    protected void internalTransform(final Body body, String phaseName, Map<String, String> options) {
        boolean sortLocals = PhaseOptions.getBoolean(options, "sort-locals");
        if (sortLocals) {
            Chain<Local> locals = body.getLocals();
            ArrayList<Local> sortedLocals = new ArrayList<Local>(locals);
            Collections.sort(sortedLocals, new Comparator<Local>(){
                private Map<Local, Integer> firstOccuranceCache = new HashMap<Local, Integer>();
                private final List<ValueBox> defs = body.getDefBoxes();

                @Override
                public int compare(Local arg0, Local arg1) {
                    int ret = arg0.getType().toString().compareTo(arg1.getType().toString());
                    if (ret == 0) {
                        ret = Integer.compare(this.getFirstOccurance(arg0), this.getFirstOccurance(arg1));
                    }
                    return ret;
                }

                private int getFirstOccurance(Local l) {
                    Integer cur = this.firstOccuranceCache.get(l);
                    if (cur != null) {
                        return cur;
                    }
                    int count = 0;
                    int first = -1;
                    for (ValueBox vb : this.defs) {
                        Value v = vb.getValue();
                        if (v instanceof Local && l.equals(v)) {
                            first = count;
                            break;
                        }
                        ++count;
                    }
                    this.firstOccuranceCache.put(l, first);
                    return first;
                }
            });
            locals.clear();
            locals.addAll(sortedLocals);
        }
        if (!PhaseOptions.getBoolean(options, "only-stack-locals")) {
            BooleanType booleanType = BooleanType.v();
            ByteType byteType = ByteType.v();
            ShortType shortType = ShortType.v();
            CharType charType = CharType.v();
            IntType intType = IntType.v();
            LongType longType = LongType.v();
            DoubleType doubleType = DoubleType.v();
            FloatType floatType = FloatType.v();
            ErroneousType erroneousType = ErroneousType.v();
            UnknownType unknownType = UnknownType.v();
            StmtAddressType stmtAddressType = StmtAddressType.v();
            NullType nullType = NullType.v();
            Chain<Local> locals = body.getLocals();
            int maxDigits = sortLocals ? LocalNameStandardizer.digits(locals.size()) : 1;
            int objectCount = 0;
            int intCount = 0;
            int longCount = 0;
            int floatCount = 0;
            int doubleCount = 0;
            int addressCount = 0;
            int errorCount = 0;
            int nullCount = 0;
            for (Local l : locals) {
                String prefix = l.getName().startsWith("$") ? "$" : "";
                Type type = l.getType();
                if (booleanType.equals(type)) {
                    l.setName(LocalNameStandardizer.genName(prefix, "z", intCount++, maxDigits));
                    continue;
                }
                if (byteType.equals(type)) {
                    l.setName(LocalNameStandardizer.genName(prefix, "b", longCount++, maxDigits));
                    continue;
                }
                if (shortType.equals(type)) {
                    l.setName(LocalNameStandardizer.genName(prefix, "s", longCount++, maxDigits));
                    continue;
                }
                if (charType.equals(type)) {
                    l.setName(LocalNameStandardizer.genName(prefix, "c", longCount++, maxDigits));
                    continue;
                }
                if (intType.equals(type)) {
                    l.setName(LocalNameStandardizer.genName(prefix, "i", longCount++, maxDigits));
                    continue;
                }
                if (longType.equals(type)) {
                    l.setName(LocalNameStandardizer.genName(prefix, "l", longCount++, maxDigits));
                    continue;
                }
                if (doubleType.equals(type)) {
                    l.setName(LocalNameStandardizer.genName(prefix, "d", doubleCount++, maxDigits));
                    continue;
                }
                if (floatType.equals(type)) {
                    l.setName(LocalNameStandardizer.genName(prefix, "f", floatCount++, maxDigits));
                    continue;
                }
                if (stmtAddressType.equals(type)) {
                    l.setName(LocalNameStandardizer.genName(prefix, "a", addressCount++, maxDigits));
                    continue;
                }
                if (erroneousType.equals(type) || unknownType.equals(type)) {
                    l.setName(LocalNameStandardizer.genName(prefix, "e", errorCount++, maxDigits));
                    continue;
                }
                if (nullType.equals(type)) {
                    l.setName(LocalNameStandardizer.genName(prefix, "n", nullCount++, maxDigits));
                    continue;
                }
                l.setName(LocalNameStandardizer.genName(prefix, "r", objectCount++, maxDigits));
            }
        }
    }
}

