/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.scalar;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import soot.Body;
import soot.EquivalentValue;
import soot.Unit;
import soot.UnitPatchingChain;
import soot.Value;
import soot.jimple.AssignStmt;
import soot.jimple.Stmt;
import soot.jimple.toolkits.scalar.AvailableExpressions;
import soot.jimple.toolkits.scalar.SlowAvailableExpressionsAnalysis;
import soot.toolkits.graph.ExceptionalUnitGraphFactory;
import soot.toolkits.scalar.FlowSet;
import soot.toolkits.scalar.UnitValueBoxPair;
import soot.util.Chain;
import soot.util.HashChain;

public class SlowAvailableExpressions
implements AvailableExpressions {
    protected final Map<Unit, List<UnitValueBoxPair>> unitToPairsAfter;
    protected final Map<Unit, List<UnitValueBoxPair>> unitToPairsBefore;
    protected final Map<Unit, Chain<EquivalentValue>> unitToEquivsAfter;
    protected final Map<Unit, Chain<EquivalentValue>> unitToEquivsBefore;

    public SlowAvailableExpressions(Body b) {
        UnitPatchingChain units = b.getUnits();
        this.unitToPairsAfter = new HashMap<Unit, List<UnitValueBoxPair>>(units.size() * 2 + 1, 0.7f);
        this.unitToPairsBefore = new HashMap<Unit, List<UnitValueBoxPair>>(units.size() * 2 + 1, 0.7f);
        this.unitToEquivsAfter = new HashMap<Unit, Chain<EquivalentValue>>(units.size() * 2 + 1, 0.7f);
        this.unitToEquivsBefore = new HashMap<Unit, Chain<EquivalentValue>>(units.size() * 2 + 1, 0.7f);
        SlowAvailableExpressionsAnalysis analysis = new SlowAvailableExpressionsAnalysis(ExceptionalUnitGraphFactory.createExceptionalUnitGraph(b));
        for (Unit s2 : units) {
            EquivalentValue ev;
            Stmt containingStmt;
            ArrayList<UnitValueBoxPair> pairsBefore = new ArrayList<UnitValueBoxPair>();
            HashChain<EquivalentValue> equivsBefore = new HashChain<EquivalentValue>();
            for (Value v : (FlowSet)analysis.getFlowBefore(s2)) {
                containingStmt = analysis.rhsToContainingStmt.get(v);
                pairsBefore.add(new UnitValueBoxPair(containingStmt, ((AssignStmt)containingStmt).getRightOpBox()));
                ev = new EquivalentValue(v);
                if (equivsBefore.contains(ev)) continue;
                equivsBefore.add(ev);
            }
            this.unitToPairsBefore.put(s2, pairsBefore);
            this.unitToEquivsBefore.put(s2, equivsBefore);
            ArrayList<UnitValueBoxPair> pairsAfter = new ArrayList<UnitValueBoxPair>();
            HashChain<EquivalentValue> equivsAfter = new HashChain<EquivalentValue>();
            for (Value v : (FlowSet)analysis.getFlowAfter(s2)) {
                containingStmt = analysis.rhsToContainingStmt.get(v);
                pairsAfter.add(new UnitValueBoxPair(containingStmt, ((AssignStmt)containingStmt).getRightOpBox()));
                ev = new EquivalentValue(v);
                if (equivsAfter.contains(ev)) continue;
                equivsAfter.add(ev);
            }
            this.unitToPairsAfter.put(s2, pairsAfter);
            this.unitToEquivsAfter.put(s2, equivsAfter);
        }
    }

    @Override
    public List<UnitValueBoxPair> getAvailablePairsBefore(Unit u) {
        return this.unitToPairsBefore.get(u);
    }

    @Override
    public List<UnitValueBoxPair> getAvailablePairsAfter(Unit u) {
        return this.unitToPairsAfter.get(u);
    }

    @Override
    public Chain<EquivalentValue> getAvailableEquivsBefore(Unit u) {
        return this.unitToEquivsBefore.get(u);
    }

    @Override
    public Chain<EquivalentValue> getAvailableEquivsAfter(Unit u) {
        return this.unitToEquivsAfter.get(u);
    }
}

