/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.scalar;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Body;
import soot.BodyTransformer;
import soot.G;
import soot.Singletons;
import soot.Unit;
import soot.UnitBox;
import soot.Value;
import soot.jimple.ConditionExpr;
import soot.jimple.EqExpr;
import soot.jimple.GeExpr;
import soot.jimple.GotoStmt;
import soot.jimple.GtExpr;
import soot.jimple.IfStmt;
import soot.jimple.Jimple;
import soot.jimple.LeExpr;
import soot.jimple.LtExpr;
import soot.jimple.NeExpr;
import soot.jimple.Stmt;
import soot.jimple.StmtBody;
import soot.jimple.SwitchStmt;
import soot.options.Options;
import soot.shimple.Shimple;
import soot.shimple.ShimpleBody;
import soot.shimple.internal.SUnitBox;
import soot.util.Chain;

public class UnconditionalBranchFolder
extends BodyTransformer {
    private static final Logger logger = LoggerFactory.getLogger(UnconditionalBranchFolder.class);

    public UnconditionalBranchFolder(Singletons.Global g2) {
    }

    public static UnconditionalBranchFolder v() {
        return G.v().soot_jimple_toolkits_scalar_UnconditionalBranchFolder();
    }

    @Override
    protected void internalTransform(Body b, String phaseName, Map<String, String> options) {
        Result res;
        boolean verbose = Options.v().verbose();
        if (verbose) {
            logger.debug("[" + b.getMethod().getName() + "] Folding unconditional branches...");
        }
        Transformer transformer = new Transformer((StmtBody)b);
        int iter = 0;
        do {
            res = transformer.transform();
            if (!verbose) continue;
            logger.debug("[" + b.getMethod().getName() + "]     " + res.getNumFixed(BranchType.TOTAL_COUNT) + " of " + res.getNumFound(BranchType.TOTAL_COUNT) + " branches folded in iteration " + ++iter + ".");
        } while (res.modified);
    }

    public static ConditionExpr reverseCondition(ConditionExpr cond) {
        ConditionExpr newExpr;
        if (cond instanceof EqExpr) {
            newExpr = Jimple.v().newNeExpr(cond.getOp1(), cond.getOp2());
        } else if (cond instanceof NeExpr) {
            newExpr = Jimple.v().newEqExpr(cond.getOp1(), cond.getOp2());
        } else if (cond instanceof GtExpr) {
            newExpr = Jimple.v().newLeExpr(cond.getOp1(), cond.getOp2());
        } else if (cond instanceof GeExpr) {
            newExpr = Jimple.v().newLtExpr(cond.getOp1(), cond.getOp2());
        } else if (cond instanceof LtExpr) {
            newExpr = Jimple.v().newGeExpr(cond.getOp1(), cond.getOp2());
        } else if (cond instanceof LeExpr) {
            newExpr = Jimple.v().newGtExpr(cond.getOp1(), cond.getOp2());
        } else {
            throw new RuntimeException("Unknown ConditionExpr");
        }
        newExpr.getOp1Box().addAllTagsOf(cond.getOp1Box());
        newExpr.getOp2Box().addAllTagsOf(cond.getOp2Box());
        return newExpr;
    }

    private static class Transformer {
        private final Map<Stmt, Stmt> stmtMap = new HashMap<Stmt, Stmt>();
        private final boolean isShimple;
        private final Chain<Unit> units;

        public Transformer(StmtBody body) {
            this.isShimple = body instanceof ShimpleBody;
            this.units = body.getUnits();
        }

        public Result transform() {
            this.stmtMap.clear();
            Result res = new Result();
            Iterator<Unit> stmtIt = this.units.iterator();
            while (stmtIt.hasNext()) {
                Unit successor;
                Unit stmt = stmtIt.next();
                if (stmt instanceof GotoStmt) {
                    GotoStmt stmtAsGotoStmt = (GotoStmt)stmt;
                    Stmt gotoTarget = (Stmt)stmtAsGotoStmt.getTarget();
                    if (stmtIt.hasNext() && (successor = this.units.getSuccOf(stmt)) == gotoTarget) {
                        if (!this.isShimple || this.removalIsSafeInShimple(stmt)) {
                            stmtIt.remove();
                            res.updateCounters(BranchType.GOTO_SUCCESSOR, true);
                            continue;
                        }
                        res.updateCounters(BranchType.GOTO_SUCCESSOR, false);
                        continue;
                    }
                    res.updateCounters(this.handle(stmtAsGotoStmt, gotoTarget));
                    continue;
                }
                if (stmt instanceof IfStmt) {
                    IfStmt stmtAsIfStmt = (IfStmt)stmt;
                    Stmt ifTarget = stmtAsIfStmt.getTarget();
                    if (stmtIt.hasNext()) {
                        successor = this.units.getSuccOf(stmt);
                        if (successor == ifTarget) {
                            if (!this.isShimple || this.removalIsSafeInShimple(stmt)) {
                                stmtIt.remove();
                                res.updateCounters(BranchType.IF_SAME_TARGET, true);
                                continue;
                            }
                            res.updateCounters(BranchType.IF_SAME_TARGET, false);
                            continue;
                        }
                        if (successor instanceof GotoStmt) {
                            GotoStmt succAsGoto = (GotoStmt)successor;
                            Stmt gotoTarget = (Stmt)succAsGoto.getTarget();
                            if (gotoTarget == ifTarget) {
                                if (!this.isShimple || this.removalIsSafeInShimple(stmt)) {
                                    stmtIt.remove();
                                    res.updateCounters(BranchType.IF_SAME_TARGET, true);
                                    continue;
                                }
                                res.updateCounters(BranchType.IF_SAME_TARGET, false);
                                continue;
                            }
                            Unit afterSuccessor = this.units.getSuccOf(successor);
                            if (afterSuccessor == ifTarget) {
                                Value oldCondition = stmtAsIfStmt.getCondition();
                                assert (oldCondition instanceof ConditionExpr);
                                stmtAsIfStmt.setCondition(UnconditionalBranchFolder.reverseCondition((ConditionExpr)oldCondition));
                                succAsGoto.setTarget(ifTarget);
                                stmtAsIfStmt.setTarget(gotoTarget);
                                ifTarget = gotoTarget;
                            }
                        }
                    }
                    res.updateCounters(this.handle(stmtAsIfStmt, ifTarget));
                    continue;
                }
                if (!(stmt instanceof SwitchStmt)) continue;
                SwitchStmt stmtAsSwitchStmt = (SwitchStmt)stmt;
                for (UnitBox ub : stmtAsSwitchStmt.getUnitBoxes()) {
                    Stmt caseTarget = (Stmt)ub.getUnit();
                    if (!(caseTarget instanceof GotoStmt)) continue;
                    Stmt newTarget = this.getFinalTarget(caseTarget);
                    if (newTarget == null || newTarget == caseTarget) {
                        res.updateCounters(BranchType.GOTO_GOTO, false);
                        continue;
                    }
                    ub.setUnit(newTarget);
                    res.updateCounters(BranchType.GOTO_GOTO, true);
                }
            }
            return res;
        }

        private HandleRes handle(GotoStmt gotoStmt, Stmt target) {
            assert (gotoStmt.getTarget() == target);
            if (target instanceof GotoStmt) {
                if (!this.isShimple || this.removalIsSafeInShimple(target)) {
                    Stmt newTarget = this.getFinalTarget(target);
                    if (newTarget == null) {
                        newTarget = gotoStmt;
                    }
                    if (newTarget != target) {
                        if (this.isShimple) {
                            assert (this.hasNoPointersOrSingleJumpPred(target, gotoStmt));
                            Shimple.redirectPointers(target, gotoStmt);
                        }
                        gotoStmt.setTarget(newTarget);
                        return new HandleRes(BranchType.GOTO_GOTO, true);
                    }
                }
                return new HandleRes(BranchType.GOTO_GOTO, false);
            }
            if (target instanceof IfStmt) {
                return new HandleRes(BranchType.GOTO_IF, false);
            }
            return new HandleRes(BranchType.TOTAL_COUNT, false);
        }

        private HandleRes handle(IfStmt ifStmt, Stmt target) {
            assert (ifStmt.getTarget() == target);
            if (target instanceof GotoStmt) {
                if (!this.isShimple || this.removalIsSafeInShimple(target)) {
                    Stmt newTarget = this.getFinalTarget(target);
                    if (newTarget == null) {
                        newTarget = ifStmt;
                    }
                    if (newTarget != target) {
                        if (this.isShimple) {
                            assert (this.hasNoPointersOrSingleJumpPred(target, ifStmt));
                            Shimple.redirectPointers(target, ifStmt);
                        }
                        ifStmt.setTarget(newTarget);
                        return new HandleRes(BranchType.IF_TO_GOTO, true);
                    }
                }
                return new HandleRes(BranchType.IF_TO_GOTO, false);
            }
            if (target instanceof IfStmt) {
                IfStmt targetAsIfStmt;
                Stmt newTarget;
                if (ifStmt != target && (!this.isShimple || this.removalIsSafeInShimple(target)) && (newTarget = (targetAsIfStmt = (IfStmt)target).getTarget()) != target && ifStmt.getCondition().equivTo(targetAsIfStmt.getCondition())) {
                    if (this.isShimple) {
                        assert (this.hasNoPointersOrSingleJumpPred(target, ifStmt));
                        Shimple.redirectPointers(target, ifStmt);
                    }
                    ifStmt.setTarget(newTarget);
                    return new HandleRes(BranchType.IF_TO_IF, true);
                }
                return new HandleRes(BranchType.IF_TO_IF, false);
            }
            return new HandleRes(BranchType.TOTAL_COUNT, false);
        }

        private Stmt getFinalTarget(Stmt stmt) {
            Stmt finalTarget;
            if (!(stmt instanceof GotoStmt)) {
                return stmt;
            }
            this.stmtMap.put(stmt, stmt);
            Stmt target = (Stmt)((GotoStmt)stmt).getTarget();
            if (this.stmtMap.containsKey(target)) {
                finalTarget = this.stmtMap.get(target);
                if (finalTarget == target) {
                    finalTarget = null;
                }
            } else {
                finalTarget = this.getFinalTarget(target);
            }
            this.stmtMap.put(stmt, finalTarget);
            return finalTarget;
        }

        private boolean removalIsSafeInShimple(Unit stmt) {
            Unit chainPred = this.units.getPredOf(stmt);
            if (chainPred == null) {
                return true;
            }
            List<UnitBox> boxesPointingToThis = stmt.getBoxesPointingToThis();
            if (boxesPointingToThis.isEmpty()) {
                return true;
            }
            boolean hasBackref = false;
            HashSet<UnitBox> predBoxes = new HashSet<UnitBox>();
            for (UnitBox ub : boxesPointingToThis) {
                if (ub.isBranchTarget()) {
                    assert (stmt == ub.getUnit());
                    predBoxes.add(ub);
                    continue;
                }
                assert (ub instanceof SUnitBox);
                hasBackref = true;
            }
            if (!hasBackref) {
                return true;
            }
            int predecessorCount = predBoxes.size();
            if (predecessorCount > 1) {
                return false;
            }
            if (chainPred.fallsThrough() && Collections.disjoint(chainPred.getUnitBoxes(), predBoxes)) {
                ++predecessorCount;
            }
            return predecessorCount == 1;
        }

        private boolean hasNoPointersOrSingleJumpPred(Unit toRemove, Unit jumpPred) {
            boolean hasBackref = false;
            HashSet<UnitBox> predBoxes = new HashSet<UnitBox>();
            for (UnitBox ub : toRemove.getBoxesPointingToThis()) {
                if (ub.isBranchTarget()) {
                    assert (toRemove == ub.getUnit());
                    predBoxes.add(ub);
                    continue;
                }
                assert (ub instanceof SUnitBox);
                hasBackref = true;
            }
            if (!hasBackref) {
                return true;
            }
            if (predBoxes.size() != 1 || !jumpPred.getUnitBoxes().containsAll(predBoxes)) {
                return false;
            }
            Unit chainPred = this.units.getPredOf(toRemove);
            return chainPred == null || !chainPred.fallsThrough();
        }
    }

    private static class Result {
        private final int[] numFound = new int[BranchType.values().length];
        private final int[] numFixed = new int[BranchType.values().length];
        private boolean modified;

        private Result() {
        }

        public void updateCounters(HandleRes r) {
            this.updateCounters(r.type, r.fixed);
        }

        public void updateCounters(BranchType type, boolean fixed) {
            boolean updatingTotal;
            int indexTotal = BranchType.TOTAL_COUNT.ordinal();
            int indexUpdate = type.ordinal();
            boolean bl = updatingTotal = indexUpdate == indexTotal;
            if (updatingTotal && fixed) {
                throw new IllegalArgumentException("Cannot mark TOTAL as fixed!");
            }
            int n = indexTotal;
            this.numFound[n] = this.numFound[n] + 1;
            if (!updatingTotal) {
                int n2 = indexUpdate;
                this.numFound[n2] = this.numFound[n2] + 1;
            }
            if (fixed) {
                this.modified = true;
                int n3 = indexTotal;
                this.numFixed[n3] = this.numFixed[n3] + 1;
                int n4 = indexUpdate;
                this.numFixed[n4] = this.numFixed[n4] + 1;
            }
        }

        public int getNumFound(BranchType type) {
            int indexCurrType = type.ordinal();
            return this.numFound[indexCurrType];
        }

        public int getNumFixed(BranchType type) {
            int indexCurrType = type.ordinal();
            return this.numFixed[indexCurrType];
        }
    }

    private static class HandleRes {
        final BranchType type;
        final boolean fixed;

        public HandleRes(BranchType type, boolean fixed) {
            this.type = type;
            this.fixed = fixed;
        }
    }

    private static enum BranchType {
        TOTAL_COUNT,
        GOTO_GOTO,
        IF_TO_GOTO,
        GOTO_IF,
        IF_TO_IF,
        IF_SAME_TARGET,
        GOTO_SUCCESSOR;

    }
}

