/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.thread.mhp;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Timers;
import soot.jimple.toolkits.thread.mhp.MonitorDepth;
import soot.jimple.toolkits.thread.mhp.MonitorSet;
import soot.jimple.toolkits.thread.mhp.PegChain;
import soot.jimple.toolkits.thread.mhp.PegGraph;
import soot.jimple.toolkits.thread.mhp.stmt.JPegStmt;
import soot.tagkit.Tag;
import soot.toolkits.scalar.ArraySparseSet;
import soot.toolkits.scalar.FlowSet;
import soot.toolkits.scalar.ForwardFlowAnalysis;

public class MonitorAnalysis
extends ForwardFlowAnalysis {
    private static final Logger logger = LoggerFactory.getLogger(MonitorAnalysis.class);
    private PegGraph g;
    private final HashMap<String, FlowSet> monitor = new HashMap();
    private final Vector<Object> nodes = new Vector();
    private final Vector<Object> valueBefore = new Vector();
    private final Vector<Object> valueAfter = new Vector();

    public MonitorAnalysis(PegGraph g2) {
        super(g2);
        this.g = g2;
        this.doAnalysis();
        g2.setMonitor(this.monitor);
    }

    @Override
    protected void doAnalysis() {
        LinkedList<Object> changedUnits = new LinkedList<Object>();
        HashSet<Object> changedUnitsSet = new HashSet<Object>();
        int numNodes = this.graph.size();
        int numComputations = 0;
        this.createWorkList(changedUnits, changedUnitsSet);
        for (Object s2 : this.graph.getHeads()) {
            this.nodes.add(s2);
            this.valueBefore.add(this.entryInitialFlow());
        }
        Object previousAfterFlow = this.newInitialFlow();
        while (!changedUnits.isEmpty()) {
            Object s3 = changedUnits.removeFirst();
            changedUnitsSet.remove(s3);
            int pos = this.nodes.indexOf(s3);
            this.copy(this.valueAfter.elementAt(pos), previousAfterFlow);
            List<Object> preds = this.graph.getPredsOf(s3);
            Object beforeFlow = this.valueBefore.elementAt(pos);
            if (preds.size() == 1) {
                this.copy(this.valueAfter.elementAt(this.nodes.indexOf(preds.get(0))), beforeFlow);
            } else if (preds.size() != 0) {
                Iterator<Object> predIt = preds.iterator();
                Object obj = predIt.next();
                this.copy(this.valueAfter.elementAt(this.nodes.indexOf(obj)), beforeFlow);
                while (predIt.hasNext()) {
                    JPegStmt stmt = (JPegStmt)predIt.next();
                    if (stmt.equals(obj) || this.nodes.indexOf(stmt) < 0) continue;
                    Object otherBranchFlow = this.valueAfter.elementAt(this.nodes.indexOf(stmt));
                    this.merge(beforeFlow, otherBranchFlow, beforeFlow);
                }
            }
            Object afterFlow = this.valueAfter.elementAt(this.nodes.indexOf(s3));
            this.flowThrough(beforeFlow, s3, afterFlow);
            this.valueAfter.set(this.nodes.indexOf(s3), afterFlow);
            ++numComputations;
            if (afterFlow.equals(previousAfterFlow)) continue;
            for (Object succ : this.graph.getSuccsOf(s3)) {
                if (changedUnitsSet.contains(succ)) continue;
                changedUnits.addLast(succ);
                changedUnitsSet.add(succ);
            }
        }
        Timers.v().totalFlowNodes += numNodes;
        Timers.v().totalFlowComputations += numComputations;
    }

    @Override
    protected void merge(Object in1, Object in2, Object out) {
        MonitorSet inSet1 = (MonitorSet)in1;
        MonitorSet inSet2 = (MonitorSet)in2;
        MonitorSet outSet = (MonitorSet)out;
        inSet1.intersection(inSet2, outSet);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void flowThrough(Object inValue, Object unit, Object outValue) {
        Object obj;
        MonitorSet in = (MonitorSet)inValue;
        MonitorSet out = (MonitorSet)outValue;
        JPegStmt s2 = (JPegStmt)unit;
        Tag tag = s2.getTags().get(0);
        in.copy(out);
        if (in.size() > 0 && !s2.getName().equals("waiting") && !s2.getName().equals("notified-entry")) {
            this.updateMonitor(in, unit);
        }
        String objName = s2.getObject();
        if (!s2.getName().equals("entry") && !s2.getName().equals("exit")) return;
        if (out.contains("&")) {
            out.remove("&");
        }
        if ((obj = out.getMonitorDepth(objName)) == null) {
            if (!s2.getName().equals("entry")) return;
            MonitorDepth md = new MonitorDepth(objName, 1);
            out.add(md);
            return;
        } else {
            if (!(obj instanceof MonitorDepth)) throw new RuntimeException("MonitorSet contains non MonitorDepth element!");
            MonitorDepth md = (MonitorDepth)obj;
            if (s2.getName().equals("entry")) {
                md.increaseDepth();
                return;
            } else if (md.getDepth() > 1) {
                md.decreaseDepth();
                return;
            } else {
                if (md.getDepth() != 1) throw new RuntimeException("The monitor depth can not be decreased at  " + unit);
                out.remove(md);
            }
        }
    }

    @Override
    protected void copy(Object source, Object dest) {
        MonitorSet sourceSet = (MonitorSet)source;
        MonitorSet destSet = (MonitorSet)dest;
        sourceSet.copy(destSet);
    }

    @Override
    protected Object entryInitialFlow() {
        return new MonitorSet();
    }

    @Override
    protected Object newInitialFlow() {
        MonitorSet fullSet = new MonitorSet();
        fullSet.add("&");
        return fullSet;
    }

    private void updateMonitor(MonitorSet ms, Object unit) {
        for (Object obj : ms) {
            if (!(obj instanceof MonitorDepth)) continue;
            MonitorDepth md = (MonitorDepth)obj;
            String objName = md.getObjName();
            if (this.monitor.containsKey(objName)) {
                if (md.getDepth() <= 0) continue;
                this.monitor.get(objName).add(unit);
                continue;
            }
            ArraySparseSet<Object> monitorObjs = new ArraySparseSet<Object>();
            monitorObjs.add(unit);
            this.monitor.put(objName, monitorObjs);
        }
    }

    private void createWorkList(LinkedList<Object> changedUnits, HashSet<Object> changedUnitsSet) {
        this.createWorkList(changedUnits, changedUnitsSet, this.g.getMainPegChain());
        Set<Map.Entry<JPegStmt, List>> maps = this.g.getStartToThread().entrySet();
        for (Map.Entry<JPegStmt, List> entry : maps) {
            List runMethodChainList = entry.getValue();
            for (PegChain chain : runMethodChainList) {
                this.createWorkList(changedUnits, changedUnitsSet, chain);
            }
        }
    }

    public void computeSynchNodes() {
        int num = 0;
        Set<Map.Entry<String, FlowSet>> maps = this.monitor.entrySet();
        for (Map.Entry<String, FlowSet> entry : maps) {
            FlowSet fs = entry.getValue();
            num += fs.size();
        }
        System.err.println("synch objects: " + num);
    }

    private void createWorkList(LinkedList<Object> changedUnits, HashSet<Object> changedUnitsSet, PegChain chain) {
        Iterator it = chain.getHeads().iterator();
        HashSet<Object> gray = new HashSet<Object>();
        while (it.hasNext()) {
            Object head = it.next();
            if (gray.contains(head)) continue;
            this.visitNode(gray, head, changedUnits, changedUnitsSet);
        }
    }

    private void visitNode(Set<Object> gray, Object obj, LinkedList<Object> changedUnits, HashSet<Object> changedUnitsSet) {
        gray.add(obj);
        changedUnits.addLast(obj);
        changedUnitsSet.add(obj);
        this.nodes.add(obj);
        this.valueBefore.add(this.newInitialFlow());
        this.valueAfter.add(this.newInitialFlow());
        Iterator<Object> succsIt = this.graph.getSuccsOf(obj).iterator();
        if (this.g.getSuccsOf(obj).size() > 0) {
            while (succsIt.hasNext()) {
                Object succ = succsIt.next();
                if (gray.contains(succ)) continue;
                this.visitNode(gray, succ, changedUnits, changedUnitsSet);
            }
        }
    }

    public Map<String, FlowSet> getMonitor() {
        return this.monitor;
    }

    public void testMonitor() {
        System.out.println("=====test monitor size: " + this.monitor.size());
        Set<Map.Entry<String, FlowSet>> maps = this.monitor.entrySet();
        for (Map.Entry<String, FlowSet> entry : maps) {
            String key = entry.getKey();
            System.out.println("---key=  " + key);
            FlowSet list = entry.getValue();
            if (list.size() <= 0) continue;
            System.out.println("**set:  " + list.size());
            for (JPegStmt stmt : list) {
                Tag tag1 = stmt.getTags().get(0);
                System.out.println(tag1 + " " + stmt);
            }
        }
        System.out.println("=========monitor--ends--------");
    }
}

