/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.thread.mhp;

import heros.solver.Pair;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import soot.toolkits.graph.DirectedGraph;
import soot.util.FastStack;

public class SCC<T> {
    private Set<T> gray = new HashSet<T>();
    private final LinkedList<T> finishedOrder = new LinkedList();
    private final List<List<T>> sccList = new ArrayList<List<T>>();

    public SCC(Iterator<T> it, DirectedGraph<T> g2) {
        while (it.hasNext()) {
            T s2 = it.next();
            if (this.gray.contains(s2)) continue;
            this.visitNode(g2, s2);
        }
        this.gray = new HashSet<T>();
        for (Object s3 : this.finishedOrder) {
            if (this.gray.contains(s3)) continue;
            ArrayList scc = new ArrayList();
            this.visitRevNode(g2, s3, scc);
            this.sccList.add(scc);
        }
    }

    private void visitNode(DirectedGraph<T> g2, T s2) {
        this.gray.add(s2);
        FastStack<Pair<Object, Iterator<T>>> stack = new FastStack<Pair<Object, Iterator<T>>>();
        stack.push(new Pair<T, Iterator<T>>(s2, g2.getSuccsOf(s2).iterator()));
        block0: while (!stack.isEmpty()) {
            Pair p = (Pair)stack.peek();
            Iterator it = (Iterator)p.getO2();
            while (it.hasNext()) {
                Object succ = it.next();
                if (this.gray.contains(succ)) continue;
                this.gray.add(succ);
                stack.push(new Pair(succ, g2.getSuccsOf(succ).iterator()));
                continue block0;
            }
            stack.pop();
            this.finishedOrder.addFirst(p.getO1());
        }
    }

    private void visitRevNode(DirectedGraph<T> g2, T s2, List<T> scc) {
        scc.add(s2);
        this.gray.add(s2);
        FastStack<Iterator<T>> stack = new FastStack<Iterator<T>>();
        stack.push(g2.getPredsOf(s2).iterator());
        block0: while (!stack.isEmpty()) {
            Iterator predsIt = (Iterator)stack.peek();
            while (predsIt.hasNext()) {
                Object pred = predsIt.next();
                if (this.gray.contains(pred)) continue;
                scc.add(pred);
                this.gray.add(pred);
                stack.push(g2.getPredsOf(pred).iterator());
                continue block0;
            }
            stack.pop();
        }
    }

    public List<List<T>> getSccList() {
        return this.sccList;
    }

    public LinkedList<T> getFinishedOrder() {
        return this.finishedOrder;
    }
}

