/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.thread.mhp;

import heros.util.SootThreadGroup;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Kind;
import soot.PointsToAnalysis;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;
import soot.Unit;
import soot.jimple.Stmt;
import soot.jimple.spark.ondemand.DemandCSPointsTo;
import soot.jimple.spark.pag.AllocNode;
import soot.jimple.spark.pag.PAG;
import soot.jimple.toolkits.callgraph.CallGraph;
import soot.jimple.toolkits.callgraph.Edge;
import soot.jimple.toolkits.thread.AbstractRuntimeThread;
import soot.jimple.toolkits.thread.mhp.MhpTester;
import soot.jimple.toolkits.thread.mhp.StartJoinFinder;
import soot.jimple.toolkits.thread.mhp.findobject.AllocNodesFinder;
import soot.jimple.toolkits.thread.mhp.findobject.MultiRunStatementsFinder;
import soot.jimple.toolkits.thread.mhp.pegcallgraph.PegCallGraph;
import soot.options.SparkOptions;
import soot.toolkits.graph.CompleteUnitGraph;
import soot.toolkits.scalar.FlowSet;

public class SynchObliviousMhpAnalysis
implements MhpTester,
Runnable {
    private static final Logger logger = LoggerFactory.getLogger(SynchObliviousMhpAnalysis.class);
    List<AbstractRuntimeThread> threadList = new ArrayList<AbstractRuntimeThread>();
    boolean optionPrintDebug = false;
    boolean optionThreaded = false;
    Thread self = null;

    public SynchObliviousMhpAnalysis() {
        this.buildThreadList();
    }

    protected void buildThreadList() {
        if (this.optionThreaded) {
            if (this.self != null) {
                return;
            }
            this.self = new Thread((ThreadGroup)new SootThreadGroup(), this);
            this.self.start();
        } else {
            this.run();
        }
    }

    @Override
    public void run() {
        SootMethod mainMethod = Scene.v().getMainClass().getMethodByName("main");
        PointsToAnalysis pta = Scene.v().getPointsToAnalysis();
        if (pta instanceof DemandCSPointsTo) {
            DemandCSPointsTo demandCSPointsTo = (DemandCSPointsTo)pta;
            pta = demandCSPointsTo.getPAG();
        }
        if (!(pta instanceof PAG)) {
            throw new RuntimeException("You must use Spark for points-to analysis when computing MHP information!");
        }
        PAG pag = (PAG)pta;
        SparkOptions so = pag.getOpts();
        if (so.rta()) {
            throw new RuntimeException("MHP cannot be calculated using RTA due to incomplete call graph");
        }
        CallGraph callGraph = Scene.v().getCallGraph();
        PegCallGraph pecg = new PegCallGraph(callGraph);
        AllocNodesFinder anf = new AllocNodesFinder(pecg, callGraph, (PAG)pta);
        Set<AllocNode> multiRunAllocNodes = anf.getMultiRunAllocNodes();
        Set<SootMethod> multiCalledMethods = anf.getMultiCalledMethods();
        StartJoinFinder sjf = new StartJoinFinder(callGraph, (PAG)pta);
        Map<Stmt, List<AllocNode>> startToAllocNodes = sjf.getStartToAllocNodes();
        Map<Stmt, List<SootMethod>> startToRunMethods = sjf.getStartToRunMethods();
        Map<Stmt, SootMethod> startToContainingMethod = sjf.getStartToContainingMethod();
        Map<Stmt, Stmt> startToJoin = sjf.getStartToJoin();
        ArrayList<AbstractRuntimeThread> runAtOnceCandidates = new ArrayList<AbstractRuntimeThread>();
        Iterator<Map.Entry<Stmt, List<SootMethod>>> threadIt = startToRunMethods.entrySet().iterator();
        int threadNum = 0;
        while (threadIt.hasNext()) {
            CompleteUnitGraph graph;
            MultiRunStatementsFinder finder;
            FlowSet multiRunStatements;
            boolean mayStartMultipleThreadObjects;
            int methodNum;
            Map.Entry<Stmt, List<SootMethod>> e = threadIt.next();
            Stmt startStmt = e.getKey();
            List<SootMethod> runMethods = e.getValue();
            List<AllocNode> threadAllocNodes = startToAllocNodes.get(e.getKey());
            AbstractRuntimeThread thread = new AbstractRuntimeThread();
            thread.setStartStmt(startStmt);
            for (SootMethod method : runMethods) {
                if (thread.containsMethod(method)) continue;
                thread.addMethod(method);
                thread.addRunMethod(method);
            }
            for (methodNum = 0; methodNum < thread.methodCount(); ++methodNum) {
                for (SootMethod method : pecg.getSuccsOf(thread.getMethod(methodNum))) {
                    boolean ignoremethod = true;
                    Iterator<Edge> edgeInIt = callGraph.edgesInto(method);
                    while (edgeInIt.hasNext()) {
                        Edge edge = edgeInIt.next();
                        if (edge.kind() == Kind.THREAD || edge.kind() == Kind.EXECUTOR || edge.kind() == Kind.ASYNCTASK || !thread.containsMethod(edge.src())) continue;
                        ignoremethod = false;
                    }
                    if (ignoremethod || thread.containsMethod(method)) continue;
                    thread.addMethod(method);
                }
            }
            this.threadList.add(thread);
            if (this.optionPrintDebug) {
                System.out.println(thread.toString());
            }
            boolean bl = mayStartMultipleThreadObjects = threadAllocNodes.size() > 1 || so.types_for_sites();
            if (!mayStartMultipleThreadObjects && multiRunAllocNodes.contains(threadAllocNodes.iterator().next())) {
                mayStartMultipleThreadObjects = true;
            }
            if (mayStartMultipleThreadObjects) {
                thread.setStartStmtHasMultipleReachingObjects();
            }
            SootMethod startStmtMethod = startToContainingMethod.get(startStmt);
            thread.setStartStmtMethod(startStmtMethod);
            boolean mayBeRunMultipleTimes = multiCalledMethods.contains(startStmtMethod);
            if (!mayBeRunMultipleTimes && (multiRunStatements = (finder = new MultiRunStatementsFinder(graph = new CompleteUnitGraph(startStmtMethod.getActiveBody()), startStmtMethod, multiCalledMethods, callGraph)).getMultiRunStatements()).contains(startStmt)) {
                mayBeRunMultipleTimes = true;
            }
            if (mayBeRunMultipleTimes) {
                thread.setStartStmtMayBeRunMultipleTimes();
            }
            if (mayBeRunMultipleTimes && startToJoin.containsKey(startStmt)) {
                thread.setJoinStmt(startToJoin.get(startStmt));
                mayBeRunMultipleTimes = false;
                ArrayList<SootMethod> containingMethodCalls = new ArrayList<SootMethod>();
                containingMethodCalls.add(startStmtMethod);
                block5: for (methodNum = 0; methodNum < containingMethodCalls.size(); ++methodNum) {
                    for (SootMethod method : pecg.getSuccsOf(containingMethodCalls.get(methodNum))) {
                        if (method == startStmtMethod) {
                            mayBeRunMultipleTimes = true;
                            thread.setStartMethodIsReentrant();
                            thread.setRunsMany();
                            continue block5;
                        }
                        if (containingMethodCalls.contains(method)) continue;
                        containingMethodCalls.add(method);
                    }
                }
                if (!mayBeRunMultipleTimes) {
                    runAtOnceCandidates.add(thread);
                }
            }
            if (this.optionPrintDebug) {
                System.out.println("Start Stmt " + startStmt.toString() + " mayStartMultipleThreadObjects=" + mayStartMultipleThreadObjects + " mayBeRunMultipleTimes=" + mayBeRunMultipleTimes);
            }
            if (mayStartMultipleThreadObjects && mayBeRunMultipleTimes) {
                this.threadList.add(thread);
                thread.setRunsMany();
                if (this.optionPrintDebug) {
                    System.out.println(thread.toString());
                }
            } else {
                thread.setRunsOnce();
            }
            ++threadNum;
        }
        AbstractRuntimeThread mainThread = new AbstractRuntimeThread();
        this.threadList.add(mainThread);
        mainThread.setRunsOnce();
        mainThread.addMethod(mainMethod);
        mainThread.addRunMethod(mainMethod);
        mainThread.setIsMainThread();
        for (int methodNum = 0; methodNum < mainThread.methodCount(); ++methodNum) {
            for (SootMethod method : pecg.getSuccsOf(mainThread.getMethod(methodNum))) {
                boolean ignoremethod = true;
                Iterator<Edge> edgeInIt = callGraph.edgesInto(method);
                while (edgeInIt.hasNext()) {
                    if (edgeInIt.next().kind() == Kind.THREAD) continue;
                    ignoremethod = false;
                }
                if (ignoremethod || mainThread.containsMethod(method)) continue;
                mainThread.addMethod(method);
            }
        }
        if (this.optionPrintDebug) {
            logger.debug("" + mainThread.toString());
        }
        boolean addedNew = true;
        while (addedNew) {
            addedNew = false;
            Iterator it = runAtOnceCandidates.listIterator();
            while (it.hasNext()) {
                AbstractRuntimeThread someThread = (AbstractRuntimeThread)it.next();
                SootMethod someStartMethod = someThread.getStartStmtMethod();
                if (!this.mayHappenInParallelInternal(someStartMethod, someStartMethod)) continue;
                this.threadList.add(someThread);
                someThread.setStartMethodMayHappenInParallel();
                someThread.setRunsMany();
                it.remove();
                if (this.optionPrintDebug) {
                    logger.debug("" + someThread.toString());
                }
                addedNew = true;
            }
        }
        for (AbstractRuntimeThread someThread : runAtOnceCandidates) {
            someThread.setRunsOneAtATime();
        }
    }

    @Override
    public boolean mayHappenInParallel(SootMethod m1, Unit u1, SootMethod m22, Unit u2) {
        if (this.optionThreaded) {
            if (this.self == null) {
                return true;
            }
            logger.debug("[mhp] waiting for analysis thread to finish");
            try {
                this.self.join();
            }
            catch (InterruptedException ie) {
                return true;
            }
        }
        return this.mayHappenInParallelInternal(m1, m22);
    }

    @Override
    public boolean mayHappenInParallel(SootMethod m1, SootMethod m22) {
        if (this.optionThreaded) {
            if (this.self == null) {
                return true;
            }
            logger.debug("[mhp] waiting for thread to finish");
            try {
                this.self.join();
            }
            catch (InterruptedException ie) {
                return true;
            }
        }
        return this.mayHappenInParallelInternal(m1, m22);
    }

    private boolean mayHappenInParallelInternal(SootMethod m1, SootMethod m22) {
        if (this.threadList == null) {
            return true;
        }
        int size = this.threadList.size();
        for (int i = 0; i < size; ++i) {
            if (!this.threadList.get(i).containsMethod(m1)) continue;
            for (int j = 0; j < size; ++j) {
                if (!this.threadList.get(j).containsMethod(m22) || i == j) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void printMhpSummary() {
        if (this.optionThreaded) {
            if (this.self == null) {
                return;
            }
            logger.debug("[mhp] waiting for thread to finish");
            try {
                this.self.join();
            }
            catch (InterruptedException ie) {
                return;
            }
        }
        ArrayList<AbstractRuntimeThread> threads = new ArrayList<AbstractRuntimeThread>();
        int size = this.threadList.size();
        logger.debug("[mhp]");
        for (int i = 0; i < size; ++i) {
            if (!threads.contains(this.threadList.get(i))) {
                logger.debug("[mhp] " + this.threadList.get(i).toString().replaceAll("\n", "\n[mhp] ").replaceAll(">,", ">\n[mhp]  "));
                logger.debug("[mhp]");
            }
            threads.add(this.threadList.get(i));
        }
    }

    public List<SootClass> getThreadClassList() {
        if (this.optionThreaded) {
            if (this.self == null) {
                return null;
            }
            logger.debug("[mhp] waiting for thread to finish");
            try {
                this.self.join();
            }
            catch (InterruptedException ie) {
                return null;
            }
        }
        if (this.threadList == null) {
            return null;
        }
        ArrayList<SootClass> threadClasses = new ArrayList<SootClass>();
        int size = this.threadList.size();
        for (int i = 0; i < size; ++i) {
            AbstractRuntimeThread thread = this.threadList.get(i);
            Iterator<Object> threadRunMethodIt = thread.getRunMethods().iterator();
            while (threadRunMethodIt.hasNext()) {
                SootClass threadClass = ((SootMethod)threadRunMethodIt.next()).getDeclaringClass();
                if (threadClasses.contains(threadClass) || !threadClass.isApplicationClass()) continue;
                threadClasses.add(threadClass);
            }
        }
        return threadClasses;
    }

    @Override
    public List<AbstractRuntimeThread> getThreads() {
        if (this.optionThreaded) {
            if (this.self == null) {
                return null;
            }
            logger.debug("[mhp] waiting for thread to finish");
            try {
                this.self.join();
            }
            catch (InterruptedException ie) {
                return null;
            }
        }
        if (this.threadList == null) {
            return null;
        }
        ArrayList<AbstractRuntimeThread> threads = new ArrayList<AbstractRuntimeThread>();
        int size = this.threadList.size();
        for (int i = 0; i < size; ++i) {
            if (threads.contains(this.threadList.get(i))) continue;
            threads.add(this.threadList.get(i));
        }
        return threads;
    }
}

