/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.thread.synchronization;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Body;
import soot.BodyTransformer;
import soot.EquivalentValue;
import soot.Local;
import soot.PatchingChain;
import soot.RefType;
import soot.Scene;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.Trap;
import soot.Type;
import soot.Unit;
import soot.UnitPatchingChain;
import soot.Value;
import soot.VoidType;
import soot.jimple.ArrayRef;
import soot.jimple.AssignStmt;
import soot.jimple.EnterMonitorStmt;
import soot.jimple.ExitMonitorStmt;
import soot.jimple.FieldRef;
import soot.jimple.GotoStmt;
import soot.jimple.IdentityStmt;
import soot.jimple.InstanceFieldRef;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InvokeStmt;
import soot.jimple.Jimple;
import soot.jimple.JimpleBody;
import soot.jimple.Ref;
import soot.jimple.StaticFieldRef;
import soot.jimple.Stmt;
import soot.jimple.ThrowStmt;
import soot.jimple.toolkits.infoflow.FakeJimpleLocal;
import soot.jimple.toolkits.thread.synchronization.CriticalSection;
import soot.jimple.toolkits.thread.synchronization.CriticalSectionGroup;
import soot.jimple.toolkits.thread.synchronization.DeadlockAvoidanceEdge;
import soot.jimple.toolkits.thread.synchronization.LockableReferenceAnalysis;
import soot.jimple.toolkits.thread.synchronization.NewStaticLock;
import soot.jimple.toolkits.thread.synchronization.SynchronizedRegion;
import soot.jimple.toolkits.thread.synchronization.SynchronizedRegionFlowPair;
import soot.toolkits.scalar.FlowSet;
import soot.toolkits.scalar.Pair;
import soot.util.Chain;

public class LockAllocationBodyTransformer
extends BodyTransformer {
    private static final Logger logger = LoggerFactory.getLogger(LockAllocationBodyTransformer.class);
    private static final LockAllocationBodyTransformer instance = new LockAllocationBodyTransformer();
    private static boolean addedGlobalLockDefs = false;
    private static int throwableNum = 0;
    static int baseLocalNum = 0;
    static int lockNumber = 0;
    static Map<EquivalentValue, StaticFieldRef> lockEqValToLock = new HashMap<EquivalentValue, StaticFieldRef>();

    private LockAllocationBodyTransformer() {
    }

    public static LockAllocationBodyTransformer v() {
        return instance;
    }

    protected void internalTransform(Body b, String phase, Map opts) {
        throw new RuntimeException("Not Supported");
    }

    /*
     * WARNING - void declaration
     */
    protected void internalTransform(Body b, FlowSet fs, List<CriticalSectionGroup> groups, boolean[] insertedGlobalLock) {
        int i;
        JimpleBody j = (JimpleBody)b;
        SootMethod thisMethod = b.getMethod();
        UnitPatchingChain units = b.getUnits();
        Iterator unitIt = units.iterator();
        Stmt firstUnit = j.getFirstNonIdentityStmt();
        Object lastUnit = units.getLast();
        Local[] lockObj = new Local[groups.size()];
        boolean[] addedLocalLockObj = new boolean[groups.size()];
        SootField[] globalLockObj = new SootField[groups.size()];
        for (i = 1; i < groups.size(); ++i) {
            lockObj[i] = Jimple.v().newLocal("lockObj" + i, RefType.v("java.lang.Object"));
            addedLocalLockObj[i] = false;
            globalLockObj[i] = null;
        }
        for (i = 1; i < groups.size(); ++i) {
            CriticalSectionGroup tnGroup = groups.get(i);
            if (tnGroup.useDynamicLock || tnGroup.useLocksets) continue;
            if (!insertedGlobalLock[i]) {
                try {
                    globalLockObj[i] = Scene.v().getMainClass().getFieldByName("globalLockObj" + i);
                }
                catch (RuntimeException re) {
                    globalLockObj[i] = Scene.v().makeSootField("globalLockObj" + i, RefType.v("java.lang.Object"), 9);
                    Scene.v().getMainClass().addField(globalLockObj[i]);
                }
                insertedGlobalLock[i] = true;
                continue;
            }
            globalLockObj[i] = Scene.v().getMainClass().getFieldByName("globalLockObj" + i);
        }
        if (!addedGlobalLockDefs) {
            boolean addingNewClinit;
            SootClass mainClass = Scene.v().getMainClass();
            SootMethod clinitMethod = null;
            JimpleBody clinitBody = null;
            Stmt firstStmt = null;
            boolean bl = addingNewClinit = !mainClass.declaresMethod("void <clinit>()");
            if (addingNewClinit) {
                clinitMethod = Scene.v().makeSootMethod("<clinit>", new ArrayList<Type>(), VoidType.v(), 9);
                clinitBody = Jimple.v().newBody(clinitMethod);
                clinitMethod.setActiveBody(clinitBody);
                mainClass.addMethod(clinitMethod);
            } else {
                clinitMethod = mainClass.getMethod("void <clinit>()");
                clinitBody = (JimpleBody)clinitMethod.getActiveBody();
                firstStmt = clinitBody.getFirstNonIdentityStmt();
            }
            UnitPatchingChain clinitUnits = clinitBody.getUnits();
            for (int i2 = 1; i2 < groups.size(); ++i2) {
                CriticalSectionGroup tnGroup = groups.get(i2);
                if (tnGroup.useDynamicLock || tnGroup.useLocksets) continue;
                clinitBody.getLocals().add(lockObj[i2]);
                AssignStmt newStmt = Jimple.v().newAssignStmt(lockObj[i2], Jimple.v().newNewExpr(RefType.v("java.lang.Object")));
                if (addingNewClinit) {
                    clinitUnits.add(newStmt);
                } else {
                    clinitUnits.insertBeforeNoRedirect(newStmt, firstStmt);
                }
                SootClass objectClass = Scene.v().loadClassAndSupport("java.lang.Object");
                RefType type = RefType.v(objectClass);
                SootMethod sootMethod = objectClass.getMethod("void <init>()");
                InvokeStmt initStmt = Jimple.v().newInvokeStmt(Jimple.v().newSpecialInvokeExpr(lockObj[i2], sootMethod.makeRef(), Collections.EMPTY_LIST));
                if (addingNewClinit) {
                    clinitUnits.add(initStmt);
                } else {
                    clinitUnits.insertBeforeNoRedirect(initStmt, firstStmt);
                }
                AssignStmt assignStmt = Jimple.v().newAssignStmt(Jimple.v().newStaticFieldRef(globalLockObj[i2].makeRef()), lockObj[i2]);
                if (addingNewClinit) {
                    clinitUnits.add(assignStmt);
                    continue;
                }
                clinitUnits.insertBeforeNoRedirect(assignStmt, firstStmt);
            }
            if (addingNewClinit) {
                clinitUnits.add(Jimple.v().newReturnVoidStmt());
            }
            addedGlobalLockDefs = true;
        }
        int tempNum = 1;
        Iterator fsIt = fs.iterator();
        AssignStmt newPrep = null;
        while (fsIt.hasNext()) {
            Object tmp;
            CriticalSection tn = ((SynchronizedRegionFlowPair)fsIt.next()).tn;
            if (tn.setNumber == -1) continue;
            if (tn.wholeMethod) {
                thisMethod.setModifiers(thisMethod.getModifiers() & 0xFFFFFFDF);
            }
            Local clo = null;
            SynchronizedRegion csr = null;
            int lockNum = 0;
            boolean moreLocks = true;
            while (moreLocks) {
                ExitMonitorStmt newExitmonitor;
                Object endExitmonitor;
                InstanceFieldRef ifr;
                Value lock;
                if (tn.group.useDynamicLock) {
                    lock = LockAllocationBodyTransformer.getLockFor((EquivalentValue)tn.lockObject);
                    if (lock instanceof Ref) {
                        if (lock instanceof InstanceFieldRef && (ifr = (InstanceFieldRef)lock).getBase() instanceof FakeJimpleLocal) {
                            lock = this.reconstruct(b, units, ifr, tn.entermonitor != null ? tn.entermonitor : tn.beginning, tn.entermonitor != null);
                        }
                        if (!b.getLocals().contains(lockObj[tn.setNumber])) {
                            b.getLocals().add(lockObj[tn.setNumber]);
                        }
                        newPrep = Jimple.v().newAssignStmt(lockObj[tn.setNumber], lock);
                        if (tn.wholeMethod) {
                            units.insertBeforeNoRedirect(newPrep, firstUnit);
                        } else {
                            units.insertBefore(newPrep, tn.entermonitor);
                        }
                        clo = lockObj[tn.setNumber];
                    } else if (lock instanceof Local) {
                        clo = (Local)lock;
                    } else {
                        throw new RuntimeException("Unknown type of lock (" + lock + "): expected Ref or Local");
                    }
                    csr = tn;
                    moreLocks = false;
                } else if (tn.group.useLocksets) {
                    lock = LockAllocationBodyTransformer.getLockFor(tn.lockset.get(lockNum));
                    if (lock instanceof FieldRef) {
                        if (lock instanceof InstanceFieldRef && (ifr = (InstanceFieldRef)lock).getBase() instanceof FakeJimpleLocal) {
                            lock = this.reconstruct(b, units, ifr, tn.entermonitor != null ? tn.entermonitor : tn.beginning, tn.entermonitor != null);
                        }
                        Local lockLocal = Jimple.v().newLocal("locksetObj" + tempNum, RefType.v("java.lang.Object"));
                        ++tempNum;
                        b.getLocals().add(lockLocal);
                        newPrep = Jimple.v().newAssignStmt(lockLocal, lock);
                        if (tn.entermonitor != null) {
                            units.insertBefore(newPrep, tn.entermonitor);
                        } else {
                            units.insertBeforeNoRedirect(newPrep, tn.beginning);
                        }
                        clo = lockLocal;
                    } else if (lock instanceof Local) {
                        clo = (Local)lock;
                    } else {
                        throw new RuntimeException("Unknown type of lock (" + lock + "): expected FieldRef or Local");
                    }
                    moreLocks = lockNum + 1 < tn.lockset.size();
                    if (lockNum > 0) {
                        SynchronizedRegion nsr = new SynchronizedRegion();
                        nsr.beginning = csr.beginning;
                        for (Pair pair : csr.earlyEnds) {
                            Stmt earlyExitmonitor = (Stmt)pair.getO2();
                            nsr.earlyEnds.add(new Pair<Stmt, Object>(earlyExitmonitor, null));
                        }
                        nsr.last = csr.last;
                        if (csr.end != null) {
                            nsr.after = endExitmonitor = csr.end.getO2();
                        }
                        csr = nsr;
                    } else {
                        csr = tn;
                    }
                } else {
                    if (!addedLocalLockObj[tn.setNumber]) {
                        b.getLocals().add(lockObj[tn.setNumber]);
                    }
                    addedLocalLockObj[tn.setNumber] = true;
                    newPrep = Jimple.v().newAssignStmt(lockObj[tn.setNumber], Jimple.v().newStaticFieldRef(globalLockObj[tn.setNumber].makeRef()));
                    if (tn.wholeMethod) {
                        units.insertBeforeNoRedirect(newPrep, firstUnit);
                    } else {
                        units.insertBefore(newPrep, tn.entermonitor);
                    }
                    clo = lockObj[tn.setNumber];
                    csr = tn;
                    moreLocks = false;
                }
                if (csr.prepStmt != null) {
                    // empty if block
                }
                EnterMonitorStmt newEntermonitor = Jimple.v().newEnterMonitorStmt(clo);
                if (csr.entermonitor != null) {
                    units.insertBefore(newEntermonitor, csr.entermonitor);
                    units.remove(csr.entermonitor);
                    csr.entermonitor = newEntermonitor;
                } else {
                    units.insertBeforeNoRedirect(newEntermonitor, csr.beginning);
                    csr.entermonitor = newEntermonitor;
                }
                ArrayList<Pair<Stmt, Stmt>> newEarlyEnds = new ArrayList<Pair<Stmt, Stmt>>();
                endExitmonitor = csr.earlyEnds.iterator();
                while (endExitmonitor.hasNext()) {
                    Pair<Stmt, Stmt> pair = endExitmonitor.next();
                    Stmt earlyEnd = pair.getO1();
                    Stmt stmt = pair.getO2();
                    ExitMonitorStmt newExitmonitor2 = Jimple.v().newExitMonitorStmt(clo);
                    if (stmt != null) {
                        if (newPrep != null) {
                            Stmt tmp2 = (Stmt)newPrep.clone();
                            units.insertBefore(tmp2, stmt);
                        }
                        units.insertBefore(newExitmonitor2, stmt);
                        units.remove(stmt);
                        newEarlyEnds.add(new Pair<Stmt, ExitMonitorStmt>(earlyEnd, newExitmonitor2));
                        continue;
                    }
                    if (newPrep != null) {
                        Stmt tmp2 = (Stmt)newPrep.clone();
                        units.insertBefore(tmp2, earlyEnd);
                    }
                    units.insertBefore(newExitmonitor2, earlyEnd);
                    newEarlyEnds.add(new Pair<Stmt, ExitMonitorStmt>(earlyEnd, newExitmonitor2));
                }
                csr.earlyEnds = newEarlyEnds;
                if (csr.after != null) {
                    newExitmonitor = Jimple.v().newExitMonitorStmt(clo);
                    if (csr.end != null) {
                        Stmt stmt = csr.end.getO2();
                        if (newPrep != null) {
                            tmp = (Stmt)newPrep.clone();
                            units.insertBefore(tmp, stmt);
                        }
                        units.insertBefore(newExitmonitor, stmt);
                        units.remove(stmt);
                        csr.end = new Pair<Stmt, ExitMonitorStmt>(csr.end.getO1(), newExitmonitor);
                    } else {
                        if (newPrep != null) {
                            Stmt stmt = (Stmt)newPrep.clone();
                            units.insertBefore(stmt, csr.after);
                        }
                        units.insertBefore(newExitmonitor, csr.after);
                        GotoStmt gotoStmt = Jimple.v().newGotoStmt(csr.after);
                        units.insertBeforeNoRedirect(gotoStmt, csr.after);
                        csr.end = new Pair<GotoStmt, ExitMonitorStmt>(gotoStmt, newExitmonitor);
                        csr.last = gotoStmt;
                    }
                }
                newExitmonitor = Jimple.v().newExitMonitorStmt(clo);
                if (csr.exceptionalEnd != null) {
                    Stmt stmt = csr.exceptionalEnd.getO2();
                    if (newPrep != null) {
                        tmp = (Stmt)newPrep.clone();
                        units.insertBefore(tmp, stmt);
                    }
                    units.insertBefore(newExitmonitor, stmt);
                    units.remove(stmt);
                    csr.exceptionalEnd = new Pair<Stmt, ExitMonitorStmt>(csr.exceptionalEnd.getO1(), newExitmonitor);
                } else {
                    void var25_46;
                    Object var25_42 = null;
                    if (csr.end != null) {
                        Stmt stmt = csr.end.getO1();
                    } else {
                        for (Pair pair : csr.earlyEnds) {
                            void var25_44;
                            Stmt end = (Stmt)pair.getO1();
                            if (var25_44 != null && (!units.contains(var25_44) || !units.contains(end) || !units.follows(end, var25_44))) continue;
                            Stmt stmt = end;
                        }
                    }
                    if (csr.last == null) {
                        csr.last = var25_46;
                    }
                    if (var25_46 == null) {
                        throw new RuntimeException("Lock Region has no ends!  Where should we put the exception handling???");
                    }
                    Local throwableLocal = Jimple.v().newLocal("throwableLocal" + throwableNum++, RefType.v("java.lang.Throwable"));
                    b.getLocals().add(throwableLocal);
                    IdentityStmt identityStmt = Jimple.v().newIdentityStmt(throwableLocal, Jimple.v().newCaughtExceptionRef());
                    if (csr.last == null) {
                        throw new RuntimeException("WHY IS clr.last NULL???");
                    }
                    if (identityStmt == null) {
                        throw new RuntimeException("WHY IS newCatch NULL???");
                    }
                    units.insertAfter(identityStmt, csr.last);
                    units.insertAfter(newExitmonitor, identityStmt);
                    ThrowStmt newThrow = Jimple.v().newThrowStmt(throwableLocal);
                    units.insertAfter(newThrow, newExitmonitor);
                    SootClass throwableClass = Scene.v().loadClassAndSupport("java.lang.Throwable");
                    b.getTraps().addFirst(Jimple.v().newTrap(throwableClass, newExitmonitor, newThrow, identityStmt));
                    b.getTraps().addFirst(Jimple.v().newTrap(throwableClass, csr.beginning, (Unit)var25_46, identityStmt));
                    csr.exceptionalEnd = new Pair<ThrowStmt, ExitMonitorStmt>(newThrow, newExitmonitor);
                }
                ++lockNum;
            }
            for (Unit uNotify : tn.notifys) {
                Stmt sNotify = (Stmt)uNotify;
                InvokeStmt invokeStmt = Jimple.v().newInvokeStmt(Jimple.v().newVirtualInvokeExpr(clo, sNotify.getInvokeExpr().getMethodRef().declaringClass().getMethod("void notifyAll()").makeRef(), Collections.EMPTY_LIST));
                if (newPrep != null) {
                    tmp = (Stmt)newPrep.clone();
                    units.insertBefore(tmp, sNotify);
                    units.insertBefore(invokeStmt, tmp);
                } else {
                    units.insertBefore(invokeStmt, sNotify);
                }
                this.redirectTraps(b, sNotify, invokeStmt);
                units.remove(sNotify);
            }
            for (Unit uWait : tn.waits) {
                Stmt sWait = (Stmt)uWait;
                ((InstanceInvokeExpr)sWait.getInvokeExpr()).setBase(clo);
                if (newPrep == null) continue;
                units.insertBefore((Stmt)newPrep.clone(), sWait);
            }
        }
    }

    public InstanceFieldRef reconstruct(Body b, PatchingChain<Unit> units, InstanceFieldRef lock, Stmt insertBefore, boolean redirect) {
        Local baseLocal;
        logger.debug("Reconstructing " + lock);
        if (!(lock.getBase() instanceof FakeJimpleLocal)) {
            logger.debug("  base is not a FakeJimpleLocal");
            return lock;
        }
        FakeJimpleLocal fakeBase = (FakeJimpleLocal)lock.getBase();
        if (!(fakeBase.getInfo() instanceof LockableReferenceAnalysis)) {
            throw new RuntimeException("InstanceFieldRef cannot be reconstructed due to missing LocksetAnalysis info: " + lock);
        }
        LockableReferenceAnalysis la = (LockableReferenceAnalysis)fakeBase.getInfo();
        EquivalentValue baseEqVal = la.baseFor(lock);
        if (baseEqVal == null) {
            throw new RuntimeException("InstanceFieldRef cannot be reconstructed due to lost base from Lockset");
        }
        Value base = baseEqVal.getValue();
        if (base instanceof InstanceFieldRef) {
            InstanceFieldRef newBase = this.reconstruct(b, units, (InstanceFieldRef)base, insertBefore, redirect);
            baseLocal = Jimple.v().newLocal("baseLocal" + baseLocalNum++, newBase.getType());
            b.getLocals().add(baseLocal);
            AssignStmt baseAssign = Jimple.v().newAssignStmt(baseLocal, newBase);
            if (redirect) {
                units.insertBefore(baseAssign, (Unit)insertBefore);
            } else {
                units.insertBeforeNoRedirect(baseAssign, (Unit)insertBefore);
            }
        } else if (base instanceof Local) {
            baseLocal = (Local)base;
        } else {
            throw new RuntimeException("InstanceFieldRef cannot be reconstructed because it's base is of an unsupported type" + base.getType() + ": " + base);
        }
        InstanceFieldRef newLock = Jimple.v().newInstanceFieldRef(baseLocal, lock.getField().makeRef());
        logger.debug("  as " + newLock);
        return newLock;
    }

    public static Value getLockFor(EquivalentValue lockEqVal) {
        Value lock = lockEqVal.getValue();
        if (lock instanceof InstanceFieldRef) {
            return lock;
        }
        if (lock instanceof ArrayRef) {
            return ((ArrayRef)lock).getBase();
        }
        if (lock instanceof Local) {
            return lock;
        }
        if (lock instanceof StaticFieldRef || lock instanceof NewStaticLock) {
            boolean addingNewClinit;
            if (lockEqValToLock.containsKey(lockEqVal)) {
                return lockEqValToLock.get(lockEqVal);
            }
            SootClass lockClass = null;
            if (lock instanceof StaticFieldRef) {
                StaticFieldRef sfrLock = (StaticFieldRef)lock;
                lockClass = sfrLock.getField().getDeclaringClass();
            } else if (lock instanceof NewStaticLock) {
                DeadlockAvoidanceEdge dae = (DeadlockAvoidanceEdge)lock;
                lockClass = dae.getLockClass();
            }
            SootMethod clinitMethod = null;
            JimpleBody clinitBody = null;
            Stmt firstStmt = null;
            boolean bl = addingNewClinit = !lockClass.declaresMethod("void <clinit>()");
            if (addingNewClinit) {
                clinitMethod = Scene.v().makeSootMethod("<clinit>", new ArrayList<Type>(), VoidType.v(), 9);
                clinitBody = Jimple.v().newBody(clinitMethod);
                clinitMethod.setActiveBody(clinitBody);
                lockClass.addMethod(clinitMethod);
            } else {
                clinitMethod = lockClass.getMethod("void <clinit>()");
                clinitBody = (JimpleBody)clinitMethod.getActiveBody();
                firstStmt = clinitBody.getFirstNonIdentityStmt();
            }
            UnitPatchingChain clinitUnits = clinitBody.getUnits();
            Local lockLocal = Jimple.v().newLocal("objectLockLocal" + lockNumber, RefType.v("java.lang.Object"));
            clinitBody.getLocals().add(lockLocal);
            AssignStmt newStmt = Jimple.v().newAssignStmt(lockLocal, Jimple.v().newNewExpr(RefType.v("java.lang.Object")));
            if (addingNewClinit) {
                clinitUnits.add(newStmt);
            } else {
                clinitUnits.insertBeforeNoRedirect(newStmt, firstStmt);
            }
            SootClass objectClass = Scene.v().loadClassAndSupport("java.lang.Object");
            RefType type = RefType.v(objectClass);
            SootMethod initMethod = objectClass.getMethod("void <init>()");
            InvokeStmt initStmt = Jimple.v().newInvokeStmt(Jimple.v().newSpecialInvokeExpr(lockLocal, initMethod.makeRef(), Collections.EMPTY_LIST));
            if (addingNewClinit) {
                clinitUnits.add(initStmt);
            } else {
                clinitUnits.insertBeforeNoRedirect(initStmt, firstStmt);
            }
            SootField actualLockObject = Scene.v().makeSootField("objectLockGlobal" + lockNumber, RefType.v("java.lang.Object"), 9);
            ++lockNumber;
            lockClass.addField(actualLockObject);
            StaticFieldRef actualLockSfr = Jimple.v().newStaticFieldRef(actualLockObject.makeRef());
            AssignStmt assignStmt = Jimple.v().newAssignStmt(actualLockSfr, lockLocal);
            if (addingNewClinit) {
                clinitUnits.add(assignStmt);
            } else {
                clinitUnits.insertBeforeNoRedirect(assignStmt, firstStmt);
            }
            if (addingNewClinit) {
                clinitUnits.add(Jimple.v().newReturnVoidStmt());
            }
            lockEqValToLock.put(lockEqVal, actualLockSfr);
            return actualLockSfr;
        }
        throw new RuntimeException("Unknown type of lock (" + lock + "): expected FieldRef, ArrayRef, or Local");
    }

    public void redirectTraps(Body b, Unit oldUnit, Unit newUnit) {
        Chain<Trap> traps = b.getTraps();
        for (Trap trap : traps) {
            if (trap.getHandlerUnit() == oldUnit) {
                trap.setHandlerUnit(newUnit);
            }
            if (trap.getBeginUnit() == oldUnit) {
                trap.setBeginUnit(newUnit);
            }
            if (trap.getEndUnit() != oldUnit) continue;
            trap.setEndUnit(newUnit);
        }
    }
}

