/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.typing.integer;

import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.jimple.toolkits.typing.integer.TypeException;
import soot.jimple.toolkits.typing.integer.TypeVariable;

class StronglyConnectedComponents {
    private static final Logger logger = LoggerFactory.getLogger(StronglyConnectedComponents.class);
    private static final boolean DEBUG = false;
    private final Set<TypeVariable> black = new TreeSet<TypeVariable>();
    private final List<TypeVariable> finished = new LinkedList<TypeVariable>();
    private List<TypeVariable> current_tree = new LinkedList<TypeVariable>();

    public static void merge(List<TypeVariable> typeVariableList) throws TypeException {
        new StronglyConnectedComponents(typeVariableList);
    }

    private StronglyConnectedComponents(List<TypeVariable> typeVariableList) throws TypeException {
        for (TypeVariable var : typeVariableList) {
            if (this.black.contains(var)) continue;
            this.black.add(var);
            this.dfsg_visit(var);
        }
        this.black.clear();
        LinkedList<List<TypeVariable>> forest = new LinkedList<List<TypeVariable>>();
        for (TypeVariable typeVariable : this.finished) {
            if (this.black.contains(typeVariable)) continue;
            this.current_tree = new LinkedList<TypeVariable>();
            forest.add(this.current_tree);
            this.black.add(typeVariable);
            this.dfsgt_visit(typeVariable);
        }
        for (List list : forest) {
            Object s2 = null;
            TypeVariable previous = null;
            for (TypeVariable current : list) {
                if (previous == null) {
                    previous = current;
                    continue;
                }
                previous = previous.union(current);
            }
        }
    }

    private void dfsg_visit(TypeVariable var) {
        for (TypeVariable parent : var.parents()) {
            if (this.black.contains(parent)) continue;
            this.black.add(parent);
            this.dfsg_visit(parent);
        }
        this.finished.add(0, var);
    }

    private void dfsgt_visit(TypeVariable var) {
        this.current_tree.add(var);
        for (TypeVariable child : var.children()) {
            if (this.black.contains(child)) continue;
            this.black.add(child);
            this.dfsgt_visit(child);
        }
    }
}

