/*
 * Decompiled with CFR 0.152.
 */
package soot.toDex;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import soot.Local;
import soot.SootMethod;
import soot.Type;
import soot.Value;
import soot.jimple.ClassConstant;
import soot.jimple.Constant;
import soot.jimple.DoubleConstant;
import soot.jimple.FloatConstant;
import soot.jimple.IntConstant;
import soot.jimple.LongConstant;
import soot.jimple.NullConstant;
import soot.jimple.StringConstant;
import soot.toDex.ConstantVisitor;
import soot.toDex.Register;
import soot.toDex.SootToDexUtils;
import soot.toDex.TemporaryRegisterLocal;

public class RegisterAllocator {
    private int nextRegNum;
    private Map<Local, Integer> localToLastRegNum;
    private int paramRegCount;
    private List<Register> classConstantReg = new ArrayList<Register>();
    private List<Register> nullConstantReg = new ArrayList<Register>();
    private List<Register> floatConstantReg = new ArrayList<Register>();
    private List<Register> intConstantReg = new ArrayList<Register>();
    private List<Register> longConstantReg = new ArrayList<Register>();
    private List<Register> doubleConstantReg = new ArrayList<Register>();
    private List<Register> stringConstantReg = new ArrayList<Register>();
    private AtomicInteger classI = new AtomicInteger(0);
    private AtomicInteger nullI = new AtomicInteger(0);
    private AtomicInteger floatI = new AtomicInteger(0);
    private AtomicInteger intI = new AtomicInteger(0);
    private AtomicInteger longI = new AtomicInteger(0);
    private AtomicInteger doubleI = new AtomicInteger(0);
    private AtomicInteger stringI = new AtomicInteger(0);
    private Set<Register> lockedRegisters = new HashSet<Register>();
    private int lastReg;
    private Register currentLocalRegister;

    public RegisterAllocator() {
        this.localToLastRegNum = new HashMap<Local, Integer>();
    }

    private Register asConstant(Constant c, ConstantVisitor constantV) {
        Register constantRegister = null;
        List<Register> rArray = null;
        AtomicInteger iI = null;
        if (c instanceof ClassConstant) {
            rArray = this.classConstantReg;
            iI = this.classI;
        } else if (c instanceof NullConstant) {
            rArray = this.nullConstantReg;
            iI = this.nullI;
        } else if (c instanceof FloatConstant) {
            rArray = this.floatConstantReg;
            iI = this.floatI;
        } else if (c instanceof IntConstant) {
            rArray = this.intConstantReg;
            iI = this.intI;
        } else if (c instanceof LongConstant) {
            rArray = this.longConstantReg;
            iI = this.longI;
        } else if (c instanceof DoubleConstant) {
            rArray = this.doubleConstantReg;
            iI = this.doubleI;
        } else if (c instanceof StringConstant) {
            rArray = this.stringConstantReg;
            iI = this.stringI;
        } else {
            throw new RuntimeException("Error. Unknown constant type: '" + c.getType() + "'");
        }
        boolean inConflict = true;
        while (inConflict) {
            if (rArray.size() == 0 || iI.intValue() >= rArray.size()) {
                rArray.add(new Register(c.getType(), this.nextRegNum));
                this.nextRegNum += SootToDexUtils.getDexWords(c.getType());
            }
            constantRegister = rArray.get(iI.getAndIncrement()).clone();
            inConflict = this.lockedRegisters.contains(constantRegister);
        }
        constantV.setDestination(constantRegister);
        c.apply(constantV);
        return constantRegister.clone();
    }

    public void resetImmediateConstantsPool() {
        this.classI = new AtomicInteger(0);
        this.nullI = new AtomicInteger(0);
        this.floatI = new AtomicInteger(0);
        this.intI = new AtomicInteger(0);
        this.longI = new AtomicInteger(0);
        this.doubleI = new AtomicInteger(0);
        this.stringI = new AtomicInteger(0);
    }

    public Map<Local, Integer> getLocalToRegisterMapping() {
        return this.localToLastRegNum;
    }

    public Register asLocal(Local local) {
        Register localRegister;
        Integer oldRegNum = this.localToLastRegNum.get(local);
        if (oldRegNum != null) {
            localRegister = new Register(local.getType(), oldRegNum);
        } else {
            localRegister = new Register(local.getType(), this.nextRegNum);
            this.localToLastRegNum.put(local, this.nextRegNum);
            this.nextRegNum += SootToDexUtils.getDexWords(local.getType());
        }
        return localRegister;
    }

    public void asParameter(SootMethod sm, Local l) {
        if (this.localToLastRegNum.containsKey(l)) {
            return;
        }
        int paramRegNum = 0;
        boolean found = false;
        if (!sm.isStatic()) {
            try {
                if (sm.getActiveBody().getThisLocal() == l) {
                    paramRegNum = 0;
                    found = true;
                }
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        if (!found) {
            for (int i = 0; i < sm.getParameterCount(); ++i) {
                if (sm.getActiveBody().getParameterLocal(i) == l) {
                    if (!sm.isStatic()) {
                        ++paramRegNum;
                    }
                    found = true;
                    break;
                }
                Type paramType = sm.getParameterType(i);
                paramRegNum += SootToDexUtils.getDexWords(paramType);
            }
        }
        if (!found) {
            throw new RuntimeException("Parameter local not found");
        }
        this.localToLastRegNum.put(l, paramRegNum);
        int wordsforParameters = SootToDexUtils.getDexWords(l.getType());
        this.nextRegNum = Math.max(this.nextRegNum + wordsforParameters, paramRegNum + wordsforParameters);
        this.paramRegCount += wordsforParameters;
    }

    public Register asImmediate(Value v, ConstantVisitor constantV) {
        if (v instanceof Constant) {
            return this.asConstant((Constant)v, constantV);
        }
        if (v instanceof Local) {
            return this.asLocal((Local)v);
        }
        throw new RuntimeException("expected Immediate (Constant or Local), but was: " + v.getClass());
    }

    public Register asTmpReg(Type regType) {
        int newRegCount = this.getRegCount();
        if (this.lastReg == newRegCount) {
            return this.currentLocalRegister;
        }
        this.currentLocalRegister = this.asLocal(new TemporaryRegisterLocal(regType));
        this.lastReg = newRegCount;
        return this.currentLocalRegister;
    }

    public void increaseRegCount(int amount) {
        this.nextRegNum += amount;
    }

    public int getParamRegCount() {
        return this.paramRegCount;
    }

    public int getRegCount() {
        return this.nextRegNum;
    }

    public void lockRegister(Register reg) {
        this.lockedRegisters.add(reg);
    }
}

