/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.graph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.options.Options;
import soot.toolkits.graph.DirectedGraph;
import soot.toolkits.graph.HashMutableDirectedGraph;
import soot.toolkits.graph.MutableDirectedGraph;
import soot.util.StationaryArrayList;

@Deprecated
public class StronglyConnectedComponents {
    private static final Logger logger = LoggerFactory.getLogger(StronglyConnectedComponents.class);
    private HashMap<Object, Object> nodeToColor;
    private static final Object Visited = new Object();
    private static final Object Black = new Object();
    private final LinkedList<Object> finishingOrder;
    private List<List> componentList = new ArrayList<List>();
    private final HashMap<Object, List<Object>> nodeToComponent = new HashMap();
    MutableDirectedGraph sccGraph = new HashMutableDirectedGraph();
    private final int[] indexStack;
    private final Object[] nodeStack;
    private int last;

    public StronglyConnectedComponents(DirectedGraph g2) {
        this.nodeToColor = new HashMap(3 * g2.size() / 2, 0.7f);
        this.indexStack = new int[g2.size()];
        this.nodeStack = new Object[g2.size()];
        this.finishingOrder = new LinkedList();
        for (Object n : g2) {
            if (this.nodeToColor.get(n) != null) continue;
            this.visitNode(g2, n);
        }
        this.nodeToColor = new HashMap(3 * g2.size(), 0.7f);
        for (Object e : this.finishingOrder) {
            if (this.nodeToColor.get(e) != null) continue;
            StationaryArrayList<Object> currentComponent = null;
            currentComponent = new StationaryArrayList<Object>();
            this.nodeToComponent.put(e, currentComponent);
            this.sccGraph.addNode(currentComponent);
            this.componentList.add(currentComponent);
            this.visitRevNode(g2, e, currentComponent);
        }
        this.componentList = Collections.unmodifiableList(this.componentList);
        if (Options.v().verbose()) {
            logger.debug("Done computing scc components");
            logger.debug("number of nodes in underlying graph: " + g2.size());
            logger.debug("number of components: " + this.sccGraph.size());
        }
    }

    private void visitNode(DirectedGraph graph, Object startNode) {
        this.last = 0;
        this.nodeToColor.put(startNode, Visited);
        this.nodeStack[this.last] = startNode;
        this.indexStack[this.last++] = -1;
        while (this.last > 0) {
            int n = this.last - 1;
            this.indexStack[n] = this.indexStack[n] + 1;
            int toVisitIndex = this.indexStack[n];
            Object toVisitNode = this.nodeStack[this.last - 1];
            if (toVisitIndex >= graph.getSuccsOf(toVisitNode).size()) {
                this.finishingOrder.addFirst(toVisitNode);
                --this.last;
                continue;
            }
            Object childNode = graph.getSuccsOf(toVisitNode).get(toVisitIndex);
            if (this.nodeToColor.get(childNode) != null) continue;
            this.nodeToColor.put(childNode, Visited);
            this.nodeStack[this.last] = childNode;
            this.indexStack[this.last++] = -1;
        }
    }

    private void visitRevNode(DirectedGraph graph, Object startNode, List<Object> currentComponent) {
        this.last = 0;
        this.nodeToColor.put(startNode, Visited);
        this.nodeStack[this.last] = startNode;
        this.indexStack[this.last++] = -1;
        while (this.last > 0) {
            int n = this.last - 1;
            this.indexStack[n] = this.indexStack[n] + 1;
            int toVisitIndex = this.indexStack[n];
            Object toVisitNode = this.nodeStack[this.last - 1];
            if (toVisitIndex >= graph.getPredsOf(toVisitNode).size()) {
                currentComponent.add(toVisitNode);
                this.nodeToComponent.put(toVisitNode, currentComponent);
                this.nodeToColor.put(toVisitNode, Black);
                --this.last;
                continue;
            }
            Object childNode = graph.getPredsOf(toVisitNode).get(toVisitIndex);
            if (this.nodeToColor.get(childNode) == null) {
                this.nodeToColor.put(childNode, Visited);
                this.nodeStack[this.last] = childNode;
                this.indexStack[this.last++] = -1;
                continue;
            }
            if (this.nodeToColor.get(childNode) != Black || this.nodeToComponent.get(childNode) == currentComponent) continue;
            this.sccGraph.addEdge(this.nodeToComponent.get(childNode), currentComponent);
        }
    }

    public boolean equivalent(Object a, Object b) {
        return this.nodeToComponent.get(a) == this.nodeToComponent.get(b);
    }

    public List<List> getComponents() {
        return this.componentList;
    }

    public List getComponentOf(Object a) {
        return this.nodeToComponent.get(a);
    }

    public DirectedGraph getSuperGraph() {
        return this.sccGraph;
    }
}

