/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.graph.pdg;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import soot.SootClass;
import soot.SootMethod;
import soot.Unit;
import soot.toolkits.graph.Block;
import soot.toolkits.graph.UnitGraph;
import soot.toolkits.graph.pdg.IRegion;

public class Region
implements IRegion {
    private SootClass m_class = null;
    private SootMethod m_method = null;
    private List<Block> m_blocks = null;
    private List<Unit> m_units = null;
    private int m_id = -1;
    private UnitGraph m_unitGraph = null;
    private IRegion m_parent = null;
    private List<IRegion> m_children = new ArrayList<IRegion>();

    public Region(int id, SootMethod m3, SootClass c, UnitGraph ug) {
        this(id, new ArrayList<Block>(), m3, c, ug);
    }

    public Region(int id, List<Block> blocks, SootMethod m3, SootClass c, UnitGraph ug) {
        this.m_blocks = blocks;
        this.m_id = id;
        this.m_method = m3;
        this.m_class = c;
        this.m_unitGraph = ug;
        this.m_units = null;
    }

    public Object clone() {
        Region r = new Region(this.m_id, this.m_method, this.m_class, this.m_unitGraph);
        r.m_blocks = (List)((ArrayList)this.m_blocks).clone();
        return r;
    }

    @Override
    public SootMethod getSootMethod() {
        return this.m_method;
    }

    @Override
    public SootClass getSootClass() {
        return this.m_class;
    }

    @Override
    public List<Block> getBlocks() {
        return this.m_blocks;
    }

    @Override
    public UnitGraph getUnitGraph() {
        return this.m_unitGraph;
    }

    @Override
    public List<Unit> getUnits() {
        if (this.m_units == null) {
            this.m_units = new LinkedList<Unit>();
            for (Block b : this.m_blocks) {
                for (Unit u : b) {
                    ((LinkedList)this.m_units).addLast(u);
                }
            }
        }
        return this.m_units;
    }

    @Override
    public List<Unit> getUnits(Unit from, Unit to) {
        return this.m_units.subList(this.m_units.indexOf(from), this.m_units.indexOf(to));
    }

    @Override
    public Unit getLast() {
        if (this.m_units != null && this.m_units.size() > 0) {
            return (Unit)((LinkedList)this.m_units).getLast();
        }
        return null;
    }

    @Override
    public Unit getFirst() {
        if (this.m_units != null && this.m_units.size() > 0) {
            return (Unit)((LinkedList)this.m_units).getFirst();
        }
        return null;
    }

    public void add(Block b) {
        this.m_blocks.add(0, b);
    }

    public void add2Back(Block b) {
        this.m_blocks.add(this.m_blocks.size(), b);
    }

    public void remove(Block b) {
        this.m_blocks.remove(b);
        this.m_units = null;
    }

    @Override
    public int getID() {
        return this.m_id;
    }

    @Override
    public boolean occursBefore(Unit u1, Unit u2) {
        int i = this.m_units.lastIndexOf(u1);
        int j = this.m_units.lastIndexOf(u2);
        if (i == -1 || j == -1) {
            throw new RuntimeException("These units don't exist in the region!");
        }
        return i < j;
    }

    @Override
    public void setParent(IRegion pr) {
        this.m_parent = pr;
    }

    @Override
    public IRegion getParent() {
        return this.m_parent;
    }

    @Override
    public void addChildRegion(IRegion chr) {
        if (!this.m_children.contains(chr)) {
            this.m_children.add(chr);
        }
    }

    @Override
    public List<IRegion> getChildRegions() {
        return this.m_children;
    }

    public String toString() {
        String str = new String();
        str = str + "Begin-----------Region:  " + this.m_id + "-------------\n";
        List<Unit> regionUnits = this.getUnits();
        for (Unit u : regionUnits) {
            str = str + u + "\n";
        }
        str = str + "End Region " + this.m_id + " -----------------------------\n";
        return str;
    }
}

