/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.scalar;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Timers;
import soot.Trap;
import soot.Unit;
import soot.UnitBox;
import soot.UnitPatchingChain;
import soot.options.Options;
import soot.toolkits.graph.PseudoTopologicalOrderer;
import soot.toolkits.graph.UnitGraph;
import soot.toolkits.graph.interaction.FlowInfo;
import soot.toolkits.graph.interaction.InteractionHandler;
import soot.toolkits.scalar.BranchedFlowAnalysis;

public abstract class ForwardBranchedFlowAnalysis<A>
extends BranchedFlowAnalysis<Unit, A> {
    private static final Logger logger = LoggerFactory.getLogger(ForwardBranchedFlowAnalysis.class);

    public ForwardBranchedFlowAnalysis(UnitGraph graph) {
        super(graph);
    }

    @Override
    protected boolean isForward() {
        return true;
    }

    private void accumulateAfterFlowSets(Unit s2, A[] flowRepositories, List<A> previousAfterFlows) {
        int repCount = 0;
        previousAfterFlows.clear();
        if (s2.fallsThrough()) {
            this.copy(((List)this.unitToAfterFallFlow.get(s2)).get(0), flowRepositories[repCount]);
            previousAfterFlows.add(flowRepositories[repCount++]);
        }
        if (s2.branches()) {
            for (Object fs : this.getBranchFlowAfter(s2)) {
                this.copy(fs, flowRepositories[repCount]);
                previousAfterFlows.add(flowRepositories[repCount++]);
            }
        }
    }

    @Override
    protected void doAnalysis() {
        TreeSet<Unit> changedUnits = new TreeSet<Unit>(new Comparator<Unit>(){
            final Map<Unit, Integer> numbers = new HashMap<Unit, Integer>();
            {
                int i = 1;
                for (Unit u : new PseudoTopologicalOrderer().newList(ForwardBranchedFlowAnalysis.this.graph, false)) {
                    this.numbers.put(u, i);
                    ++i;
                }
            }

            @Override
            public int compare(Unit o1, Unit o2) {
                return this.numbers.get(o1) - this.numbers.get(o2);
            }
        });
        int numNodes = this.graph.size();
        HashMap unitToIncomingFlowSets = new HashMap(numNodes * 2 + 1, 0.7f);
        for (Unit s2 : this.graph) {
            unitToIncomingFlowSets.put(s2, new ArrayList());
        }
        int numComputations = 0;
        int maxBranchSize = 0;
        UnitPatchingChain sl = ((UnitGraph)this.graph).getBody().getUnits();
        for (Unit s3 : this.graph) {
            changedUnits.add(s3);
            this.unitToBeforeFlow.put(s3, this.newInitialFlow());
            if (s3.fallsThrough()) {
                ArrayList fl = new ArrayList();
                fl.add(this.newInitialFlow());
                this.unitToAfterFallFlow.put(s3, fl);
                Unit succ = sl.getSuccOf(s3);
                if (succ != null) {
                    ((ArrayList)unitToIncomingFlowSets.get(succ)).addAll(fl);
                }
            } else {
                this.unitToAfterFallFlow.put(s3, new ArrayList());
            }
            List<UnitBox> unitBoxes = s3.getUnitBoxes();
            ArrayList l = new ArrayList();
            if (s3.branches()) {
                for (UnitBox ub : unitBoxes) {
                    Object f = this.newInitialFlow();
                    l.add(f);
                    ((ArrayList)unitToIncomingFlowSets.get(ub.getUnit())).add(f);
                }
            }
            this.unitToAfterBranchFlow.put(s3, l);
            if (unitBoxes.size() <= maxBranchSize) continue;
            maxBranchSize = unitBoxes.size();
        }
        List heads = this.graph.getHeads();
        for (Unit s3 : heads) {
            this.unitToBeforeFlow.put(s3, this.entryInitialFlow());
        }
        if (this.treatTrapHandlersAsEntries()) {
            for (Trap trap : ((UnitGraph)this.graph).getBody().getTraps()) {
                this.unitToBeforeFlow.put(trap.getHandlerUnit(), this.entryInitialFlow());
            }
        }
        Object[] flowRepositories = new Object[maxBranchSize + 1];
        Object[] previousFlowRepositories = new Object[maxBranchSize + 1];
        for (int i = 0; i < maxBranchSize + 1; ++i) {
            flowRepositories[i] = this.newInitialFlow();
            previousFlowRepositories[i] = this.newInitialFlow();
        }
        ArrayList previousAfterFlows = new ArrayList();
        ArrayList afterFlows = new ArrayList();
        while (!changedUnits.isEmpty()) {
            Unit s4 = changedUnits.first();
            changedUnits.remove(s4);
            this.accumulateAfterFlowSets(s4, previousFlowRepositories, previousAfterFlows);
            Object beforeFlow = this.getFlowBefore(s4);
            Iterator preds = ((ArrayList)unitToIncomingFlowSets.get(s4)).iterator();
            if (preds.hasNext()) {
                this.copy(preds.next(), beforeFlow);
                while (preds.hasNext()) {
                    Object otherBranchFlow = preds.next();
                    Object newBeforeFlow = this.newInitialFlow();
                    this.merge(s4, beforeFlow, otherBranchFlow, newBeforeFlow);
                    this.copy(newBeforeFlow, beforeFlow);
                }
                if (heads.contains(s4)) {
                    this.mergeInto(s4, beforeFlow, this.entryInitialFlow());
                }
            }
            List afterFallFlow = (List)this.unitToAfterFallFlow.get(s4);
            List afterBranchFlow = this.getBranchFlowAfter(s4);
            if (Options.v().interactive_mode()) {
                InteractionHandler ih = InteractionHandler.v();
                Object savedFlow = this.newInitialFlow();
                this.copy(beforeFlow, savedFlow);
                FlowInfo fi = new FlowInfo(savedFlow, s4, true);
                if (ih.getStopUnitList() != null && ih.getStopUnitList().contains(s4)) {
                    ih.handleStopAtNodeEvent(s4);
                }
                ih.handleBeforeAnalysisEvent(fi);
            }
            this.flowThrough(beforeFlow, s4, afterFallFlow, afterBranchFlow);
            if (Options.v().interactive_mode()) {
                ArrayList l = new ArrayList();
                if (!afterFallFlow.isEmpty()) {
                    l.addAll(afterFallFlow);
                }
                if (!afterBranchFlow.isEmpty()) {
                    l.addAll(afterBranchFlow);
                }
                FlowInfo fi = new FlowInfo(l, s4, false);
                InteractionHandler.v().handleAfterAnalysisEvent(fi);
            }
            ++numComputations;
            this.accumulateAfterFlowSets(s4, flowRepositories, afterFlows);
            if (afterFlows.equals(previousAfterFlows)) continue;
            for (Unit succ : this.graph.getSuccsOf(s4)) {
                changedUnits.add(succ);
            }
        }
        Timers.v().totalFlowNodes += numNodes;
        Timers.v().totalFlowComputations += numComputations;
    }
}

