/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.scalar;

import java.util.BitSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import soot.Timers;
import soot.toolkits.graph.DirectedGraph;
import soot.toolkits.graph.Orderer;
import soot.toolkits.graph.PseudoTopologicalOrderer;

public abstract class ForwardFlowAnalysisExtended<N, A> {
    protected Map<N, Map<N, A>> unitToBeforeFlow;
    protected Map<N, Map<N, A>> unitToAfterFlow;
    protected DirectedGraph<N> graph;

    public ForwardFlowAnalysisExtended(DirectedGraph<N> graph) {
        this.graph = graph;
        this.unitToBeforeFlow = new IdentityHashMap<N, Map<N, A>>(graph.size() * 2 + 1);
        this.unitToAfterFlow = new IdentityHashMap<N, Map<N, A>>(graph.size() * 2 + 1);
    }

    protected Orderer<N> constructOrderer() {
        return new PseudoTopologicalOrderer();
    }

    protected abstract A newInitialFlow();

    protected abstract A entryInitialFlow();

    protected abstract void copy(A var1, A var2);

    protected abstract void merge(A var1, A var2, A var3);

    protected void merge(N succNode, A in1, A in2, A out) {
        this.merge(in1, in2, out);
    }

    protected void mergeInto(N succNode, A inout, A in) {
        A tmp = this.newInitialFlow();
        this.merge(succNode, inout, in, tmp);
        this.copy(tmp, inout);
    }

    public A getFromMap(Map<N, Map<N, A>> map, N s2, N t) {
        Map<N, A> m3 = map.get(s2);
        return m3 != null ? (A)m3.get(t) : null;
    }

    public void putToMap(Map<N, Map<N, A>> map, N s2, N t, A val) {
        Map<N, A> m3 = map.get(s2);
        if (m3 == null) {
            m3 = new IdentityHashMap<N, A>();
            map.put(s2, m3);
        }
        m3.put(t, val);
    }

    protected void doAnalysis() {
        List<N> orderedUnits = this.constructOrderer().newList(this.graph, false);
        int n = orderedUnits.size();
        BitSet head = new BitSet();
        BitSet work = new BitSet(n);
        work.set(0, n);
        IdentityHashMap<N, Integer> index = new IdentityHashMap<N, Integer>(n * 2 + 1);
        int i = 0;
        for (Object s2 : orderedUnits) {
            index.put(s2, i++);
            for (N v : this.graph.getSuccsOf(s2)) {
                this.putToMap(this.unitToBeforeFlow, s2, v, this.newInitialFlow());
                this.putToMap(this.unitToAfterFlow, s2, v, this.newInitialFlow());
            }
        }
        for (N s3 : this.graph.getHeads()) {
            head.set((Integer)index.get(s3));
            for (Object v : this.graph.getSuccsOf(s3)) {
                this.putToMap(this.unitToBeforeFlow, s3, v, this.entryInitialFlow());
            }
        }
        int numComputations = 0;
        A previousFlow = this.newInitialFlow();
        int i2 = work.nextSetBit(0);
        while (i2 >= 0) {
            work.clear(i2);
            N s4 = orderedUnits.get(i2);
            int k = i2;
            for (N v : this.graph.getSuccsOf(s4)) {
                boolean hasChanged;
                A beforeFlow = this.getFromMap(this.unitToBeforeFlow, s4, v);
                A afterFlow = this.getFromMap(this.unitToAfterFlow, s4, v);
                this.copy(afterFlow, previousFlow);
                Iterator<N> it = this.graph.getPredsOf(s4).iterator();
                if (it.hasNext()) {
                    this.copy(this.getFromMap(this.unitToAfterFlow, it.next(), s4), beforeFlow);
                    while (it.hasNext()) {
                        this.mergeInto(s4, beforeFlow, this.getFromMap(this.unitToAfterFlow, it.next(), s4));
                    }
                    if (head.get(k)) {
                        this.mergeInto(s4, beforeFlow, this.entryInitialFlow());
                    }
                }
                this.flowThrough(beforeFlow, s4, v, afterFlow);
                boolean bl = hasChanged = !previousFlow.equals(afterFlow);
                if (hasChanged) {
                    int j = (Integer)index.get(v);
                    work.set(j);
                    i2 = Math.min(i2, j - 1);
                }
                ++numComputations;
            }
            i2 = work.nextSetBit(i2 + 1);
        }
        Timers.v().totalFlowNodes += n;
        Timers.v().totalFlowComputations += numComputations;
    }

    protected abstract void flowThrough(A var1, N var2, N var3, A var4);

    public A getFlowBefore(N s2) {
        A beforeFlow = null;
        Iterator<N> it = this.graph.getPredsOf(s2).iterator();
        if (it.hasNext()) {
            beforeFlow = this.getFromMap(this.unitToAfterFlow, it.next(), s2);
            while (it.hasNext()) {
                this.mergeInto(s2, beforeFlow, this.getFromMap(this.unitToAfterFlow, it.next(), s2));
            }
        }
        return beforeFlow;
    }
}

