/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.scalar;

import java.util.ArrayDeque;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Body;
import soot.BodyTransformer;
import soot.G;
import soot.Local;
import soot.Scene;
import soot.Singletons;
import soot.Timers;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.options.Options;
import soot.toolkits.exceptions.ThrowAnalysis;
import soot.toolkits.graph.ExceptionalUnitGraph;
import soot.toolkits.graph.ExceptionalUnitGraphFactory;
import soot.toolkits.scalar.LocalDefs;
import soot.toolkits.scalar.LocalUses;
import soot.toolkits.scalar.UnitValueBoxPair;
import soot.util.LocalBitSetPacker;

public class LocalSplitter
extends BodyTransformer {
    private static final Logger logger = LoggerFactory.getLogger(LocalSplitter.class);
    protected ThrowAnalysis throwAnalysis;
    protected boolean omitExceptingUnitEdges;

    public LocalSplitter(Singletons.Global g2) {
    }

    public LocalSplitter(ThrowAnalysis ta) {
        this(ta, false);
    }

    public LocalSplitter(ThrowAnalysis ta, boolean omitExceptingUnitEdges) {
        this.throwAnalysis = ta;
        this.omitExceptingUnitEdges = omitExceptingUnitEdges;
    }

    public static LocalSplitter v() {
        return G.v().soot_toolkits_scalar_LocalSplitter();
    }

    @Override
    protected void internalTransform(Body body, String phaseName, Map<String, String> options) {
        Iterator<ValueBox> defsInUnitItr;
        if (Options.v().verbose()) {
            logger.debug("[" + body.getMethod().getName() + "] Splitting locals...");
        }
        if (Options.v().time()) {
            Timers.v().splitTimer.start();
            Timers.v().splitPhase1Timer.start();
        }
        if (this.throwAnalysis == null) {
            this.throwAnalysis = Scene.v().getDefaultThrowAnalysis();
        }
        if (!this.omitExceptingUnitEdges) {
            this.omitExceptingUnitEdges = Options.v().omit_excepting_unit_edges();
        }
        LocalBitSetPacker localPacker = new LocalBitSetPacker(body);
        localPacker.pack();
        ExceptionalUnitGraph graph = ExceptionalUnitGraphFactory.createExceptionalUnitGraph(body, this.throwAnalysis, this.omitExceptingUnitEdges);
        LocalDefs defs = G.v().soot_toolkits_scalar_LocalDefsFactory().newLocalDefs(graph, true);
        LocalUses uses = LocalUses.Factory.newLocalUses(graph, defs);
        if (Options.v().time()) {
            Timers.v().splitPhase1Timer.end();
            Timers.v().splitPhase2Timer.start();
        }
        int localCount = localPacker.getLocalCount();
        BitSet localsVisited = new BitSet(localCount);
        BitSet localsToSplit = new BitSet(localCount);
        for (Unit s2 : body.getUnits()) {
            Value value;
            defsInUnitItr = s2.getDefBoxes().iterator();
            if (!defsInUnitItr.hasNext() || !((value = defsInUnitItr.next().getValue()) instanceof Local)) continue;
            int localNumber = ((Local)value).getNumber();
            if (localsVisited.get(localNumber)) {
                localsToSplit.set(localNumber);
                continue;
            }
            localsVisited.set(localNumber);
        }
        int w = 0;
        HashSet<Unit> visited = new HashSet<Unit>();
        for (Unit s2 : body.getUnits()) {
            Local oldLocal;
            defsInUnitItr = s2.getDefBoxes().iterator();
            if (!defsInUnitItr.hasNext()) continue;
            Value singleDef = defsInUnitItr.next().getValue();
            if (defsInUnitItr.hasNext()) {
                throw new RuntimeException("stmt with more than 1 defbox!");
            }
            if (!(singleDef instanceof Local) || visited.remove(s2) || !localsToSplit.get((oldLocal = (Local)singleDef).getNumber())) continue;
            Local newLocal = (Local)oldLocal.clone();
            String name = newLocal.getName();
            if (name != null) {
                newLocal.setName(name + '#' + ++w);
            }
            body.getLocals().add(newLocal);
            ArrayDeque<Unit> queue = new ArrayDeque<Unit>();
            queue.addFirst(s2);
            do {
                Unit head;
                if (!visited.add(head = (Unit)queue.removeFirst())) continue;
                for (UnitValueBoxPair use : uses.getUsesOf(head)) {
                    ValueBox vb = use.valueBox;
                    Value v = vb.getValue();
                    if (v == newLocal || !(v instanceof Local)) continue;
                    queue.addAll(defs.getDefsOfAt((Local)v, use.unit));
                    vb.setValue(newLocal);
                }
                for (ValueBox vb : head.getDefBoxes()) {
                    Value v = vb.getValue();
                    if (!(v instanceof Local)) continue;
                    vb.setValue(newLocal);
                }
            } while (!queue.isEmpty());
            visited.remove(s2);
        }
        localPacker.unpack();
        if (Options.v().time()) {
            Timers.v().splitPhase2Timer.end();
            Timers.v().splitTimer.end();
        }
    }
}

