/*
 * Decompiled with CFR 0.152.
 */
package soot.tools;

import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Main;
import soot.PackManager;
import soot.PrimType;
import soot.Scene;
import soot.SceneTransformer;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.Transform;
import soot.Value;
import soot.ValueBox;
import soot.jimple.FieldRef;
import soot.jimple.InvokeExpr;
import soot.jimple.StaticFieldRef;
import soot.jimple.Stmt;

public class BadFields
extends SceneTransformer {
    private static final Logger logger = LoggerFactory.getLogger(BadFields.class);
    private SootClass lastClass;
    private SootClass currentClass;

    public static void main(String[] args) {
        PackManager.v().getPack("cg").add(new Transform("cg.badfields", new BadFields()));
        Main.main(args);
    }

    @Override
    protected void internalTransform(String phaseName, Map<String, String> options) {
        this.lastClass = null;
        Iterator<SootClass> clIt = Scene.v().getApplicationClasses().iterator();
        while (clIt.hasNext()) {
            SootClass cl;
            this.currentClass = cl = clIt.next();
            this.handleClass(cl);
            Iterator<SootMethod> it = cl.methodIterator();
            while (it.hasNext()) {
                this.handleMethod(it.next());
            }
        }
        Scene.v().setCallGraph(Scene.v().internalMakeCallGraph());
    }

    private void handleClass(SootClass cl) {
        for (SootField f : cl.getFields()) {
            String typeName;
            if (!f.isStatic() || (typeName = f.getType().toString()).equals("java.lang.Class") || f.isFinal() && (f.getType() instanceof PrimType || typeName.equals("java.io.PrintStream") || typeName.equals("java.lang.String") || typeName.equals(Scene.v().getObjectType().toString()) || typeName.equals("java.lang.Integer") || typeName.equals("java.lang.Boolean"))) continue;
            this.warn("Bad field " + f);
        }
    }

    private void warn(String warning) {
        if (this.lastClass != this.currentClass) {
            logger.debug("In class " + this.currentClass);
        }
        this.lastClass = this.currentClass;
        logger.debug("  " + warning);
    }

    private void handleMethod(SootMethod m3) {
        InvokeExpr ie;
        SootMethod target;
        if (!m3.isConcrete()) {
            return;
        }
        for (ValueBox b : m3.retrieveActiveBody().getUseAndDefBoxes()) {
            StaticFieldRef sfr;
            SootField f;
            Value v = b.getValue();
            if (!(v instanceof StaticFieldRef) || !(f = (sfr = (StaticFieldRef)v).getField()).getDeclaringClass().getName().equals("java.lang.System")) continue;
            if (f.getName().equals("err")) {
                logger.debug("Use of System.err in " + m3);
            }
            if (!f.getName().equals("out")) continue;
            logger.debug("Use of System.out in " + m3);
        }
        for (Stmt s2 : m3.getActiveBody().getUnits()) {
            if (!s2.containsInvokeExpr() || !(target = (ie = s2.getInvokeExpr()).getMethod()).getDeclaringClass().getName().equals("java.lang.System") || !target.getName().equals("exit")) continue;
            this.warn("" + m3 + " calls System.exit");
        }
        if (m3.getName().equals("<clinit>")) {
            for (Stmt s2 : m3.getActiveBody().getUnits()) {
                for (ValueBox b : s2.getUseBoxes()) {
                    Value v = b.getValue();
                    if (!(v instanceof FieldRef)) continue;
                    this.warn(m3.getName() + " reads field " + v);
                }
                if (!s2.containsInvokeExpr()) continue;
                ie = s2.getInvokeExpr();
                target = ie.getMethod();
                this.calls(target);
            }
        }
    }

    private void calls(SootMethod target) {
        if (target.getName().equals("<init>")) {
            if (target.getDeclaringClass().getName().equals("java.io.PrintStream") || target.getDeclaringClass().getName().equals("java.lang.Boolean") || target.getDeclaringClass().getName().equals("java.lang.Integer") || target.getDeclaringClass().getName().equals("java.lang.String")) {
                return;
            }
            if (target.getDeclaringClass().getName().equals(Scene.v().getObjectType().toString())) {
                return;
            }
        }
        if (target.getName().equals("getProperty") && target.getDeclaringClass().getName().equals("java.lang.System")) {
            return;
        }
        if (target.getName().equals("charAt") && target.getDeclaringClass().getName().equals("java.lang.String")) {
            return;
        }
        this.warn("<clinit> invokes " + target);
    }
}

