/*
 * Decompiled with CFR 0.152.
 */
package soot.util;

import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ArraySet<E>
extends AbstractSet<E> {
    private static final int DEFAULT_SIZE = 8;
    private int numElements;
    private int maxElements;
    private E[] elements;

    public ArraySet(int size) {
        this.maxElements = size;
        Object[] newElements = new Object[size];
        this.elements = newElements;
        this.numElements = 0;
    }

    public ArraySet() {
        this(8);
    }

    public ArraySet(E[] elements) {
        this();
        for (E element : elements) {
            this.add(element);
        }
    }

    @Override
    public final void clear() {
        this.numElements = 0;
    }

    @Override
    public final boolean contains(Object obj) {
        for (int i = 0; i < this.numElements; ++i) {
            if (!this.elements[i].equals(obj)) continue;
            return true;
        }
        return false;
    }

    public final boolean addElement(E e) {
        if (e == null) {
            throw new RuntimeException("oops");
        }
        if (this.numElements == this.maxElements) {
            this.doubleCapacity();
        }
        this.elements[this.numElements++] = e;
        return true;
    }

    @Override
    public final boolean add(E e) {
        if (e == null) {
            throw new RuntimeException("oops");
        }
        if (this.contains(e)) {
            return false;
        }
        if (this.numElements == this.maxElements) {
            this.doubleCapacity();
        }
        this.elements[this.numElements++] = e;
        return true;
    }

    @Override
    public final boolean addAll(Collection<? extends E> s2) {
        if (s2 instanceof ArraySet) {
            boolean ret = false;
            ArraySet as = (ArraySet)s2;
            for (E elem : as.elements) {
                ret |= this.add(elem);
            }
            return ret;
        }
        return super.addAll(s2);
    }

    @Override
    public final int size() {
        return this.numElements;
    }

    @Override
    public final Iterator<E> iterator() {
        return new ArrayIterator();
    }

    private void removeElementAt(int index) {
        if (index == this.numElements - 1) {
            --this.numElements;
            return;
        }
        System.arraycopy(this.elements, index + 1, this.elements, index, this.numElements - (index + 1));
        --this.numElements;
    }

    private void doubleCapacity() {
        int newSize = this.maxElements * 2 + 1;
        Object[] newElements = new Object[newSize];
        System.arraycopy(this.elements, 0, newElements, 0, this.numElements);
        this.elements = newElements;
        this.maxElements = newSize;
    }

    @Override
    public final E[] toArray() {
        Object[] array = new Object[this.numElements];
        System.arraycopy(this.elements, 0, array, 0, this.numElements);
        return array;
    }

    @Override
    public final <T> T[] toArray(T[] array) {
        if (array.length < this.numElements) {
            T[] ret = Arrays.copyOf(this.elements, this.numElements, array.getClass());
            return ret;
        }
        System.arraycopy(this.elements, 0, array, 0, this.numElements);
        if (array.length > this.numElements) {
            array[this.numElements] = null;
        }
        return array;
    }

    public final Object[] getUnderlyingArray() {
        return this.elements;
    }

    private class ArrayIterator
    implements Iterator<E> {
        int nextIndex = 0;

        ArrayIterator() {
        }

        @Override
        public final boolean hasNext() {
            return this.nextIndex < ArraySet.this.numElements;
        }

        @Override
        public final E next() throws NoSuchElementException {
            if (this.nextIndex >= ArraySet.this.numElements) {
                throw new NoSuchElementException();
            }
            return ArraySet.this.elements[this.nextIndex++];
        }

        @Override
        public final void remove() throws NoSuchElementException {
            if (this.nextIndex == 0) {
                throw new NoSuchElementException();
            }
            ArraySet.this.removeElementAt(this.nextIndex - 1);
            --this.nextIndex;
        }
    }
}

