/*
 * Decompiled with CFR 0.152.
 */
package soot.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import soot.util.AbstractMultiMap;
import soot.util.MultiMap;

public class HashMultiMap<K, V>
extends AbstractMultiMap<K, V> {
    private static final long serialVersionUID = -1928446853508616896L;
    private static final float DEFAULT_LOAD_FACTOR = 0.7f;
    protected final Map<K, Set<V>> m;
    protected final float loadFactor;

    protected Map<K, Set<V>> createMap() {
        return this.createMap(0);
    }

    protected Map<K, Set<V>> createMap(int initialSize) {
        return new HashMap(initialSize, this.loadFactor);
    }

    public HashMultiMap() {
        this.loadFactor = 0.7f;
        this.m = this.createMap();
    }

    public HashMultiMap(int initialSize) {
        this.loadFactor = 0.7f;
        this.m = this.createMap(initialSize);
    }

    public HashMultiMap(int initialSize, float loadFactor) {
        this.loadFactor = loadFactor;
        this.m = this.createMap(initialSize);
    }

    public HashMultiMap(MultiMap<K, V> m3) {
        this.loadFactor = 0.7f;
        this.m = this.createMap();
        this.putAll(m3);
    }

    public HashMultiMap(Map<K, Collection<V>> m3) {
        this.loadFactor = 0.7f;
        this.m = this.createMap();
        this.putAll(m3);
    }

    @Override
    public int numKeys() {
        return this.m.size();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.m.containsKey(key);
    }

    @Override
    public boolean containsValue(V value) {
        for (Set<V> s2 : this.m.values()) {
            if (!s2.contains(value)) continue;
            return true;
        }
        return false;
    }

    protected Set<V> newSet() {
        return new HashSet(4);
    }

    private Set<V> findSet(K key) {
        Set<V> s2 = this.m.get(key);
        if (s2 == null) {
            s2 = this.newSet();
            this.m.put(key, s2);
        }
        return s2;
    }

    @Override
    public boolean put(K key, V value) {
        return this.findSet(key).add(value);
    }

    @Override
    public boolean putAll(K key, Collection<V> values) {
        if (values.isEmpty()) {
            return false;
        }
        return this.findSet(key).addAll(values);
    }

    @Override
    public boolean remove(K key, V value) {
        Set<V> s2 = this.m.get(key);
        if (s2 == null) {
            return false;
        }
        boolean ret = s2.remove(value);
        if (s2.isEmpty()) {
            this.m.remove(key);
        }
        return ret;
    }

    @Override
    public boolean remove(K key) {
        return null != this.m.remove(key);
    }

    @Override
    public boolean removeAll(K key, Collection<V> values) {
        Set<V> s2 = this.m.get(key);
        if (s2 == null) {
            return false;
        }
        boolean ret = s2.removeAll(values);
        if (s2.isEmpty()) {
            this.m.remove(key);
        }
        return ret;
    }

    @Override
    public Set<V> get(K o) {
        Set<V> ret = this.m.get(o);
        return ret == null ? Collections.emptySet() : ret;
    }

    @Override
    public Set<K> keySet() {
        return this.m.keySet();
    }

    @Override
    public Set<V> values() {
        HashSet<V> ret = new HashSet<V>(this.m.size());
        for (Set<V> s2 : this.m.values()) {
            ret.addAll(s2);
        }
        return ret;
    }

    public boolean equals(Object o) {
        if (!(o instanceof MultiMap)) {
            return false;
        }
        MultiMap mm3 = (MultiMap)o;
        if (!this.keySet().equals(mm3.keySet())) {
            return false;
        }
        for (Map.Entry<K, Set<V>> e : this.m.entrySet()) {
            Set<V> s2 = e.getValue();
            if (s2.equals(mm3.get(e.getKey()))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.m.hashCode();
    }

    @Override
    public int size() {
        return this.m.size();
    }

    @Override
    public void clear() {
        this.m.clear();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<K, Set<V>> entry : this.m.entrySet()) {
            builder.append(entry.getKey()).append(":\n").append(entry.getValue().toString()).append("\n\n");
        }
        if (builder.length() > 2) {
            builder.delete(builder.length() - 2, builder.length());
        }
        return builder.toString();
    }
}

