/*
 * Decompiled with CFR 0.152.
 */
package soot.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Body;
import soot.G;
import soot.Printer;
import soot.Scene;
import soot.Singletons;
import soot.SootClass;
import soot.SootMethod;
import soot.SourceLocator;
import soot.options.Options;
import soot.toolkits.graph.DirectedGraph;
import soot.toolkits.graph.ExceptionalGraph;
import soot.util.cfgcmd.CFGToDotGraph;

public class PhaseDumper {
    private static final Logger logger = LoggerFactory.getLogger(PhaseDumper.class);
    private static final String ALL_WILDCARD = "ALL";
    private final PhaseStack phaseStack = new PhaseStack();
    private List<String> bodyDumpingPhases = null;
    private List<String> cfgDumpingPhases = null;
    private boolean alreadyDumping = false;

    public PhaseDumper(Singletons.Global g2) {
        List<String> cfgPhases;
        List<String> bodyPhases = Options.v().dump_body();
        if (!bodyPhases.isEmpty()) {
            this.bodyDumpingPhases = bodyPhases;
        }
        if (!(cfgPhases = Options.v().dump_cfg()).isEmpty()) {
            this.cfgDumpingPhases = cfgPhases;
        }
    }

    public static PhaseDumper v() {
        return G.v().soot_util_PhaseDumper();
    }

    private boolean isBodyDumpingPhase(String phaseName) {
        return this.bodyDumpingPhases != null && (this.bodyDumpingPhases.contains(phaseName) || this.bodyDumpingPhases.contains(ALL_WILDCARD));
    }

    private boolean isCFGDumpingPhase(String phaseName) {
        if (this.cfgDumpingPhases == null) {
            return false;
        }
        if (this.cfgDumpingPhases.contains(ALL_WILDCARD)) {
            return true;
        }
        while (true) {
            if (this.cfgDumpingPhases.contains(phaseName)) {
                return true;
            }
            int lastDot = phaseName.lastIndexOf(46);
            if (lastDot < 0) break;
            phaseName = phaseName.substring(0, lastDot);
        }
        return false;
    }

    private static File makeDirectoryIfMissing(Body b) throws IOException {
        StringBuilder buf = new StringBuilder(SourceLocator.v().getOutputDir());
        buf.append(File.separatorChar);
        buf.append(b.getMethod().getDeclaringClass().getName());
        buf.append(File.separatorChar);
        buf.append(b.getMethod().getSubSignature().replace('<', '[').replace('>', ']'));
        File dir = new File(buf.toString());
        if (dir.exists()) {
            if (!dir.isDirectory()) {
                throw new IOException(dir.getPath() + " exists but is not a directory.");
            }
        } else if (!dir.mkdirs()) {
            throw new IOException("Unable to mkdirs " + dir.getPath());
        }
        return dir;
    }

    private static PrintWriter openBodyFile(Body b, String baseName) throws IOException {
        File dir = PhaseDumper.makeDirectoryIfMissing(b);
        String filePath = dir.toString() + File.separatorChar + baseName;
        return new PrintWriter(new FileOutputStream(filePath));
    }

    private static String nextGraphFileName(Body b, String baseName) throws IOException {
        File dir = PhaseDumper.makeDirectoryIfMissing(b);
        String prefix = dir.toString() + File.separatorChar + baseName;
        File file = null;
        int fileNumber = 0;
        do {
            file = new File(prefix + fileNumber + ".dot");
            ++fileNumber;
        } while (file.exists());
        return file.toString();
    }

    private static void deleteOldGraphFiles(Body b, final String phaseName) {
        try {
            File dir = PhaseDumper.makeDirectoryIfMissing(b);
            File[] toDelete = dir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.startsWith(phaseName) && name.endsWith(".dot");
                }
            });
            if (toDelete != null) {
                for (File element : toDelete) {
                    element.delete();
                }
            }
        }
        catch (IOException e) {
            logger.debug("PhaseDumper.dumpBody() caught: " + e.toString());
            logger.error(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpBody(Body b, String baseName) {
        Printer printer = Printer.v();
        this.alreadyDumping = true;
        try (PrintWriter out = PhaseDumper.openBodyFile(b, baseName);){
            printer.setOption(1);
            printer.printTo(b, out);
        }
        catch (IOException e) {
            logger.debug("PhaseDumper.dumpBody() caught: " + e.toString());
            logger.error(e.getMessage(), e);
        }
        finally {
            this.alreadyDumping = false;
        }
    }

    private void dumpAllBodies(String baseName, boolean deleteGraphFiles) {
        for (SootClass cls : Scene.v().getClasses(3)) {
            for (SootMethod method : cls.getMethods()) {
                if (!method.hasActiveBody()) continue;
                Body body = method.getActiveBody();
                if (deleteGraphFiles) {
                    PhaseDumper.deleteOldGraphFiles(body, baseName);
                }
                this.dumpBody(body, baseName);
            }
        }
    }

    public void dumpBefore(Body b, String phaseName) {
        this.phaseStack.push(phaseName);
        if (this.isBodyDumpingPhase(phaseName)) {
            PhaseDumper.deleteOldGraphFiles(b, phaseName);
            this.dumpBody(b, phaseName + ".in");
        }
    }

    public void dumpAfter(Body b, String phaseName) {
        String poppedPhaseName = this.phaseStack.pop();
        if (poppedPhaseName != phaseName) {
            throw new IllegalArgumentException("dumpAfter(" + phaseName + ") when poppedPhaseName == " + poppedPhaseName);
        }
        if (this.isBodyDumpingPhase(phaseName)) {
            this.dumpBody(b, phaseName + ".out");
        }
    }

    public void dumpBefore(String phaseName) {
        this.phaseStack.push(phaseName);
        if (this.isBodyDumpingPhase(phaseName)) {
            this.dumpAllBodies(phaseName + ".in", true);
        }
    }

    public void dumpAfter(String phaseName) {
        String poppedPhaseName = this.phaseStack.pop();
        if (poppedPhaseName != phaseName) {
            throw new IllegalArgumentException("dumpAfter(" + phaseName + ") when poppedPhaseName == " + poppedPhaseName);
        }
        if (this.isBodyDumpingPhase(phaseName)) {
            this.dumpAllBodies(phaseName + ".out", false);
        }
    }

    public <N> void dumpGraph(DirectedGraph<N> g2, Body b) {
        this.dumpGraph(g2, b, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <N> void dumpGraph(DirectedGraph<N> g2, Body b, boolean skipPhaseCheck) {
        if (!this.alreadyDumping) {
            try {
                this.alreadyDumping = true;
                String phaseName = this.phaseStack.currentPhase();
                if (skipPhaseCheck || this.isCFGDumpingPhase(phaseName)) {
                    try {
                        String outputFile = PhaseDumper.nextGraphFileName(b, phaseName + '-' + this.getClassIdent(g2) + '-');
                        CFGToDotGraph drawer = new CFGToDotGraph();
                        drawer.drawCFG(g2, b).plot(outputFile);
                    }
                    catch (IOException e) {
                        logger.debug("PhaseDumper.dumpBody() caught: " + e.toString());
                        logger.error(e.getMessage(), e);
                    }
                }
            }
            finally {
                this.alreadyDumping = false;
            }
        }
    }

    public <N> void dumpGraph(ExceptionalGraph<N> g2) {
        this.dumpGraph(g2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <N> void dumpGraph(ExceptionalGraph<N> g2, boolean skipPhaseCheck) {
        if (!this.alreadyDumping) {
            try {
                this.alreadyDumping = true;
                String phaseName = this.phaseStack.currentPhase();
                if (skipPhaseCheck || this.isCFGDumpingPhase(phaseName)) {
                    try {
                        String outputFile = PhaseDumper.nextGraphFileName(g2.getBody(), phaseName + '-' + this.getClassIdent(g2) + '-');
                        CFGToDotGraph drawer = new CFGToDotGraph();
                        drawer.setShowExceptions(Options.v().show_exception_dests());
                        drawer.drawCFG(g2).plot(outputFile);
                    }
                    catch (IOException e) {
                        logger.debug("PhaseDumper.dumpBody() caught: " + e.toString());
                        logger.error(e.getMessage(), e);
                    }
                }
            }
            finally {
                this.alreadyDumping = false;
            }
        }
    }

    private String getClassIdent(Object obj) {
        String qualifiedName = obj.getClass().getName();
        return qualifiedName.substring(qualifiedName.lastIndexOf(46) + 1);
    }

    public void printCurrentStackTrace() {
        IOException e = new IOException("FAKE");
        logger.error(e.getMessage(), e);
    }

    private class PhaseStack
    extends ArrayList<String> {
        private static final int initialCapacity = 4;
        private static final String EMPTY_STACK_PHASE_NAME = "NOPHASE";

        PhaseStack() {
            super(4);
        }

        String currentPhase() {
            if (this.isEmpty()) {
                return EMPTY_STACK_PHASE_NAME;
            }
            return (String)this.get(this.size() - 1);
        }

        String pop() {
            return (String)this.remove(this.size() - 1);
        }

        String push(String phaseName) {
            this.add(phaseName);
            return phaseName;
        }
    }
}

