/*
 * Decompiled with CFR 0.152.
 */
package soot.util;

import java.lang.reflect.Array;
import java.util.Iterator;
import soot.util.INumberedMap;
import soot.util.Numberable;

public final class SmallNumberedMap<K extends Numberable, V>
implements INumberedMap<K, V> {
    private K[] array = SmallNumberedMap.newArray(Numberable.class, 8);
    private V[] values = SmallNumberedMap.newArray(Object.class, 8);
    private int size = 0;

    private static <T> T[] newArray(Class<? super T> componentType, int length) {
        return (Object[])Array.newInstance(componentType, length);
    }

    @Override
    public boolean put(K key, V value) {
        int pos = this.findPosition(key);
        if (this.array[pos] == key) {
            if (this.values[pos] == value) {
                return false;
            }
            this.values[pos] = value;
            return true;
        }
        ++this.size;
        if (this.size * 3 > this.array.length * 2) {
            this.doubleSize();
            pos = this.findPosition(key);
        }
        this.array[pos] = key;
        this.values[pos] = value;
        return true;
    }

    @Override
    public V get(K key) {
        return this.values[this.findPosition(key)];
    }

    @Override
    public void remove(K key) {
        int pos = this.findPosition(key);
        if (this.array[pos] == key) {
            this.array[pos] = null;
            this.values[pos] = null;
            --this.size;
        }
    }

    public int nonNullSize() {
        int ret = 0;
        for (V element : this.values) {
            if (element == null) continue;
            ++ret;
        }
        return ret;
    }

    @Override
    public Iterator<K> keyIterator() {
        return new SmallNumberedMapIterator<K>(this.array);
    }

    public Iterator<V> iterator() {
        return new SmallNumberedMapIterator<V>(this.values);
    }

    private int findPosition(K o) {
        int number = o.getNumber();
        if (number == 0) {
            throw new RuntimeException("unnumbered");
        }
        number &= this.array.length - 1;
        K key;
        while ((key = this.array[number]) != o && key != null) {
            number = number + 1 & this.array.length - 1;
        }
        return number;
    }

    private void doubleSize() {
        K[] oldArray = this.array;
        V[] oldValues = this.values;
        int oldLength = oldArray.length;
        int newLength = oldLength * 2;
        this.array = SmallNumberedMap.newArray(Numberable.class, newLength);
        this.values = SmallNumberedMap.newArray(Object.class, newLength);
        for (int i = 0; i < oldLength; ++i) {
            K element = oldArray[i];
            if (element == null) continue;
            int pos = this.findPosition(element);
            this.array[pos] = element;
            this.values[pos] = oldValues[i];
        }
    }

    private class SmallNumberedMapIterator<C>
    implements Iterator<C> {
        private final C[] data;
        private int cur;

        SmallNumberedMapIterator(C[] data) {
            this.data = data;
            this.cur = 0;
            this.seekNext();
        }

        protected final void seekNext() {
            Object[] temp = SmallNumberedMap.this.values;
            try {
                while (temp[this.cur] == null) {
                    ++this.cur;
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.cur = -1;
            }
        }

        @Override
        public final void remove() {
            ((SmallNumberedMap)SmallNumberedMap.this).array[this.cur - 1] = null;
            ((SmallNumberedMap)SmallNumberedMap.this).values[this.cur - 1] = null;
        }

        @Override
        public final boolean hasNext() {
            return this.cur != -1;
        }

        @Override
        public final C next() {
            C ret = this.data[this.cur];
            ++this.cur;
            this.seekNext();
            return ret;
        }
    }
}

