/*
 * Decompiled with CFR 0.152.
 */
package soot.util;

import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import soot.util.IterableNumberer;
import soot.util.Numberable;

public class WeakMapNumberer<T extends Numberable>
implements IterableNumberer<T> {
    final Map<T, Integer> map = new WeakHashMap<T, Integer>();
    final Map<Integer, WeakReference<T>> rmap = new WeakHashMap<Integer, WeakReference<T>>();
    int nextIndex = 1;

    @Override
    public synchronized void add(T o) {
        if (o.getNumber() != 0) {
            return;
        }
        if (!this.map.containsKey(o)) {
            Integer key = this.nextIndex;
            this.map.put(o, key);
            this.rmap.put(key, new WeakReference<T>(o));
            o.setNumber(this.nextIndex++);
        }
    }

    @Override
    public boolean remove(T o) {
        if (o == null) {
            return false;
        }
        int num = o.getNumber();
        if (num == 0) {
            return false;
        }
        o.setNumber(0);
        Integer i = this.map.remove(o);
        if (i == null) {
            return false;
        }
        this.rmap.remove(i);
        return true;
    }

    @Override
    public long get(T o) {
        if (o == null) {
            return 0L;
        }
        Integer i = this.map.get(o);
        if (i == null) {
            throw new RuntimeException("couldn't find " + o);
        }
        return i.intValue();
    }

    @Override
    public T get(long number) {
        if (number == 0L) {
            return null;
        }
        return (T)((Numberable)this.rmap.get((int)number).get());
    }

    @Override
    public int size() {
        return this.nextIndex - 1;
    }

    public boolean contains(T o) {
        return this.map.containsKey(o);
    }

    @Override
    public Iterator<T> iterator() {
        return this.map.keySet().iterator();
    }
}

