/*
 * Decompiled with CFR 0.152.
 */
package soot;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import soot.AnySubType;
import soot.ArrayType;
import soot.Modifier;
import soot.NullType;
import soot.PrimType;
import soot.RefLikeType;
import soot.RefType;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;
import soot.SootMethodRef;
import soot.Type;
import soot.jimple.spark.internal.TypeManager;
import soot.options.Options;
import soot.util.ConcurrentHashMultiMap;
import soot.util.MultiMap;
import soot.util.NumberedString;

public class FastHierarchy {
    protected static final int USE_INTERVALS_BOUNDARY = 100;
    protected Table<SootClass, NumberedString, SootMethod> typeToVtbl = HashBasedTable.create();
    protected MultiMap<SootClass, SootClass> classToSubclasses = new ConcurrentHashMultiMap<SootClass, SootClass>();
    protected MultiMap<SootClass, SootClass> interfaceToSubinterfaces = new ConcurrentHashMultiMap<SootClass, SootClass>();
    protected MultiMap<SootClass, SootClass> interfaceToImplementers = new ConcurrentHashMultiMap<SootClass, SootClass>();
    protected MultiMap<SootClass, SootClass> interfaceToAllSubinterfaces = new ConcurrentHashMultiMap<SootClass, SootClass>();
    protected MultiMap<SootClass, SootClass> interfaceToAllImplementers = new ConcurrentHashMultiMap<SootClass, SootClass>();
    protected Map<SootClass, Interval> classToInterval = new HashMap<SootClass, Interval>();
    protected final Scene sc = Scene.v();
    protected final RefType rtObject = this.sc.getObjectType();
    protected final RefType rtSerializable = RefType.v("java.io.Serializable");
    protected final RefType rtCloneable = RefType.v("java.lang.Cloneable");
    protected final RefType cilArray = RefType.v("System.Array");
    protected final RefType cilIcomparable1;
    protected final RefType cilIcomparable = RefType.v("System.IComparable");
    protected final RefType cilIconvertible;
    protected final RefType cilIequatable1;
    protected final RefType cilIformattable;

    protected int dfsVisit(int start, SootClass c) {
        Interval r = new Interval();
        r.lower = start++;
        Set<SootClass> col = this.classToSubclasses.get(c);
        if (col != null) {
            for (SootClass sc : col) {
                if (sc.isInterface()) continue;
                start = this.dfsVisit(start, sc);
            }
        }
        r.upper = start++;
        if (c.isInterface()) {
            throw new RuntimeException("Attempt to dfs visit interface " + c);
        }
        this.classToInterval.putIfAbsent(c, r);
        return start;
    }

    public FastHierarchy() {
        this.cilIcomparable1 = RefType.v("System.IComparable`1");
        this.cilIconvertible = RefType.v("System.IConvertible");
        this.cilIequatable1 = RefType.v("System.IEquatable`1");
        this.cilIformattable = RefType.v("System.IFormattable");
        this.buildInverseMaps();
        int r = this.dfsVisit(0, this.sc.getObjectType().getSootClass());
        Iterator<SootClass> phantomClassIt = this.sc.getPhantomClasses().snapshotIterator();
        while (phantomClassIt.hasNext()) {
            SootClass phantomClass = phantomClassIt.next();
            if (phantomClass.isInterface()) continue;
            r = this.dfsVisit(r, phantomClass);
        }
    }

    protected void buildInverseMaps() {
        for (SootClass cl : this.sc.getClasses().getElementsUnsorted()) {
            SootClass superClass;
            if (cl.resolvingLevel() < 1) continue;
            if (!cl.isInterface() && (superClass = cl.getSuperclassUnsafe()) != null) {
                this.classToSubclasses.put(superClass, cl);
            }
            for (SootClass supercl : cl.getInterfaces()) {
                if (cl.isInterface()) {
                    this.interfaceToSubinterfaces.put(supercl, cl);
                    continue;
                }
                this.interfaceToImplementers.put(supercl, cl);
            }
        }
    }

    public boolean isSubclass(SootClass child, SootClass parent) {
        child.checkLevel(1);
        parent.checkLevel(1);
        Interval parentInterval = this.classToInterval.get(parent);
        Interval childInterval = this.classToInterval.get(child);
        return parentInterval != null && childInterval != null && parentInterval.isSubrange(childInterval);
    }

    public Set<SootClass> getAllImplementersOfInterface(SootClass parent) {
        parent.checkLevel(1);
        Set<SootClass> result = this.interfaceToAllImplementers.get(parent);
        if (!result.isEmpty()) {
            return result;
        }
        result = new HashSet<SootClass>();
        for (SootClass subinterface : this.getAllSubinterfaces(parent)) {
            if (subinterface == parent) continue;
            result.addAll(this.getAllImplementersOfInterface(subinterface));
        }
        result.addAll(this.interfaceToImplementers.get(parent));
        this.interfaceToAllImplementers.putAll(parent, result);
        return result;
    }

    public Set<SootClass> getAllSubinterfaces(SootClass parent) {
        parent.checkLevel(1);
        if (!parent.isInterface()) {
            return Collections.emptySet();
        }
        Set<SootClass> result = this.interfaceToAllSubinterfaces.get(parent);
        if (!result.isEmpty()) {
            return result;
        }
        result = new HashSet<SootClass>();
        result.add(parent);
        for (SootClass si : this.interfaceToSubinterfaces.get(parent)) {
            result.addAll(this.getAllSubinterfaces(si));
        }
        this.interfaceToAllSubinterfaces.putAll(parent, result);
        return result;
    }

    public boolean canStoreType(Type child, Type parent) {
        if (child == parent || child.equals(parent)) {
            return true;
        }
        if (parent instanceof NullType) {
            return false;
        }
        if (child instanceof NullType) {
            return parent instanceof RefLikeType;
        }
        if (child instanceof RefType) {
            if (parent == this.rtObject) {
                return true;
            }
            if (parent instanceof RefType) {
                return this.canStoreClass(((RefType)child).getSootClass(), ((RefType)parent).getSootClass());
            }
            return false;
        }
        if (child instanceof AnySubType) {
            SootClass cl;
            if (!(parent instanceof RefLikeType)) {
                throw new RuntimeException("Unhandled type " + parent + "! Type " + child + " cannot be stored in type " + parent);
            }
            if (parent instanceof ArrayType) {
                RefType base = ((AnySubType)child).getBase();
                if (Options.v().src_prec() == 7) {
                    return base == this.cilArray;
                }
                return base == this.rtObject || base == this.rtSerializable || base == this.rtCloneable;
            }
            ArrayDeque<SootClass> worklist = new ArrayDeque<SootClass>();
            SootClass base = ((AnySubType)child).getBase().getSootClass();
            if (base.isInterface()) {
                worklist.addAll(this.getAllImplementersOfInterface(base));
            } else {
                worklist.add(base);
            }
            SootClass parentClass = ((RefType)parent).getSootClass();
            HashSet<SootClass> workset = new HashSet<SootClass>();
            while ((cl = (SootClass)worklist.poll()) != null) {
                if (!workset.add(cl)) continue;
                if (cl.isConcrete() && this.canStoreClass(cl, parentClass)) {
                    return true;
                }
                worklist.addAll(this.getSubclassesOf(cl));
            }
            return false;
        }
        if (child instanceof ArrayType) {
            if (parent instanceof RefType) {
                if (Options.v().src_prec() == 7) {
                    return parent == this.cilArray;
                }
                return parent == this.rtObject || parent == this.rtSerializable || parent == this.rtCloneable;
            }
            if (parent instanceof ArrayType) {
                ArrayType aparent = (ArrayType)parent;
                ArrayType achild = (ArrayType)child;
                if (achild.numDimensions == aparent.numDimensions) {
                    Type cBaseType = achild.baseType;
                    Type pBaseType = aparent.baseType;
                    if (cBaseType.equals(pBaseType)) {
                        return true;
                    }
                    if (cBaseType instanceof RefType && pBaseType instanceof RefType) {
                        return this.canStoreType(cBaseType, pBaseType);
                    }
                    return false;
                }
                if (achild.numDimensions > aparent.numDimensions) {
                    Type pBaseType = aparent.baseType;
                    if (Options.v().src_prec() == 7) {
                        return pBaseType == this.cilArray;
                    }
                    return pBaseType == this.rtObject || pBaseType == this.rtSerializable || pBaseType == this.rtCloneable;
                }
                return false;
            }
            return false;
        }
        if (Options.v().src_prec() == 7 && child instanceof PrimType && parent instanceof RefType) {
            return parent == this.cilIcomparable || parent == this.cilIcomparable1 || parent == this.cilIconvertible || parent == this.cilIformattable || parent == this.cilIequatable1 || parent == this.rtObject;
        }
        return false;
    }

    public boolean canStoreClass(SootClass child, SootClass parent) {
        parent.checkLevel(1);
        child.checkLevel(1);
        Interval parentInterval = this.classToInterval.get(parent);
        Interval childInterval = this.classToInterval.get(child);
        if (parentInterval != null && childInterval != null) {
            return parentInterval.isSubrange(childInterval);
        }
        if (childInterval == null) {
            if (parentInterval != null) {
                return parent == this.rtObject.getSootClass();
            }
            return this.getAllSubinterfaces(parent).contains(child);
        }
        Set<SootClass> impl = this.getAllImplementersOfInterface(parent);
        if (impl.size() > 100) {
            return this.canStoreClassClassic(child, parent);
        }
        for (SootClass c : impl) {
            Interval interval = this.classToInterval.get(c);
            if (interval == null || !interval.isSubrange(childInterval)) continue;
            return true;
        }
        return false;
    }

    protected boolean canStoreClassClassic(SootClass child, SootClass parent) {
        SootClass p;
        boolean parentIsInterface = parent.isInterface();
        ArrayDeque<SootClass> children = new ArrayDeque<SootClass>();
        children.add(child);
        while ((p = (SootClass)children.poll()) != null) {
            for (SootClass sc = p; sc != null; sc = sc.getSuperclassUnsafe()) {
                if (sc == parent) {
                    return true;
                }
                if (!parentIsInterface) continue;
                for (SootClass interf : sc.getInterfaces()) {
                    if (interf == parent) {
                        return true;
                    }
                    children.push(interf);
                }
            }
        }
        return false;
    }

    public Collection<SootMethod> resolveConcreteDispatchWithoutFailing(Collection<Type> concreteTypes, SootMethod m, RefType declaredTypeOfBase) {
        SootClass declaringClass = declaredTypeOfBase.getSootClass();
        declaringClass.checkLevel(1);
        HashSet<SootMethod> ret = new HashSet<SootMethod>();
        for (Type t : concreteTypes) {
            if (t instanceof AnySubType) {
                HashSet<SootClass> s = new HashSet<SootClass>();
                s.add(declaringClass);
                while (!s.isEmpty()) {
                    Set<SootClass> implementers;
                    Set<SootClass> subinterfaces;
                    Set<SootClass> subclasses;
                    SootMethod concreteM;
                    SootClass c = (SootClass)s.iterator().next();
                    s.remove(c);
                    if (!c.isInterface() && !c.isAbstract() && this.canStoreClass(c, declaringClass) && (concreteM = this.resolveConcreteDispatch(c, m)) != null) {
                        ret.add(concreteM);
                    }
                    if ((subclasses = this.classToSubclasses.get(c)) != null) {
                        s.addAll(subclasses);
                    }
                    if ((subinterfaces = this.interfaceToSubinterfaces.get(c)) != null) {
                        s.addAll(subinterfaces);
                    }
                    if ((implementers = this.interfaceToImplementers.get(c)) == null) continue;
                    s.addAll(implementers);
                }
                return ret;
            }
            if (t instanceof RefType) {
                SootMethod concreteM;
                SootClass concreteClass = ((RefType)t).getSootClass();
                if (!this.canStoreClass(concreteClass, declaringClass)) continue;
                try {
                    concreteM = this.resolveConcreteDispatch(concreteClass, m);
                }
                catch (Exception e) {
                    concreteM = null;
                }
                if (concreteM == null) continue;
                ret.add(concreteM);
                continue;
            }
            if (t instanceof ArrayType) {
                SootMethod concreteM;
                try {
                    concreteM = this.resolveConcreteDispatch(this.sc.getObjectType().getSootClass(), m);
                }
                catch (Exception e) {
                    concreteM = null;
                }
                if (concreteM == null) continue;
                ret.add(concreteM);
                continue;
            }
            throw new RuntimeException("Unrecognized reaching type " + t);
        }
        return ret;
    }

    public Collection<SootMethod> resolveConcreteDispatch(Collection<Type> concreteTypes, SootMethod m, RefType declaredTypeOfBase) {
        SootClass declaringClass = declaredTypeOfBase.getSootClass();
        declaringClass.checkLevel(1);
        HashSet<SootMethod> ret = new HashSet<SootMethod>();
        for (Type t : concreteTypes) {
            if (t instanceof AnySubType) {
                HashSet<SootClass> s = new HashSet<SootClass>();
                s.add(declaringClass);
                while (!s.isEmpty()) {
                    Set<SootClass> implementers;
                    Set<SootClass> subinterfaces;
                    Set<SootClass> subclasses;
                    SootMethod concreteM;
                    SootClass c = (SootClass)s.iterator().next();
                    s.remove(c);
                    if (!c.isInterface() && !c.isAbstract() && this.canStoreClass(c, declaringClass) && (concreteM = this.resolveConcreteDispatch(c, m)) != null) {
                        ret.add(concreteM);
                    }
                    if ((subclasses = this.classToSubclasses.get(c)) != null) {
                        s.addAll(subclasses);
                    }
                    if ((subinterfaces = this.interfaceToSubinterfaces.get(c)) != null) {
                        s.addAll(subinterfaces);
                    }
                    if ((implementers = this.interfaceToImplementers.get(c)) == null) continue;
                    s.addAll(implementers);
                }
                return ret;
            }
            if (t instanceof RefType) {
                SootMethod concreteM;
                SootClass concreteClass = ((RefType)t).getSootClass();
                if (!this.canStoreClass(concreteClass, declaringClass) || (concreteM = this.resolveConcreteDispatch(concreteClass, m)) == null) continue;
                ret.add(concreteM);
                continue;
            }
            if (t instanceof ArrayType) {
                SootMethod concreteM = this.resolveConcreteDispatch(this.rtObject.getSootClass(), m);
                if (concreteM == null) continue;
                ret.add(concreteM);
                continue;
            }
            throw new RuntimeException("Unrecognized reaching type " + t);
        }
        return ret;
    }

    private boolean isVisible(SootClass from, SootClass declaringClass, int modifier) {
        from.checkLevel(1);
        if (Modifier.isPublic(modifier)) {
            return true;
        }
        SootClass curDecl = declaringClass;
        while (curDecl.hasOuterClass()) {
            if (from.equals(curDecl = curDecl.getOuterClass())) {
                return true;
            }
            SootClass curFrom = from;
            while (curFrom.hasOuterClass()) {
                if (!curDecl.equals(curFrom = curFrom.getOuterClass())) continue;
                return true;
            }
        }
        if (Modifier.isPrivate(modifier)) {
            return from.equals(declaringClass);
        }
        if (Modifier.isProtected(modifier)) {
            return this.canStoreClass(from, declaringClass);
        }
        return from.getJavaPackageName().equals(declaringClass.getJavaPackageName());
    }

    public Set<SootMethod> resolveAbstractDispatch(SootClass baseType, SootMethod m) {
        return this.resolveAbstractDispatch(baseType, m.makeRef());
    }

    public Set<SootMethod> resolveAbstractDispatch(SootClass baseType, SootMethodRef m) {
        SootClass concreteType;
        HashSet<SootClass> resolved = new HashSet<SootClass>();
        HashSet<SootMethod> ret = new HashSet<SootMethod>();
        ArrayDeque<SootClass> worklist = new ArrayDeque<SootClass>();
        worklist.add(baseType);
        while ((concreteType = (SootClass)worklist.poll()) != null) {
            SootMethod resolvedMethod;
            if (resolved.contains(concreteType) && this.classToSubclasses.get(concreteType).isEmpty()) continue;
            if (concreteType.isInterface()) {
                worklist.addAll(this.getAllImplementersOfInterface(concreteType));
                continue;
            }
            Set<SootClass> c = this.classToSubclasses.get(concreteType);
            if (c != null) {
                worklist.addAll(c);
            }
            if (resolved.contains(concreteType) || (resolvedMethod = this.resolveMethod(concreteType, m, false, resolved)) == null) continue;
            ret.add(resolvedMethod);
        }
        return ret;
    }

    public SootMethod resolveConcreteDispatch(SootClass baseType, SootMethod m) {
        return this.resolveConcreteDispatch(baseType, m.makeRef());
    }

    public SootMethod resolveConcreteDispatch(SootClass baseType, SootMethodRef m) {
        baseType.checkLevel(1);
        if (baseType.isInterface()) {
            throw new RuntimeException("A concrete type cannot be an interface: " + baseType);
        }
        return this.resolveMethod(baseType, m, false);
    }

    public SootMethod resolveMethod(SootClass baseType, SootMethod m, boolean allowAbstract) {
        return this.resolveMethod(baseType, m.makeRef(), allowAbstract);
    }

    public SootMethod resolveMethod(SootClass baseType, SootMethodRef m, boolean allowAbstract) {
        return this.resolveMethod(baseType, m, allowAbstract, new HashSet<SootClass>());
    }

    private SootMethod resolveMethod(SootClass baseType, SootMethodRef m, boolean allowAbstract, Set<SootClass> ignoreList) {
        return this.resolveMethod(baseType, m.getDeclaringClass(), m.getName(), m.getParameterTypes(), m.getReturnType(), allowAbstract, ignoreList, m.getSubSignature());
    }

    public SootMethod resolveMethod(SootClass baseType, SootClass declaringClass, String name, List<Type> parameterTypes, Type returnType, boolean allowAbstract) {
        return this.resolveMethod(baseType, declaringClass, name, parameterTypes, returnType, allowAbstract, new HashSet<SootClass>(), null);
    }

    public SootMethod resolveMethod(SootClass baseType, SootClass declaringClass, String name, List<Type> parameterTypes, Type returnType, boolean allowAbstract, NumberedString subsignature) {
        return this.resolveMethod(baseType, declaringClass, name, parameterTypes, returnType, allowAbstract, new HashSet<SootClass>(), subsignature);
    }

    private SootMethod resolveMethod(SootClass baseType, SootClass declaringClass, String name, List<Type> parameterTypes, Type returnType, boolean allowAbstract, Set<SootClass> ignoreList, NumberedString subsignature) {
        NumberedString methodSignature = subsignature == null ? Scene.v().getSubSigNumberer().findOrAdd(SootMethod.getSubSignature(name, parameterTypes, returnType)) : subsignature;
        SootMethod resolvedMethod = (SootMethod)this.typeToVtbl.get((Object)baseType, (Object)methodSignature);
        if (resolvedMethod != null) {
            return resolvedMethod;
        }
        SootMethod candidate = null;
        for (SootClass concreteType = baseType; concreteType != null && ignoreList.add(concreteType); concreteType = concreteType.getSuperclassUnsafe()) {
            candidate = this.getSignaturePolymorphicMethod(concreteType, name, parameterTypes, returnType);
            if (candidate == null || !this.isVisible(declaringClass, concreteType, candidate.getModifiers())) continue;
            if (!allowAbstract && candidate.isAbstract()) {
                candidate = null;
                break;
            }
            if (!candidate.isAbstract()) {
                this.typeToVtbl.put((Object)baseType, (Object)methodSignature, (Object)candidate);
            }
            return candidate;
        }
        if (this.isHandleDefaultMethods()) {
            HashSet<SootClass> interfaceIgnoreList = new HashSet<SootClass>();
            for (SootClass concreteType = baseType; concreteType != null; concreteType = concreteType.getSuperclassUnsafe()) {
                LinkedList<SootClass> worklist = new LinkedList<SootClass>(concreteType.getInterfaces());
                while (!worklist.isEmpty()) {
                    SootClass iFace = (SootClass)worklist.poll();
                    if (interfaceIgnoreList.contains(iFace)) continue;
                    interfaceIgnoreList.add(iFace);
                    SootMethod method = this.getSignaturePolymorphicMethod(iFace, name, parameterTypes, returnType);
                    if (method != null && this.isVisible(declaringClass, iFace, method.getModifiers())) {
                        if (!allowAbstract && method.isAbstract() || candidate != null && !this.canStoreClass(method.getDeclaringClass(), candidate.getDeclaringClass())) continue;
                        candidate = method;
                        continue;
                    }
                    worklist.addAll(iFace.getInterfaces());
                }
            }
            ignoreList.addAll(interfaceIgnoreList);
        }
        if (candidate != null) {
            this.typeToVtbl.put((Object)baseType, (Object)methodSignature, (Object)candidate);
        }
        return candidate;
    }

    private boolean isHandleDefaultMethods() {
        int version = Options.v().java_version();
        return version == 0 || version > 7;
    }

    public SootMethod resolveSpecialDispatch(SootMethod callee, SootMethod container2) {
        SootClass containerClass = container2.getDeclaringClass();
        SootClass calleeClass = callee.getDeclaringClass();
        if (containerClass.getType() != calleeClass.getType() && this.canStoreType(containerClass.getType(), calleeClass.getType()) && !"<init>".equals(callee.getName()) && !"<clinit>".equals(callee.getName()) && !calleeClass.isInterface()) {
            return this.resolveConcreteDispatch(containerClass, callee);
        }
        return callee;
    }

    private SootMethod getSignaturePolymorphicMethod(SootClass concreteType, String name, List<Type> parameterTypes, Type returnType) {
        if (concreteType == null) {
            throw new RuntimeException("The concreteType cannot not be null!");
        }
        SootMethod candidate = null;
        for (SootMethod method : concreteType.getMethods()) {
            if (method.getName().equals(name) && method.getParameterTypes().equals(parameterTypes) && this.canStoreType(method.getReturnType(), returnType)) {
                candidate = method;
                returnType = method.getReturnType();
            }
            if (Options.v().src_prec() != 7 || !method.getName().equals(name) || method.getParameterCount() != parameterTypes.size() || !this.canStoreType(returnType, method.getReturnType())) continue;
            boolean canStore = true;
            for (int i = 0; i < method.getParameterCount(); ++i) {
                Type calleeParameter;
                Type methodParameter = method.getParameterType(i);
                if (methodParameter.equals(calleeParameter = parameterTypes.get(i)) || this.canStoreType(calleeParameter, methodParameter)) continue;
                canStore = false;
            }
            if (!canStore) continue;
            candidate = method;
            returnType = method.getReturnType();
        }
        return candidate;
    }

    public Collection<SootClass> getSubclassesOf(SootClass c) {
        c.checkLevel(1);
        Set<SootClass> ret = this.classToSubclasses.get(c);
        return ret == null ? Collections.emptySet() : ret;
    }

    public Iterable<Type> canStoreTypeList(final Type nt) {
        return new Iterable<Type>(){

            @Override
            public Iterator<Type> iterator() {
                final Iterator<Type> it = Scene.v().getTypeNumberer().iterator();
                return new Iterator<Type>(){
                    Type crt = null;

                    @Override
                    public boolean hasNext() {
                        if (this.crt != null) {
                            return true;
                        }
                        Type c = null;
                        while (it.hasNext()) {
                            c = (Type)it.next();
                            if (TypeManager.isUnresolved(c) || !FastHierarchy.this.canStoreType(nt, c)) continue;
                            this.crt = c;
                            return true;
                        }
                        return false;
                    }

                    @Override
                    public Type next() {
                        Type old = this.crt;
                        this.crt = null;
                        this.hasNext();
                        return old;
                    }
                };
            }
        };
    }

    protected class Interval {
        int lower;
        int upper;

        public Interval() {
        }

        public Interval(int lower, int upper) {
            this.lower = lower;
            this.upper = upper;
        }

        public boolean isSubrange(Interval potentialSubrange) {
            return potentialSubrange == this || potentialSubrange != null && this.lower <= potentialSubrange.lower && this.upper >= potentialSubrange.upper;
        }
    }
}

