/*
 * Decompiled with CFR 0.152.
 */
package soot;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.IFoundFile;
import soot.SourceLocator;
import soot.util.SharedCloseable;

public class FoundFile
implements IFoundFile {
    private static final Logger logger = LoggerFactory.getLogger(FoundFile.class);
    protected final List<InputStream> openedInputStreams = new ArrayList<InputStream>();
    protected Path path;
    protected File file;
    protected String entryName;
    protected SharedCloseable<ZipFile> zipFile;
    protected ZipEntry zipEntry;

    public FoundFile(String archivePath, String entryName) {
        if (archivePath == null || entryName == null) {
            throw new IllegalArgumentException("Error: The archive path and entry name cannot be null.");
        }
        this.file = new File(archivePath);
        this.entryName = entryName;
    }

    public FoundFile(File file) {
        if (file == null) {
            throw new IllegalArgumentException("Error: The file cannot be null.");
        }
        this.file = file;
        this.entryName = null;
    }

    public FoundFile(Path path) {
        this.path = path;
    }

    @Override
    public String getFilePath() {
        if (this.file == null) {
            File f;
            if (this.path != null && (f = this.path.toFile()) != null) {
                return f.getPath();
            }
            return null;
        }
        return this.file.getPath();
    }

    @Override
    public boolean isZipFile() {
        return this.entryName != null;
    }

    @Override
    public ZipFile getZipFile() {
        return this.zipFile != null ? this.zipFile.get() : null;
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public String getAbsolutePath() {
        try {
            return this.file != null ? this.file.getCanonicalPath() : this.path.toRealPath(new LinkOption[0]).toString();
        }
        catch (IOException ex) {
            return this.file != null ? this.file.getAbsolutePath() : this.path.toAbsolutePath().toString();
        }
    }

    @Override
    public InputStream inputStream() {
        InputStream ret = null;
        if (this.path != null) {
            try {
                ret = Files.newInputStream(this.path, new OpenOption[0]);
            }
            catch (IOException e) {
                throw new RuntimeException("Error: Failed to open a InputStream for the file at path '" + this.path.toAbsolutePath().toString() + "'.", e);
            }
        }
        if (!this.isZipFile()) {
            try {
                ret = new FileInputStream(this.file);
            }
            catch (Exception e) {
                throw new RuntimeException("Error: Failed to open a InputStream for the file at path '" + this.file.getPath() + "'.", e);
            }
        }
        if (this.zipFile == null) {
            try {
                this.zipFile = SourceLocator.v().archivePathToZip.getRef(this.file.getPath());
                this.zipEntry = this.zipFile.get().getEntry(this.entryName);
                if (this.zipEntry == null) {
                    this.silentClose();
                    throw new RuntimeException("Error: Failed to find entry '" + this.entryName + "' in the archive file at path '" + this.file.getPath() + "'.");
                }
            }
            catch (Exception e) {
                this.silentClose();
                throw new RuntimeException("Error: Failed to open the archive file at path '" + this.file.getPath() + "' for entry '" + this.entryName + "'.", e);
            }
        }
        try (InputStream stream = this.zipFile.get().getInputStream(this.zipEntry);){
            ret = FoundFile.doJDKBugWorkaround(stream, this.zipEntry.getSize());
        }
        catch (Exception e) {
            throw new RuntimeException("Error: Failed to open a InputStream for the entry '" + this.zipEntry.getName() + "' of the archive at path '" + this.zipFile.get().getName() + "'.", e);
        }
        ret = new BufferedInputStream(ret);
        this.openedInputStreams.add(ret);
        return ret;
    }

    @Override
    public void close() {
        ArrayList<Exception> errs = new ArrayList<Exception>(0);
        for (InputStream is : this.openedInputStreams) {
            try {
                is.close();
            }
            catch (Exception e) {
                errs.add(e);
            }
        }
        this.openedInputStreams.clear();
        this.closeZipFile(errs);
        if (!errs.isEmpty()) {
            String msg = null;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try (PrintStream ps = new PrintStream((OutputStream)baos, true, "utf-8");){
                ps.println("Error: Failed to close all opened resources. The following exceptions were thrown in the process: ");
                int i = 0;
                for (Throwable throwable : errs) {
                    ps.print("Exception ");
                    ps.print(i++);
                    ps.print(": ");
                    logger.error(throwable.getMessage(), throwable);
                }
                msg = new String(baos.toByteArray(), StandardCharsets.UTF_8);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new RuntimeException(msg);
        }
    }

    protected void closeZipFile(List<Exception> errs) {
        if (this.zipFile != null) {
            try {
                this.zipFile.close();
                errs.clear();
            }
            catch (Exception e) {
                errs.add(e);
            }
            this.zipFile = null;
            this.zipEntry = null;
        }
    }

    private static InputStream doJDKBugWorkaround(InputStream is, long size) throws IOException {
        int sz;
        byte[] buf = new byte[sz];
        int N = 1024;
        int ln = 0;
        int count = 0;
        for (sz = (int)size; sz > 0 && (ln = is.read(buf, count, Math.min(1024, sz))) != -1; sz -= ln) {
            count += ln;
        }
        return new ByteArrayInputStream(buf);
    }
}

