/*
 * Decompiled with CFR 0.152.
 */
package soot.JastAddJ;

import soot.JastAddJ.ASTNode;
import soot.JastAddJ.ASTNode$State;
import soot.JastAddJ.Binary;
import soot.JastAddJ.Expr;
import soot.JastAddJ.TypeDecl;

public abstract class BitwiseExpr
extends Binary
implements Cloneable {
    protected boolean type_computed = false;
    protected TypeDecl type_value;

    @Override
    public void flushCache() {
        super.flushCache();
        this.type_computed = false;
        this.type_value = null;
    }

    @Override
    public void flushCollectionCache() {
        super.flushCollectionCache();
    }

    @Override
    public BitwiseExpr clone() throws CloneNotSupportedException {
        BitwiseExpr node = (BitwiseExpr)super.clone();
        node.type_computed = false;
        node.type_value = null;
        node.in$Circle(false);
        node.is$Final(false);
        return node;
    }

    @Override
    public void typeCheck() {
        TypeDecl left = this.getLeftOperand().type();
        TypeDecl right = this.getRightOperand().type();
        if (left.isIntegralType() && right.isIntegralType()) {
            return;
        }
        if (left.isBoolean() && right.isBoolean()) {
            return;
        }
        this.error(left.typeName() + " is not compatible with " + right.typeName());
    }

    public BitwiseExpr() {
    }

    @Override
    public void init$Children() {
        this.children = new ASTNode[2];
    }

    public BitwiseExpr(Expr p0, Expr p1) {
        this.setChild(p0, 0);
        this.setChild(p1, 1);
    }

    @Override
    protected int numChildren() {
        return 2;
    }

    @Override
    public boolean mayHaveRewrite() {
        return false;
    }

    @Override
    public void setLeftOperand(Expr node) {
        this.setChild(node, 0);
    }

    @Override
    public Expr getLeftOperand() {
        return (Expr)this.getChild(0);
    }

    @Override
    public Expr getLeftOperandNoTransform() {
        return (Expr)this.getChildNoTransform(0);
    }

    @Override
    public void setRightOperand(Expr node) {
        this.setChild(node, 1);
    }

    @Override
    public Expr getRightOperand() {
        return (Expr)this.getChild(1);
    }

    @Override
    public Expr getRightOperandNoTransform() {
        return (Expr)this.getChildNoTransform(1);
    }

    @Override
    public TypeDecl type() {
        if (this.type_computed) {
            return this.type_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.type_value = this.type_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.type_computed = true;
        }
        return this.type_value;
    }

    private TypeDecl type_compute() {
        if (this.getLeftOperand().type().isIntegralType() && this.getRightOperand().type().isIntegralType()) {
            return this.getLeftOperand().type().binaryNumericPromotion(this.getRightOperand().type());
        }
        if (this.getLeftOperand().type().isBoolean() && this.getRightOperand().type().isBoolean()) {
            return this.typeBoolean();
        }
        return this.unknownType();
    }

    @Override
    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }
}

