/*
 * Decompiled with CFR 0.152.
 */
package soot;

import soot.ClassProvider;
import soot.ClassSource;
import soot.IFoundFile;
import soot.JavaClassSource;
import soot.SourceLocator;
import soot.javaToJimple.InitialResolver;
import soot.options.Options;

public class JavaClassProvider
implements ClassProvider {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClassSource find(String className) {
        if (Options.v().polyglot() && InitialResolver.v().hasASTForSootName(className)) {
            InitialResolver.v().setASTForSootName(className);
            return new JavaClassSource(className);
        }
        boolean checkAgain = className.indexOf(36) >= 0;
        try (IFoundFile file = null;){
            SourceLocator loc = SourceLocator.v();
            String javaClassName = loc.getSourceForClass(className);
            file = loc.lookupInClassPath(javaClassName.replace('.', '/') + ".java");
            if (file == null && checkAgain) {
                file = loc.lookupInClassPath(className.replace('.', '/') + ".java");
            }
            if (file == null) {
                ClassSource classSource = null;
                return classSource;
            }
            if (file.isZipFile()) {
                throw new JarException(className);
            }
            JavaClassSource javaClassSource = new JavaClassSource(className, file.getFile());
            return javaClassSource;
        }
    }

    public static class JarException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public JarException(String className) {
            super("Class " + className + " was found in an archive, but Soot doesn't support reading source files out of an archive");
        }
    }
}

