/*
 * Decompiled with CFR 0.152.
 */
package soot;

import com.google.common.base.Optional;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.G;
import soot.ModuleScene;
import soot.Singletons;
import soot.SootClass;
import soot.SootModuleInfo;
import soot.SootModuleResolver;
import soot.options.Options;

public class ModuleUtil {
    private static final Logger logger = LoggerFactory.getLogger(ModuleUtil.class);
    private static final List<String> packagesJavaBaseModule = ModuleUtil.parseJavaBasePackage();
    private static final String JAVABASEFILE = "javabase.txt";
    private final Cache<String, String> modulePackageCache = CacheBuilder.newBuilder().initialCapacity(60).maximumSize(800L).concurrencyLevel(Runtime.getRuntime().availableProcessors()).build();
    private final LoadingCache<String, ModuleClassNameWrapper> wrapperCache = CacheBuilder.newBuilder().initialCapacity(100).maximumSize(1000L).concurrencyLevel(Runtime.getRuntime().availableProcessors()).build((CacheLoader)new CacheLoader<String, ModuleClassNameWrapper>(){

        public ModuleClassNameWrapper load(String key) throws Exception {
            return new ModuleClassNameWrapper(key);
        }
    });

    public ModuleUtil(Singletons.Global g) {
    }

    public static ModuleUtil v() {
        return G.v().soot_ModuleUtil();
    }

    public final ModuleClassNameWrapper makeWrapper(String className) {
        try {
            return (ModuleClassNameWrapper)this.wrapperCache.get((Object)className);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean module_mode() {
        return !Options.v().soot_modulepath().isEmpty();
    }

    public final String declaringModule(String className, String toModuleName) {
        SootClass temp;
        if ("module-info".equalsIgnoreCase(className)) {
            return toModuleName;
        }
        ModuleScene modSc = ModuleScene.v();
        SootModuleInfo modInfo = modSc.containsClass("module-info", (Optional<String>)Optional.fromNullable((Object)toModuleName)) ? ((temp = modSc.getSootClass("module-info", (Optional<String>)Optional.fromNullable((Object)toModuleName))).resolvingLevel() < 3 ? (SootModuleInfo)SootModuleResolver.v().resolveClass("module-info", 3, (Optional<String>)Optional.fromNullable((Object)toModuleName)) : (SootModuleInfo)temp) : (SootModuleInfo)SootModuleResolver.v().resolveClass("module-info", 3, (Optional<String>)Optional.fromNullable((Object)toModuleName));
        if (modInfo == null) {
            return null;
        }
        String packageName = ModuleUtil.getPackageName(className);
        String chacheKey = modInfo.getModuleName() + '/' + packageName;
        String moduleName = (String)this.modulePackageCache.getIfPresent((Object)chacheKey);
        if (moduleName != null) {
            return moduleName;
        }
        if (modInfo.exportsPackage(packageName, toModuleName)) {
            return modInfo.getModuleName();
        }
        if (modInfo.isAutomaticModule() && modSc.containsClass(className)) {
            String foundModuleName = modSc.getSootClass(className).getModuleInformation().getModuleName();
            this.modulePackageCache.put((Object)chacheKey, (Object)foundModuleName);
            return foundModuleName;
        }
        for (SootModuleInfo modInf : modInfo.retrieveRequiredModules().keySet()) {
            if (modInf.exportsPackage(packageName, toModuleName)) {
                this.modulePackageCache.put((Object)chacheKey, (Object)modInf.getModuleName());
                return modInf.getModuleName();
            }
            String tModuleName = this.checkTransitiveChain(modInf, packageName, toModuleName, new HashSet<String>());
            if (tModuleName == null) continue;
            this.modulePackageCache.put((Object)chacheKey, (Object)tModuleName);
            return tModuleName;
        }
        return toModuleName;
    }

    private String checkTransitiveChain(SootModuleInfo modInfo, String packageName, String toModuleName, Set<String> hasCheckedModule) {
        for (Map.Entry<SootModuleInfo, Integer> entry : modInfo.retrieveRequiredModules().entrySet()) {
            SootModuleInfo key;
            String moduleName;
            if ((entry.getValue() & 0x20) == 0 || hasCheckedModule.contains(moduleName = (key = entry.getKey()).getModuleName())) continue;
            hasCheckedModule.add(moduleName);
            if (key.exportsPackage(packageName, toModuleName)) {
                return moduleName;
            }
            return this.checkTransitiveChain(key, packageName, toModuleName, hasCheckedModule);
        }
        return null;
    }

    private static String getPackageName(String className) {
        int index = className.lastIndexOf(46);
        return index > 0 ? className.substring(0, index) : "";
    }

    private static List<String> parseJavaBasePackage() {
        ArrayList<String> packages = new ArrayList<String>();
        Path excludeFile = Paths.get(JAVABASEFILE, new String[0]);
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(Files.exists(excludeFile, new LinkOption[0]) ? Files.newInputStream(excludeFile, new OpenOption[0]) : ModuleUtil.class.getResourceAsStream("/javabase.txt")));){
            String line;
            while ((line = reader.readLine()) != null) {
                packages.add(line);
            }
        }
        catch (IOException x) {
            logger.warn("Cannot open file specifying the packages of module 'java.base'", (Throwable)x);
        }
        return packages;
    }

    public static final class ModuleClassNameWrapper {
        private static final String fullQualifiedName = "([a-zA-Z_$][a-zA-Z\\d_$]*\\.)+[a-zA-Z_$][a-zA-Z\\d_$]*";
        private static final Pattern fqnClassNamePattern = Pattern.compile("([a-zA-Z_$][a-zA-Z\\d_$]*\\.)+[a-zA-Z_$][a-zA-Z\\d_$]*");
        private static final String qualifiedModuleName = "([a-zA-Z_$])([a-zA-Z\\d_$\\.]*)+";
        private static final Pattern qualifiedModuleNamePattern = Pattern.compile("([a-zA-Z_$])([a-zA-Z\\d_$\\.]*)+");
        private final String className;
        private final String moduleName;

        private ModuleClassNameWrapper(String className) {
            if ("soot.dummy.InvokeDynamic".equals(className)) {
                this.className = className;
                this.moduleName = null;
                return;
            }
            String refinedClassName = className;
            String refinedModuleName = null;
            if (className.contains(":")) {
                String[] split = className.split(":");
                if (split.length == 2 && qualifiedModuleNamePattern.matcher(split[0]).matches() && fqnClassNamePattern.matcher(split[1]).matches()) {
                    refinedModuleName = split[0];
                    refinedClassName = split[1];
                }
            } else if (fqnClassNamePattern.matcher(className).matches() && packagesJavaBaseModule.contains(ModuleUtil.getPackageName(className))) {
                refinedModuleName = "java.base";
            }
            this.className = refinedClassName;
            this.moduleName = refinedModuleName;
            ModuleUtil.v().wrapperCache.put((Object)className, (Object)this);
        }

        public String getClassName() {
            return this.className;
        }

        public String getModuleName() {
            return this.moduleName;
        }

        public Optional<String> getModuleNameOptional() {
            return Optional.fromNullable((Object)this.moduleName);
        }
    }
}

