/*
 * Decompiled with CFR 0.152.
 */
package soot;

import java.util.List;
import soot.SootClass;
import soot.SootMethod;
import soot.SootMethodRefImpl;
import soot.Type;
import soot.tagkit.AnnotationTag;
import soot.tagkit.Tag;
import soot.tagkit.VisibilityAnnotationTag;

public class PolymorphicMethodRef
extends SootMethodRefImpl {
    public static final String METHODHANDLE_SIGNATURE = "java.lang.invoke.MethodHandle";
    public static final String VARHANDLE_SIGNATURE = "java.lang.invoke.VarHandle";
    public static final String POLYMORPHIC_SIGNATURE = "java/lang/invoke/MethodHandle$PolymorphicSignature";

    public static boolean handlesClass(SootClass declaringClass) {
        return PolymorphicMethodRef.handlesClass(declaringClass.getName());
    }

    public static boolean handlesClass(String declaringClassName) {
        return METHODHANDLE_SIGNATURE.equals(declaringClassName) || VARHANDLE_SIGNATURE.equals(declaringClassName);
    }

    public PolymorphicMethodRef(SootClass declaringClass, String name, List<Type> parameterTypes, Type returnType, boolean isStatic) {
        super(declaringClass, name, parameterTypes, returnType, isStatic);
    }

    @Override
    public SootMethod resolve() {
        SootMethod method = this.getDeclaringClass().getMethodUnsafe(this.getName(), this.getParameterTypes(), this.getReturnType());
        if (method != null) {
            return method;
        }
        for (SootMethod candidateMethod : this.getDeclaringClass().getMethods()) {
            Tag annotationsTag;
            if (!candidateMethod.getName().equals(this.getName()) || (annotationsTag = candidateMethod.getTag("VisibilityAnnotationTag")) == null) continue;
            for (AnnotationTag annotation2 : ((VisibilityAnnotationTag)annotationsTag).getAnnotations()) {
                if (!"Ljava/lang/invoke/MethodHandle$PolymorphicSignature;".equals(annotation2.getType())) continue;
                return this.addPolyMorphicMethod(candidateMethod);
            }
        }
        return super.resolve();
    }

    private SootMethod addPolyMorphicMethod(SootMethod originalPolyMorphicMethod) {
        SootMethod newMethod = new SootMethod(this.getName(), this.getParameterTypes(), this.getReturnType(), originalPolyMorphicMethod.modifiers);
        this.getDeclaringClass().addMethod(newMethod);
        return newMethod;
    }
}

