/*
 * Decompiled with CFR 0.152.
 */
package soot.dexpler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jf.dexlib2.AnnotationVisibility;
import org.jf.dexlib2.iface.Annotation;
import org.jf.dexlib2.iface.AnnotationElement;
import org.jf.dexlib2.iface.ClassDef;
import org.jf.dexlib2.iface.Field;
import org.jf.dexlib2.iface.Method;
import org.jf.dexlib2.iface.MethodParameter;
import org.jf.dexlib2.iface.reference.FieldReference;
import org.jf.dexlib2.iface.reference.MethodReference;
import org.jf.dexlib2.iface.value.AnnotationEncodedValue;
import org.jf.dexlib2.iface.value.ArrayEncodedValue;
import org.jf.dexlib2.iface.value.BooleanEncodedValue;
import org.jf.dexlib2.iface.value.ByteEncodedValue;
import org.jf.dexlib2.iface.value.CharEncodedValue;
import org.jf.dexlib2.iface.value.DoubleEncodedValue;
import org.jf.dexlib2.iface.value.EncodedValue;
import org.jf.dexlib2.iface.value.EnumEncodedValue;
import org.jf.dexlib2.iface.value.FieldEncodedValue;
import org.jf.dexlib2.iface.value.FloatEncodedValue;
import org.jf.dexlib2.iface.value.IntEncodedValue;
import org.jf.dexlib2.iface.value.LongEncodedValue;
import org.jf.dexlib2.iface.value.MethodEncodedValue;
import org.jf.dexlib2.iface.value.ShortEncodedValue;
import org.jf.dexlib2.iface.value.StringEncodedValue;
import org.jf.dexlib2.iface.value.TypeEncodedValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.ArrayType;
import soot.RefType;
import soot.SootClass;
import soot.SootMethod;
import soot.SootResolver;
import soot.Type;
import soot.dexpler.DexType;
import soot.dexpler.Util;
import soot.javaToJimple.IInitialResolver;
import soot.tagkit.AnnotationAnnotationElem;
import soot.tagkit.AnnotationArrayElem;
import soot.tagkit.AnnotationBooleanElem;
import soot.tagkit.AnnotationClassElem;
import soot.tagkit.AnnotationDefaultTag;
import soot.tagkit.AnnotationDoubleElem;
import soot.tagkit.AnnotationElem;
import soot.tagkit.AnnotationEnumElem;
import soot.tagkit.AnnotationFloatElem;
import soot.tagkit.AnnotationIntElem;
import soot.tagkit.AnnotationLongElem;
import soot.tagkit.AnnotationStringElem;
import soot.tagkit.AnnotationTag;
import soot.tagkit.DeprecatedTag;
import soot.tagkit.EnclosingMethodTag;
import soot.tagkit.Host;
import soot.tagkit.InnerClassAttribute;
import soot.tagkit.InnerClassTag;
import soot.tagkit.ParamNamesTag;
import soot.tagkit.SignatureTag;
import soot.tagkit.Tag;
import soot.tagkit.VisibilityAnnotationTag;
import soot.tagkit.VisibilityParameterAnnotationTag;
import soot.toDex.SootToDexUtils;

public class DexAnnotation {
    private static final Logger logger = LoggerFactory.getLogger(DexAnnotation.class);
    public static final String JAVA_DEPRECATED = "java.lang.Deprecated";
    public static final String DALVIK_ANNOTATION_THROWS = "dalvik.annotation.Throws";
    public static final String DALVIK_ANNOTATION_SIGNATURE = "dalvik.annotation.Signature";
    public static final String DALVIK_ANNOTATION_MEMBERCLASSES = "dalvik.annotation.MemberClasses";
    public static final String DALVIK_ANNOTATION_INNERCLASS = "dalvik.annotation.InnerClass";
    public static final String DALVIK_ANNOTATION_ENCLOSINGMETHOD = "dalvik.annotation.EnclosingMethod";
    public static final String DALVIK_ANNOTATION_ENCLOSINGCLASS = "dalvik.annotation.EnclosingClass";
    public static final String DALVIK_ANNOTATION_DEFAULT = "dalvik.annotation.AnnotationDefault";
    private final Type ARRAY_TYPE = RefType.v("Array");
    private final SootClass clazz;
    private final IInitialResolver.Dependencies deps;

    public DexAnnotation(SootClass clazz, IInitialResolver.Dependencies deps) {
        this.clazz = clazz;
        this.deps = deps;
    }

    public void handleClassAnnotation(ClassDef classDef) {
        Set aSet = classDef.getAnnotations();
        if (aSet == null || aSet.isEmpty()) {
            return;
        }
        List<Tag> tags = this.handleAnnotation(aSet, classDef.getType());
        if (tags == null) {
            return;
        }
        InnerClassAttribute ica = null;
        for (Tag t : tags) {
            if (t == null) continue;
            if (t instanceof InnerClassTag) {
                if (ica == null && (ica = (InnerClassAttribute)this.clazz.getTag("InnerClassAttribute")) == null) {
                    ica = new InnerClassAttribute();
                    this.clazz.addTag(ica);
                }
                ica.add((InnerClassTag)t);
                continue;
            }
            if (t instanceof VisibilityAnnotationTag) {
                VisibilityAnnotationTag vt = (VisibilityAnnotationTag)t;
                for (AnnotationTag a : vt.getAnnotations()) {
                    if (!a.getType().equals("Ldalvik/annotation/AnnotationDefault;")) continue;
                    for (AnnotationElem ae : a.getElems()) {
                        if (!(ae instanceof AnnotationAnnotationElem)) continue;
                        AnnotationAnnotationElem aae = (AnnotationAnnotationElem)ae;
                        AnnotationTag at = aae.getValue();
                        HashMap<String, AnnotationElem> defaults = new HashMap<String, AnnotationElem>();
                        for (AnnotationElem annotationElem : at.getElems()) {
                            defaults.put(annotationElem.getName(), annotationElem);
                        }
                        for (SootMethod sootMethod : this.clazz.getMethods()) {
                            String methodName = sootMethod.getName();
                            if (!defaults.containsKey(methodName)) continue;
                            AnnotationElem e = (AnnotationElem)defaults.get(methodName);
                            Type annotationType = this.getSootType(e);
                            boolean isCorrectType = false;
                            if (annotationType == null) {
                                isCorrectType = true;
                            } else if (annotationType.equals(sootMethod.getReturnType())) {
                                isCorrectType = true;
                            } else if (annotationType.equals(this.ARRAY_TYPE) && sootMethod.getReturnType() instanceof ArrayType) {
                                isCorrectType = true;
                            }
                            if (!isCorrectType || sootMethod.getParameterCount() != 0) continue;
                            e.setName("default");
                            AnnotationDefaultTag d = new AnnotationDefaultTag(e);
                            sootMethod.addTag(d);
                            defaults.remove(sootMethod.getName());
                        }
                        for (Map.Entry entry : defaults.entrySet()) {
                            SootMethod found = this.clazz.getMethodByNameUnsafe((String)entry.getKey());
                            AnnotationElem element = (AnnotationElem)entry.getValue();
                            if (found == null) continue;
                            element.setName("default");
                            AnnotationDefaultTag d = new AnnotationDefaultTag(element);
                            found.addTag(d);
                        }
                    }
                }
                if (vt.getVisibility() == 1) continue;
                this.clazz.addTag(vt);
                continue;
            }
            this.clazz.addTag(t);
        }
    }

    private Type getSootType(AnnotationElem e) {
        Type annotationType;
        switch (e.getKind()) {
            case '[': {
                annotationType = this.ARRAY_TYPE;
                AnnotationArrayElem array = (AnnotationArrayElem)e;
                if (array.getNumValues() <= 0) break;
                AnnotationElem firstElement = array.getValueAt(0);
                Type type = this.getSootType(firstElement);
                if (type == null) {
                    return null;
                }
                if (type.equals(this.ARRAY_TYPE)) {
                    return this.ARRAY_TYPE;
                }
                return ArrayType.v(type, 1);
            }
            case 's': {
                annotationType = RefType.v("java.lang.String");
                break;
            }
            case 'c': {
                annotationType = RefType.v("java.lang.Class");
                break;
            }
            case 'e': {
                AnnotationEnumElem enumElem = (AnnotationEnumElem)e;
                annotationType = Util.getType(enumElem.getTypeName());
                break;
            }
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'L': 
            case 'S': 
            case 'V': 
            case 'Z': {
                annotationType = Util.getType(String.valueOf(e.getKind()));
                break;
            }
            default: {
                annotationType = null;
            }
        }
        return annotationType;
    }

    public void handleFieldAnnotation(Host h, Field f) {
        List<Tag> tags;
        Set aSet = f.getAnnotations();
        if (aSet != null && !aSet.isEmpty() && (tags = this.handleAnnotation(aSet, null)) != null) {
            for (Tag t : tags) {
                if (t == null) continue;
                h.addTag(t);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handleMethodAnnotation(Host h, Method method) {
        boolean bl;
        List<Tag> tags;
        Set aSet = method.getAnnotations();
        if (aSet != null && !aSet.isEmpty() && (tags = this.handleAnnotation(aSet, null)) != null) {
            for (Tag tag : tags) {
                if (tag == null) continue;
                h.addTag(tag);
            }
        }
        String[] parameterNames = null;
        int i = 0;
        for (MethodParameter p : method.getParameters()) {
            String name = p.getName();
            if (name != null) {
                parameterNames = new String[method.getParameters().size()];
                parameterNames[i] = name;
            }
            ++i;
        }
        if (parameterNames != null) {
            h.addTag(new ParamNamesTag(parameterNames));
        }
        boolean bl2 = false;
        List parameters = method.getParameters();
        for (MethodParameter p : parameters) {
            if (p.getAnnotations().size() <= 0) continue;
            bl = true;
            break;
        }
        if (!bl) return;
        VisibilityParameterAnnotationTag tag = new VisibilityParameterAnnotationTag(parameters.size(), 0);
        for (MethodParameter p : parameters) {
            List<Tag> tags2 = this.handleAnnotation(p.getAnnotations(), null);
            if (tags2 == null) {
                tag.addVisibilityAnnotation(null);
                continue;
            }
            VisibilityAnnotationTag paramVat = new VisibilityAnnotationTag(0);
            tag.addVisibilityAnnotation(paramVat);
            for (Tag t : tags2) {
                if (t == null) continue;
                AnnotationTag vat = null;
                if (!(t instanceof VisibilityAnnotationTag)) {
                    if (t instanceof DeprecatedTag) {
                        vat = new AnnotationTag("Ljava/lang/Deprecated;");
                    } else {
                        if (!(t instanceof SignatureTag)) throw new RuntimeException("error: unhandled tag for parameter annotation in method " + h + " (" + t + ").");
                        SignatureTag sig = (SignatureTag)t;
                        ArrayList<AnnotationElem> sigElements = new ArrayList<AnnotationElem>();
                        for (String s : SootToDexUtils.splitSignature(sig.getSignature())) {
                            sigElements.add(new AnnotationStringElem(s, 's', "value"));
                        }
                        AnnotationArrayElem elem = new AnnotationArrayElem(sigElements, '[', "value");
                        vat = new AnnotationTag("Ldalvik/annotation/Signature;", Collections.singleton(elem));
                    }
                } else {
                    vat = ((VisibilityAnnotationTag)t).getAnnotations().get(0);
                }
                paramVat.addAnnotation(vat);
            }
        }
        if (tag.getVisibilityAnnotations().size() <= 0) return;
        h.addTag(tag);
    }

    private List<Tag> handleAnnotation(Set<? extends Annotation> annotations, String classType) {
        if (annotations == null || annotations.size() == 0) {
            return null;
        }
        ArrayList<Tag> tags = new ArrayList<Tag>();
        VisibilityAnnotationTag[] vatg = new VisibilityAnnotationTag[3];
        for (Annotation annotation2 : annotations) {
            this.addAnnotation(classType, tags, vatg, annotation2);
        }
        for (VisibilityAnnotationTag vat : vatg) {
            if (vat == null) continue;
            tags.add(vat);
        }
        return tags;
    }

    protected void addAnnotation(String classType, List<Tag> tags, VisibilityAnnotationTag[] vatg, Annotation a) {
        int v = DexAnnotation.getVisibility(a.getVisibility());
        Tag t = null;
        Type atype = DexType.toSoot(a.getType());
        String atypes = atype.toString();
        int eSize = a.getElements().size();
        switch (atypes) {
            case "dalvik.annotation.AnnotationDefault": {
                if (eSize != 1) {
                    throw new RuntimeException("error: expected 1 element for annotation Default. Got " + eSize + " instead.");
                }
                AnnotationElem anne = this.getElements(a.getElements()).get(0);
                AnnotationTag adt = new AnnotationTag(a.getType());
                adt.addElem(anne);
                if (vatg[v] == null) {
                    vatg[v] = new VisibilityAnnotationTag(v);
                }
                vatg[v].addAnnotation(adt);
                break;
            }
            case "dalvik.annotation.EnclosingClass": {
                if (eSize != 1) {
                    throw new RuntimeException("error: expected 1 element for annotation EnclosingClass. Got " + eSize + " instead.");
                }
                for (AnnotationElement elem : a.getElements()) {
                    String outerClass = ((TypeEncodedValue)elem.getValue()).getValue();
                    if ((outerClass = Util.dottedClassName(outerClass)).equals(this.clazz.getName())) {
                        if (outerClass.contains("$-")) {
                            outerClass = outerClass.substring(0, outerClass.indexOf("$-"));
                        } else if (outerClass.contains("$")) {
                            outerClass = outerClass.substring(0, outerClass.lastIndexOf("$"));
                        }
                    }
                    this.deps.typesToSignature.add(RefType.v(outerClass));
                    this.clazz.setOuterClass(SootResolver.v().makeClassRef(outerClass));
                    assert (this.clazz.getOuterClass() != this.clazz);
                }
                return;
            }
            case "dalvik.annotation.EnclosingMethod": {
                if (eSize == 0) {
                    return;
                }
                if (eSize != 1) {
                    throw new RuntimeException("error: expected 1 element for annotation EnclosingMethod. Got " + eSize + " instead.");
                }
                AnnotationStringElem e = (AnnotationStringElem)this.getElements(a.getElements()).get(0);
                String[] split1 = e.getValue().split("\\ \\|");
                if (split1.length < 4) {
                    logger.debug("Invalid or unsupported dalvik EnclosingMethod annotation value: \"{}\"", (Object)e.getValue());
                    break;
                }
                String classString = split1[0];
                String methodString = split1[1];
                String parameters = split1[2];
                String returnType = split1[3];
                String methodSigString = "(" + parameters + ")" + returnType;
                t = new EnclosingMethodTag(classString, methodString, methodSigString);
                String outerClass = classString.replace("/", ".");
                this.deps.typesToSignature.add(RefType.v(outerClass));
                this.clazz.setOuterClass(SootResolver.v().makeClassRef(outerClass));
                assert (this.clazz.getOuterClass() != this.clazz);
                break;
            }
            case "dalvik.annotation.InnerClass": {
                String outerClass;
                int accessFlags = -1;
                String name = null;
                for (AnnotationElem ele : this.getElements(a.getElements())) {
                    if (ele instanceof AnnotationIntElem && ele.getName().equals("accessFlags")) {
                        accessFlags = ((AnnotationIntElem)ele).getValue();
                        continue;
                    }
                    if (ele instanceof AnnotationStringElem && ele.getName().equals("name")) {
                        name = ((AnnotationStringElem)ele).getValue();
                        continue;
                    }
                    throw new RuntimeException("Unexpected inner class annotation element");
                }
                if (this.clazz.hasOuterClass()) {
                    outerClass = this.clazz.getOuterClass().getName();
                } else if (classType.contains("$-")) {
                    outerClass = classType.substring(0, classType.indexOf("$-"));
                    if (Util.isByteCodeClassName(classType)) {
                        outerClass = outerClass + ";";
                    }
                } else if (classType.contains("$")) {
                    outerClass = classType.substring(0, classType.lastIndexOf("$")) + ";";
                    if (Util.isByteCodeClassName(classType)) {
                        outerClass = outerClass + ";";
                    }
                } else {
                    outerClass = null;
                }
                InnerClassTag innerTag = new InnerClassTag(DexType.toSootICAT(classType), outerClass == null ? null : DexType.toSootICAT(outerClass), name, accessFlags);
                tags.add(innerTag);
                if (outerClass != null && !this.clazz.hasOuterClass()) {
                    String sootOuterClass = Util.dottedClassName(outerClass);
                    this.deps.typesToSignature.add(RefType.v(sootOuterClass));
                    this.clazz.setOuterClass(SootResolver.v().makeClassRef(sootOuterClass));
                    assert (this.clazz.getOuterClass() != this.clazz);
                }
                return;
            }
            case "dalvik.annotation.MemberClasses": {
                AnnotationArrayElem arre = (AnnotationArrayElem)this.getElements(a.getElements()).get(0);
                for (AnnotationElem ae : arre.getValues()) {
                    String name;
                    String outerClass;
                    int i;
                    AnnotationClassElem c = (AnnotationClassElem)ae;
                    String innerClass = c.getDesc();
                    if (innerClass.contains("$-")) {
                        i = innerClass.indexOf("$-");
                        outerClass = innerClass.substring(0, i);
                        name = innerClass.substring(i + 2).replaceAll(";$", "");
                    } else if (innerClass.contains("$")) {
                        i = innerClass.lastIndexOf("$");
                        outerClass = innerClass.substring(0, i);
                        name = innerClass.substring(i + 1).replaceAll(";$", "");
                    } else {
                        outerClass = null;
                        name = null;
                    }
                    if (name != null && name.matches("^\\d*$")) {
                        name = null;
                    }
                    int accessFlags = 0;
                    InnerClassTag innerTag = new InnerClassTag(DexType.toSootICAT(innerClass), outerClass == null ? null : DexType.toSootICAT(outerClass), name, accessFlags);
                    tags.add(innerTag);
                }
                return;
            }
            case "dalvik.annotation.Signature": {
                if (eSize != 1) {
                    throw new RuntimeException("error: expected 1 element for annotation Signature. Got " + eSize + " instead. Class " + classType);
                }
                AnnotationArrayElem arre = (AnnotationArrayElem)this.getElements(a.getElements()).get(0);
                String sig = "";
                for (AnnotationElem ae : arre.getValues()) {
                    AnnotationStringElem s = (AnnotationStringElem)ae;
                    sig = sig + s.getValue();
                }
                t = new SignatureTag(sig);
                break;
            }
            case "dalvik.annotation.Throws": {
                return;
            }
            case "java.lang.Deprecated": {
                if (eSize > 2) {
                    throw new RuntimeException("error: expected up to 2 attributes for annotation Deprecated. Got " + eSize + " instead. Class " + classType);
                }
                Boolean forRemoval = null;
                String since = null;
                for (AnnotationElem elem : this.getElements(a.getElements())) {
                    if (elem instanceof AnnotationBooleanElem && "forRemoval".equals(elem.getName())) {
                        forRemoval = ((AnnotationBooleanElem)elem).getValue();
                        continue;
                    }
                    if (elem instanceof AnnotationStringElem && "since".equals(elem.getName())) {
                        since = ((AnnotationStringElem)elem).getValue();
                        continue;
                    }
                    throw new RuntimeException("Unsupported attribute in Deprecated annotation found in class " + classType + " " + elem);
                }
                t = new DeprecatedTag(forRemoval, since);
                AnnotationTag deprecated = new AnnotationTag("Ljava/lang/Deprecated;");
                if (vatg[v] == null) {
                    vatg[v] = new VisibilityAnnotationTag(v);
                }
                vatg[v].addAnnotation(deprecated);
                break;
            }
            default: {
                this.addNormalAnnotation(vatg, a, v);
            }
        }
        tags.add(t);
    }

    protected void addNormalAnnotation(VisibilityAnnotationTag[] vatg, Annotation a, int v) {
        if (vatg[v] == null) {
            vatg[v] = new VisibilityAnnotationTag(v);
        }
        AnnotationTag tag = new AnnotationTag(a.getType());
        for (AnnotationElem e : this.getElements(a.getElements())) {
            tag.addElem(e);
        }
        vatg[v].addAnnotation(tag);
    }

    private ArrayList<AnnotationElem> getElements(Set<? extends AnnotationElement> set) {
        ArrayList<AnnotationElem> aelemList = new ArrayList<AnnotationElem>();
        for (AnnotationElement annotationElement : set) {
            logger.trace("element: {}={} type: {}", new Object[]{annotationElement.getName(), annotationElement.getValue(), annotationElement.getClass()});
            ArrayList<AnnotationElem> eList = this.handleAnnotationElement(annotationElement, Collections.singletonList(annotationElement.getValue()));
            if (eList == null) continue;
            aelemList.addAll(eList);
        }
        return aelemList;
    }

    private ArrayList<AnnotationElem> handleAnnotationElement(AnnotationElement ae, List<? extends EncodedValue> evList) {
        ArrayList<AnnotationElem> aelemList = new ArrayList<AnnotationElem>();
        for (EncodedValue encodedValue : evList) {
            int type = encodedValue.getValueType();
            AnnotationElem elem = null;
            switch (type) {
                case 0: {
                    ByteEncodedValue v = (ByteEncodedValue)encodedValue;
                    elem = new AnnotationIntElem(v.getValue(), 'B', ae.getName());
                    break;
                }
                case 2: {
                    ByteEncodedValue v = (ShortEncodedValue)encodedValue;
                    elem = new AnnotationIntElem(v.getValue(), 'S', ae.getName());
                    break;
                }
                case 3: {
                    ByteEncodedValue v = (CharEncodedValue)encodedValue;
                    elem = new AnnotationIntElem(v.getValue(), 'C', ae.getName());
                    break;
                }
                case 4: {
                    ByteEncodedValue v = (IntEncodedValue)encodedValue;
                    elem = new AnnotationIntElem(v.getValue(), 'I', ae.getName());
                    break;
                }
                case 6: {
                    ByteEncodedValue v = (LongEncodedValue)encodedValue;
                    elem = new AnnotationLongElem(v.getValue(), 'J', ae.getName());
                    break;
                }
                case 16: {
                    ByteEncodedValue v = (FloatEncodedValue)encodedValue;
                    elem = new AnnotationFloatElem(v.getValue(), 'F', ae.getName());
                    break;
                }
                case 17: {
                    ByteEncodedValue v = (DoubleEncodedValue)encodedValue;
                    elem = new AnnotationDoubleElem(v.getValue(), 'D', ae.getName());
                    break;
                }
                case 23: {
                    ByteEncodedValue v = (StringEncodedValue)encodedValue;
                    elem = new AnnotationStringElem(v.getValue(), 's', ae.getName());
                    break;
                }
                case 24: {
                    ByteEncodedValue v = (TypeEncodedValue)encodedValue;
                    elem = new AnnotationClassElem(v.getValue(), 'c', ae.getName());
                    break;
                }
                case 25: {
                    ByteEncodedValue v = (FieldEncodedValue)encodedValue;
                    FieldReference fr = v.getValue();
                    String fieldSig = "";
                    fieldSig = fieldSig + DexType.toSootAT(fr.getDefiningClass()) + ": ";
                    fieldSig = fieldSig + DexType.toSootAT(fr.getType()) + " ";
                    fieldSig = fieldSig + fr.getName();
                    elem = new AnnotationStringElem(fieldSig, 'f', ae.getName());
                    break;
                }
                case 26: {
                    ByteEncodedValue v = (MethodEncodedValue)encodedValue;
                    MethodReference mr = v.getValue();
                    String className = DexType.toSootICAT(mr.getDefiningClass());
                    String returnType = DexType.toSootAT(mr.getReturnType());
                    String methodName = mr.getName();
                    String parameters = "";
                    for (CharSequence p : mr.getParameterTypes()) {
                        parameters = parameters + DexType.toSootAT(p.toString());
                    }
                    String mSig = className + " |" + methodName + " |" + parameters + " |" + returnType;
                    elem = new AnnotationStringElem(mSig, 'M', ae.getName());
                    break;
                }
                case 27: {
                    ByteEncodedValue v = (EnumEncodedValue)encodedValue;
                    FieldReference fr = v.getValue();
                    elem = new AnnotationEnumElem(DexType.toSootAT(fr.getType()).toString(), fr.getName(), 'e', ae.getName());
                    break;
                }
                case 28: {
                    ByteEncodedValue v = (ArrayEncodedValue)encodedValue;
                    ArrayList<AnnotationElem> l = this.handleAnnotationElement(ae, v.getValue());
                    if (l == null) break;
                    elem = new AnnotationArrayElem(l, '[', ae.getName());
                    break;
                }
                case 29: {
                    ByteEncodedValue v = (AnnotationEncodedValue)encodedValue;
                    AnnotationTag t = new AnnotationTag(DexType.toSootAT(v.getType()).toString());
                    for (AnnotationElement newElem : v.getElements()) {
                        ArrayList<EncodedValue> l = new ArrayList<EncodedValue>();
                        l.add(newElem.getValue());
                        ArrayList<AnnotationElem> aList = this.handleAnnotationElement(newElem, l);
                        if (aList == null) continue;
                        for (AnnotationElem e : aList) {
                            t.addElem(e);
                        }
                    }
                    elem = new AnnotationAnnotationElem(t, '@', ae.getName());
                    break;
                }
                case 30: {
                    elem = new AnnotationStringElem(null, 'N', ae.getName());
                    break;
                }
                case 31: {
                    ByteEncodedValue v = (BooleanEncodedValue)encodedValue;
                    elem = new AnnotationBooleanElem(v.getValue(), 'Z', ae.getName());
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown annotation element 0x" + Integer.toHexString(type));
                }
            }
            if (elem == null) continue;
            aelemList.add(elem);
        }
        return aelemList;
    }

    protected static int getVisibility(int visibility) {
        switch (AnnotationVisibility.getVisibility((int)visibility)) {
            case "runtime": {
                return 0;
            }
            case "system": {
                return 1;
            }
            case "build": {
                return 2;
            }
        }
        throw new RuntimeException(String.format("error: unknown annotation visibility: '%d'", visibility));
    }

    class MyAnnotations {
        List<AnnotationTag> annotationList = new ArrayList<AnnotationTag>();
        List<Integer> visibilityList = new ArrayList<Integer>();

        MyAnnotations() {
        }

        public void add(AnnotationTag a, int visibility) {
            this.annotationList.add(a);
            this.visibilityList.add(new Integer(visibility));
        }

        public List<AnnotationTag> getAnnotations() {
            return this.annotationList;
        }

        public List<Integer> getVisibilityList() {
            return this.visibilityList;
        }
    }
}

