/*
 * Decompiled with CFR 0.152.
 */
package soot.dotnet.instructions;

import java.util.ArrayList;
import java.util.List;
import soot.Body;
import soot.Local;
import soot.Scene;
import soot.SootClass;
import soot.SootMethodRef;
import soot.Type;
import soot.Value;
import soot.dotnet.instructions.AbstractCilnstruction;
import soot.dotnet.instructions.CilBlock;
import soot.dotnet.instructions.CilInstruction;
import soot.dotnet.instructions.CilInstructionFactory;
import soot.dotnet.members.AbstractDotnetMember;
import soot.dotnet.members.DotnetMethod;
import soot.dotnet.members.method.DotnetBody;
import soot.dotnet.proto.ProtoAssemblyAllTypes;
import soot.dotnet.proto.ProtoIlInstructions;
import soot.dotnet.types.DotnetTypeFactory;
import soot.jimple.AssignStmt;
import soot.jimple.CastExpr;
import soot.jimple.InvokeStmt;
import soot.jimple.Jimple;
import soot.toolkits.scalar.Pair;

public class CilCallVirtInstruction
extends AbstractCilnstruction {
    private SootClass clazz;
    private DotnetMethod method;
    private final List<Pair<Local, Local>> localsToCastForCall = new ArrayList<Pair<Local, Local>>();

    public CilCallVirtInstruction(ProtoIlInstructions.IlInstructionMsg instruction, DotnetBody dotnetBody, CilBlock cilBlock) {
        super(instruction, dotnetBody, cilBlock);
    }

    @Override
    public void jimplify(Body jb) {
        List<Pair<Local, Local>> locals;
        CilInstruction cilExpr = CilInstructionFactory.fromInstructionMsg(this.instruction, this.dotnetBody, this.cilBlock);
        Value value = cilExpr.jimplifyExpr(jb);
        InvokeStmt invokeStmt = Jimple.v().newInvokeStmt(value);
        if (cilExpr instanceof CilCallVirtInstruction && (locals = ((CilCallVirtInstruction)cilExpr).getLocalsToCastForCall()).size() != 0) {
            for (Pair<Local, Local> pair : locals) {
                CastExpr castExpr = Jimple.v().newCastExpr(pair.getO1(), pair.getO2().getType());
                AssignStmt assignStmt = Jimple.v().newAssignStmt(pair.getO2(), castExpr);
                jb.getUnits().add(assignStmt);
            }
        }
        jb.getUnits().add(invokeStmt);
    }

    @Override
    public Value jimplifyExpr(Body jb) {
        this.clazz = Scene.v().getSootClass(this.instruction.getMethod().getDeclaringType().getFullname());
        this.method = new DotnetMethod(this.instruction.getMethod(), this.clazz);
        if (this.method.isStatic()) {
            this.checkMethodAvailable();
            ArrayList<Local> argsVariables = new ArrayList<Local>();
            ArrayList<Type> argsTypes = new ArrayList<Type>();
            Value rewriteField = AbstractDotnetMember.checkRewriteCilSpecificMember(this.clazz, this.method.getName());
            if (rewriteField != null) {
                return rewriteField;
            }
            for (int z = 0; z < this.instruction.getArgumentsCount(); ++z) {
                Value variableValue = CilInstructionFactory.fromInstructionMsg(this.instruction.getArguments(z), this.dotnetBody, this.cilBlock).jimplifyExpr(jb);
                this.checkVariabelIsLocal(variableValue, z, false);
                Local variable = (Local)variableValue;
                argsVariables.add(variable);
            }
            for (ProtoAssemblyAllTypes.ParameterDefinition parameterDefinition : this.method.getParameterDefinitions()) {
                argsTypes.add(DotnetTypeFactory.toSootType(parameterDefinition.getType()));
            }
            String methodName = this.method.getUniqueName();
            SootMethodRef methodRef = Scene.v().makeMethodRef(this.clazz, DotnetMethod.convertCtorName(methodName), argsTypes, DotnetTypeFactory.toSootType(this.method.getReturnType()), true);
            return Jimple.v().newStaticInvokeExpr(methodRef, argsVariables);
        }
        if (this.clazz.isInterface()) {
            MethodParams methodParams = this.getMethodCallParams(jb);
            return Jimple.v().newInterfaceInvokeExpr(methodParams.Base, methodParams.MethodRef, methodParams.ArgumentVariables);
        }
        if (this.instruction.getMethod().getIsConstructor() || this.instruction.getMethod().getAccessibility().equals((Object)ProtoAssemblyAllTypes.Accessibility.PRIVATE)) {
            MethodParams methodParams = this.getMethodCallParams(jb);
            return Jimple.v().newSpecialInvokeExpr(methodParams.Base, methodParams.MethodRef, methodParams.ArgumentVariables);
        }
        MethodParams methodParams = this.getMethodCallParams(jb);
        return Jimple.v().newVirtualInvokeExpr(methodParams.Base, methodParams.MethodRef, methodParams.ArgumentVariables);
    }

    public List<Pair<Local, Local>> getLocalsToCastForCall() {
        return this.localsToCastForCall;
    }

    private MethodParams getMethodCallParams(Body jb) {
        this.checkMethodAvailable();
        ArrayList<Local> argsVariables = new ArrayList<Local>();
        ArrayList<Type> methodParamTypes = new ArrayList<Type>();
        if (this.instruction.getArgumentsCount() == 0) {
            throw new RuntimeException("Opcode: " + (Object)((Object)this.instruction.getOpCode()) + ": Given method " + this.method.getName() + " of declared type " + this.method.getDeclaringClass().getName() + " has no arguments! This means there is no base variable for the virtual invoke!");
        }
        Value baseValue = CilInstructionFactory.fromInstructionMsg(this.instruction.getArguments(0), this.dotnetBody, this.cilBlock).jimplifyExpr(jb);
        this.checkVariabelIsLocal(baseValue, 0, true);
        Local base = (Local)baseValue;
        if (this.instruction.getArgumentsCount() > 1) {
            for (int z = 1; z < this.instruction.getArgumentsCount(); ++z) {
                Value variableValue = CilInstructionFactory.fromInstructionMsg(this.instruction.getArguments(z), this.dotnetBody, this.cilBlock).jimplifyExpr(jb);
                this.checkVariabelIsLocal(variableValue, z, false);
                Local variable = (Local)variableValue;
                argsVariables.add(variable);
            }
            for (ProtoAssemblyAllTypes.ParameterDefinition parameterDefinition : this.instruction.getMethod().getParameterList()) {
                methodParamTypes.add(DotnetTypeFactory.toSootType(parameterDefinition.getType()));
            }
        }
        for (int i = 0; i < argsVariables.size(); ++i) {
            Local arg = (Local)argsVariables.get(i);
            Type methodParam = (Type)methodParamTypes.get(i);
            if (!arg.getType().toString().equals("System.Object") || methodParam.toString().equals("System.Object")) continue;
            Local castLocal = this.dotnetBody.variableManager.localGenerator.generateLocal(methodParam);
            this.localsToCastForCall.add(new Pair<Local, Local>(arg, castLocal));
            argsVariables.set(i, castLocal);
        }
        String methodName = this.method.getUniqueName();
        Type return_type = this.method.getReturnType().getTypeKind().equals((Object)ProtoAssemblyAllTypes.TypeKindDef.POINTER) && this.method.getReturnType().getFullname().equals("System.Void") ? DotnetTypeFactory.toSootType(this.method.getProtoMessage().getDeclaringType()) : DotnetTypeFactory.toSootType(this.method.getProtoMessage().getReturnType());
        SootMethodRef methodRef = Scene.v().makeMethodRef(this.clazz, DotnetMethod.convertCtorName(methodName), methodParamTypes, return_type, false);
        return new MethodParams(base, methodRef, argsVariables);
    }

    private void checkMethodAvailable() {
        if (this.method.getName().trim().isEmpty()) {
            throw new RuntimeException("Opcode: " + (Object)((Object)this.instruction.getOpCode()) + ": Given method " + this.method.getName() + " of declared type " + this.method.getDeclaringClass().getName() + " has no method name!");
        }
    }

    private void checkVariabelIsLocal(Value var, int argPos, boolean isBase) {
        String err = "CALL: The given argument ";
        err = err + argPos;
        err = err + " ";
        if (isBase) {
            err = err + "(base variable)";
        }
        err = err + " of invoked method " + this.method.getName() + " declared in " + this.clazz.getName() + " is not a local! The value is: " + var.toString() + " of type " + var.getType() + "! The resolving method body is: " + this.dotnetBody.getDotnetMethodSig().getSootMethodSignature().getSignature();
        if (!(var instanceof Local)) {
            throw new RuntimeException(err);
        }
    }

    private static class MethodParams {
        public Local Base;
        public SootMethodRef MethodRef;
        public List<Local> ArgumentVariables;

        public MethodParams(Local base, SootMethodRef methodRef, List<Local> argumentVariables) {
            this.Base = base;
            this.MethodRef = methodRef;
            this.ArgumentVariables = argumentVariables;
        }
    }
}

