/*
 * Decompiled with CFR 0.152.
 */
package soot.dotnet.instructions;

import soot.Body;
import soot.ByteType;
import soot.DoubleType;
import soot.FloatType;
import soot.IntType;
import soot.LongType;
import soot.ShortType;
import soot.Type;
import soot.UnknownType;
import soot.Value;
import soot.dotnet.exceptions.NoStatementInstructionException;
import soot.dotnet.instructions.AbstractCilnstruction;
import soot.dotnet.instructions.CilBlock;
import soot.dotnet.instructions.CilInstruction;
import soot.dotnet.instructions.CilInstructionFactory;
import soot.dotnet.members.method.DotnetBody;
import soot.dotnet.proto.ProtoIlInstructions;
import soot.jimple.Jimple;

public class CilConvInstruction
extends AbstractCilnstruction {
    public CilConvInstruction(ProtoIlInstructions.IlInstructionMsg instruction, DotnetBody dotnetBody, CilBlock cilBlock) {
        super(instruction, dotnetBody, cilBlock);
    }

    @Override
    public void jimplify(Body jb) {
        throw new NoStatementInstructionException(this.instruction);
    }

    @Override
    public Value jimplifyExpr(Body jb) {
        Type convType;
        ProtoIlInstructions.IlInstructionMsg.IlSign inputSign = this.instruction.getSign();
        ProtoIlInstructions.IlInstructionMsg.IlStackType inputType = this.instruction.getInputType();
        ProtoIlInstructions.IlInstructionMsg.IlPrimitiveType targetType = this.instruction.getTargetType();
        ProtoIlInstructions.IlInstructionMsg.IlStackType resultType = this.instruction.getResultType();
        CilInstruction cilExpr = CilInstructionFactory.fromInstructionMsg(this.instruction.getArgument(), this.dotnetBody, this.cilBlock);
        Value argument = cilExpr.jimplifyExpr(jb);
        switch (targetType) {
            case I1: 
            case U1: {
                convType = ByteType.v();
                break;
            }
            case I2: 
            case U2: {
                convType = ShortType.v();
                break;
            }
            case I4: 
            case U4: 
            case I: 
            case U: 
            case Ref: {
                convType = IntType.v();
                break;
            }
            case I8: 
            case U8: {
                convType = LongType.v();
                break;
            }
            case R4: {
                convType = FloatType.v();
                break;
            }
            case R: 
            case R8: {
                convType = DoubleType.v();
                break;
            }
            default: {
                convType = UnknownType.v();
            }
        }
        return Jimple.v().newCastExpr(argument, convType);
    }
}

